/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.CharConversionException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.util.Comparator;
import java.util.Locale;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

public final class String
implements Serializable,
Comparable {
    private char[] value;
    private int offset;
    private int count;
    private int hash = 0;
    private static ThreadLocal btcConverter = null;
    private static ThreadLocal ctbConverter = null;
    private static final long serialVersionUID = -6849794470754667710L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    private static ByteToCharConverter getBTCConverter(String string) throws UnsupportedEncodingException {
        SoftReference softReference;
        ByteToCharConverter byteToCharConverter = null;
        if (btcConverter == null) {
            btcConverter = new ThreadLocal();
        }
        if ((softReference = (SoftReference)btcConverter.get()) == null || (byteToCharConverter = (ByteToCharConverter)softReference.get()) == null || !string.equals(byteToCharConverter.getCharacterEncoding())) {
            byteToCharConverter = ByteToCharConverter.getConverter(string);
            btcConverter.set(new SoftReference(byteToCharConverter));
        } else {
            byteToCharConverter.reset();
        }
        return byteToCharConverter;
    }

    private static CharToByteConverter getCTBConverter(String string) throws UnsupportedEncodingException {
        SoftReference softReference;
        CharToByteConverter charToByteConverter = null;
        if (ctbConverter == null) {
            ctbConverter = new ThreadLocal();
        }
        if ((softReference = (SoftReference)ctbConverter.get()) == null || (charToByteConverter = (CharToByteConverter)softReference.get()) == null || !string.equals(charToByteConverter.getCharacterEncoding())) {
            charToByteConverter = CharToByteConverter.getConverter(string);
            ctbConverter.set(new SoftReference(charToByteConverter));
        } else {
            charToByteConverter.reset();
        }
        return charToByteConverter;
    }

    public String() {
        this.value = new char[0];
    }

    public String(String string) {
        this.count = string.length();
        this.value = new char[this.count];
        string.getChars(0, this.count, this.value, 0);
    }

    public String(char[] cArray) {
        this.count = cArray.length;
        this.value = new char[this.count];
        System.arraycopy(cArray, 0, this.value, 0, this.count);
    }

    public String(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        this.value = new char[n2];
        this.count = n2;
        System.arraycopy(cArray, n, this.value, 0, n2);
    }

    public String(byte[] byArray, int n, int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > byArray.length - n3) {
            throw new StringIndexOutOfBoundsException(n2 + n3);
        }
        char[] cArray = new char[n3];
        this.count = n3;
        this.value = cArray;
        if (n == 0) {
            int n4 = n3;
            while (n4-- > 0) {
                cArray[n4] = (char)(byArray[n4 + n2] & 0xFF);
            }
        } else {
            n <<= 8;
            int n5 = n3;
            while (n5-- > 0) {
                cArray[n5] = (char)(n | byArray[n5 + n2] & 0xFF);
            }
        }
    }

    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    private String(byte[] byArray, int n, int n2, ByteToCharConverter byteToCharConverter) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("length must be >= 0");
        }
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("offset must be >= 0");
        }
        if (n > byArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + this.count);
        }
        int n3 = byteToCharConverter.getMaxCharsPerByte() * n2;
        this.value = new char[n3];
        try {
            this.count = byteToCharConverter.convert(byArray, n, n + n2, this.value, 0, n3);
            this.count += byteToCharConverter.flush(this.value, byteToCharConverter.nextCharIndex(), n3);
        }
        catch (CharConversionException charConversionException) {
            this.count = byteToCharConverter.nextCharIndex();
        }
        if (this.count < n3) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this(byArray, n, n2, String.getBTCConverter(string));
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, ByteToCharConverter.getDefault());
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length, ByteToCharConverter.getDefault());
    }

    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            stringBuffer.setShared();
            this.value = stringBuffer.getValue();
            this.offset = 0;
            this.count = stringBuffer.length();
        }
    }

    private String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2;
    }

    public int length() {
        return this.count;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n + this.offset];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        int n4 = n3;
        int n5 = this.offset + n2;
        int n6 = this.offset + n;
        char[] cArray = this.value;
        while (n6 < n5) {
            byArray[n4++] = (byte)cArray[n6++];
        }
    }

    private byte[] getBytes(CharToByteConverter charToByteConverter) {
        charToByteConverter.reset();
        int n = charToByteConverter.getMaxBytesPerChar() * this.count;
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            n2 += charToByteConverter.convertAny(this.value, this.offset, this.offset + this.count, byArray, 0, n);
        }
        catch (CharConversionException charConversionException) {
            throw new InternalError("Converter malfunction: " + charToByteConverter.getClass().getName());
        }
        if ((n2 += charToByteConverter.flushAny(byArray, charToByteConverter.nextByteIndex(), n)) < n) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.getBytes(String.getCTBConverter(string));
    }

    public byte[] getBytes() {
        return this.getBytes(CharToByteConverter.getDefault());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = this.count;
            if (n == string.count) {
                char[] cArray = this.value;
                char[] cArray2 = string.value;
                int n2 = this.offset;
                int n3 = string.offset;
                while (n-- != 0) {
                    if (cArray[n2++] == cArray2[n3++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        return string != null && string.count == this.count && this.regionMatches(true, 0, string, 0, this.count);
    }

    public int compareTo(String string) {
        int n = this.count;
        int n2 = string.count;
        int n3 = Math.min(n, n2);
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n4 = this.offset;
        int n5 = string.offset;
        while (n3-- != 0) {
            char c;
            char c2;
            if ((c2 = cArray[n4++]) == (c = cArray2[n5++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public int compareTo(Object object) {
        return this.compareTo((String)object);
    }

    public int compareToIgnoreCase(String string) {
        return CASE_INSENSITIVE_ORDER.compare(this, string);
    }

    /*
     * Unable to fully structure code
     */
    public boolean regionMatches(int var1_1, String var2_2, int var3_3, int var4_4) {
        var5_5 = this.value;
        var6_6 = this.offset + var1_1;
        var7_7 = this.offset + this.count;
        var8_8 = var2_2.value;
        var9_9 = var2_2.offset + var3_3;
        if (var3_3 >= 0 && var1_1 >= 0 && (long)var1_1 <= (long)this.count - (long)var4_4 && (long)var3_3 <= (long)var2_2.count - (long)var4_4) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (var5_5[var6_6++] == var8_8[var9_9++]) continue;
            return false;
lbl10:
            // 2 sources

            ** while (var4_4-- > 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean regionMatches(boolean var1_1, int var2_2, String var3_3, int var4_4, int var5_5) {
        var6_6 = this.value;
        var7_7 = this.offset + var2_2;
        var8_8 = this.offset + this.count;
        var9_9 = var3_3.value;
        var10_10 = var3_3.offset + var4_4;
        if (var4_4 >= 0 && var2_2 >= 0 && (long)var2_2 <= (long)this.count - (long)var5_5 && (long)var4_4 <= (long)var3_3.count - (long)var5_5) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if ((var11_11 = var6_6[var7_7++]) == (var12_12 = var9_9[var10_10++]) || var1_1 && ((var13_13 = Character.toUpperCase(var11_11)) == (var14_14 = Character.toUpperCase(var12_12)) || Character.toLowerCase(var13_13) == Character.toLowerCase(var14_14))) continue;
            return false;
lbl10:
            // 2 sources

            ** while (var5_5-- > 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(String var1_1, int var2_2) {
        var3_3 = this.value;
        var4_4 = this.offset + var2_2;
        var5_5 = this.offset + this.count;
        var6_6 = var1_1.value;
        var7_7 = var1_1.offset;
        var8_8 = var1_1.count;
        if (var2_2 >= 0 && var2_2 <= this.count - var8_8) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            if (var3_3[var4_4++] == var6_6[var7_7++]) continue;
            return false;
lbl11:
            // 2 sources

            ** while (--var8_8 >= 0)
        }
lbl12:
        // 1 sources

        return true;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.count - string.count);
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2 = this.offset;
            char[] cArray = this.value;
            int n3 = this.count;
            int n4 = 0;
            while (n4 < n3) {
                n = 31 * n + cArray[n2++];
                ++n4;
            }
            this.hash = n;
        }
        return n;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3 = this.offset + this.count;
        char[] cArray = this.value;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.count) {
            return -1;
        }
        int n4 = this.offset + n2;
        while (n4 < n3) {
            if (cArray[n4] == n) {
                return n4 - this.offset;
            }
            ++n4;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        int n3 = this.offset;
        char[] cArray = this.value;
        int n4 = this.offset + (n2 >= this.count ? this.count - 1 : n2);
        while (n4 >= n3) {
            if (cArray[n4] == n) {
                return n4 - this.offset;
            }
            --n4;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n2 = this.offset + (this.count - string.count);
        if (n >= this.count) {
            if (this.count == 0 && n == 0 && string.count == 0) {
                return 0;
            }
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (string.count == 0) {
            return n;
        }
        int n3 = string.offset;
        char c = cArray2[n3];
        int n4 = this.offset + n;
        block0: while (true) {
            if (n4 <= n2 && cArray[n4] != c) {
                ++n4;
                continue;
            }
            if (n4 > n2) {
                return -1;
            }
            int n5 = n4 + 1;
            int n6 = n5 + string.count - 1;
            int n7 = n3 + 1;
            while (n5 < n6) {
                if (cArray[n5++] == cArray2[n7++]) continue;
                ++n4;
                continue block0;
            }
            break;
        }
        return n4 - this.offset;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        int n2;
        int n3 = this.count - string.count;
        if (n < 0) {
            return -1;
        }
        if (n > n3) {
            n = n3;
        }
        if (string.count == 0) {
            return n;
        }
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n4 = string.offset + string.count - 1;
        char c = cArray2[n4];
        int n5 = this.offset + string.count - 1;
        int n6 = n5 + n;
        block0: while (true) {
            if (n6 >= n5 && cArray[n6] != c) {
                --n6;
                continue;
            }
            if (n6 < n5) {
                return -1;
            }
            int n7 = n6 - 1;
            n2 = n7 - (string.count - 1);
            int n8 = n4 - 1;
            while (n7 > n2) {
                if (cArray[n7--] == cArray2[n8--]) continue;
                --n6;
                continue block0;
            }
            break;
        }
        return n2 - this.offset + 1;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return n == 0 && n2 == this.count ? this : new String(this.offset + n, n2 - n, this.value);
    }

    public String concat(String string) {
        int n = string.length();
        if (n == 0) {
            return this;
        }
        char[] cArray = new char[this.count + n];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, n, cArray, this.count);
        return new String(0, this.count + n, cArray);
    }

    public String replace(char c, char c2) {
        if (c != c2) {
            int n = this.count;
            int n2 = -1;
            char[] cArray = this.value;
            int n3 = this.offset;
            while (++n2 < n) {
                if (cArray[n3 + n2] == c) break;
            }
            if (n2 < n) {
                char[] cArray2 = new char[n];
                int n4 = 0;
                while (n4 < n2) {
                    cArray2[n4] = cArray[n3 + n4];
                    ++n4;
                }
                while (n2 < n) {
                    char c3 = cArray[n3 + n2];
                    cArray2[n2] = c3 == c ? c2 : c3;
                    ++n2;
                }
                return new String(0, n, cArray2);
            }
        }
        return this;
    }

    public String toLowerCase(Locale locale) {
        int n;
        char[] cArray;
        int n2;
        int n3;
        block6: {
            n3 = this.count;
            n2 = this.offset;
            cArray = this.value;
            n = 0;
            while (n < n3) {
                char c = this.value[n2 + n];
                if (c == Character.toLowerCase(c)) {
                    ++n;
                    continue;
                }
                break block6;
            }
            return this;
        }
        char[] cArray2 = new char[this.count];
        System.arraycopy(cArray, n2, cArray2, 0, n);
        if (locale.getLanguage().equals("tr")) {
            int n4 = n;
            while (n4 < n3) {
                char c = cArray[n2 + n4];
                cArray2[n4] = c == 'I' ? 305 : (c == '\u0130' ? 105 : Character.toLowerCase(c));
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 < n3) {
                cArray2[n5] = Character.toLowerCase(cArray[n2 + n5]);
                ++n5;
            }
        }
        return new String(cArray2);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        int n;
        char[] cArray;
        int n2;
        int n3;
        block14: {
            n3 = this.count;
            n2 = this.offset;
            cArray = this.value;
            n = 0;
            while (n < n3) {
                char c = this.value[n2 + n];
                if (c == Character.toUpperCase(c)) {
                    ++n;
                    continue;
                }
                break block14;
            }
            return this;
        }
        char[] cArray2 = new char[n3];
        int n4 = 0;
        System.arraycopy(cArray, n2, cArray2, 0, n);
        if (locale.getLanguage().equals("tr")) {
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n2 + n5];
                if (c == 'i') {
                    cArray2[n5 + n4] = 304;
                } else if (c == '\u0131') {
                    cArray2[n5 + n4] = 73;
                } else if (c == '\u00df') {
                    char[] cArray3 = new char[cArray2.length + 1];
                    System.arraycopy(cArray2, 0, cArray3, 0, n5 + 1 + n4);
                    cArray3[n5 + n4] = 83;
                    cArray3[n5 + ++n4] = 83;
                    cArray2 = cArray3;
                } else {
                    cArray2[n5 + n4] = Character.toUpperCase(c);
                }
                ++n5;
            }
        } else {
            int n6 = n;
            while (n6 < n3) {
                char c = cArray[n2 + n6];
                if (c == '\u00df') {
                    char[] cArray4 = new char[cArray2.length + 1];
                    System.arraycopy(cArray2, 0, cArray4, 0, n6 + 1 + n4);
                    cArray4[n6 + n4] = 83;
                    cArray4[n6 + ++n4] = 83;
                    cArray2 = cArray4;
                } else {
                    cArray2[n6 + n4] = Character.toUpperCase(c);
                }
                ++n6;
            }
        }
        return new String(cArray2);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int n = this.count;
        int n2 = 0;
        int n3 = this.offset;
        char[] cArray = this.value;
        while (n2 < n && cArray[n3 + n2] <= ' ') {
            ++n2;
        }
        while (n2 < n && cArray[n3 + n - 1] <= ' ') {
            --n;
        }
        return n2 > 0 || n < this.count ? this.substring(n2, n) : this;
    }

    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        this.getChars(0, this.count, cArray, 0);
        return cArray;
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(0, 1, cArray);
    }

    public static String valueOf(int n) {
        return Integer.toString(n, 10);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    private static class CaseInsensitiveComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            int n = string.length();
            int n2 = string2.length();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n && n4 < n2) {
                char c;
                char c2 = string.charAt(n3);
                if (c2 != (c = string2.charAt(n4)) && (c2 = Character.toUpperCase(c2)) != (c = Character.toUpperCase(c)) && (c2 = Character.toLowerCase(c2)) != (c = Character.toLowerCase(c))) {
                    return c2 - c;
                }
                ++n3;
                ++n4;
            }
            return n - n2;
        }
    }
}

