/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class IconView
extends View {
    private Icon c;

    public IconView(Element element) {
        super(element);
        AttributeSet attributeSet = element.getAttributes();
        this.c = StyleConstants.getIcon(attributeSet);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.c.paintIcon(this.getContainer(), graphics, rectangle.x, rectangle.y);
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                return this.c.getIconWidth();
            }
            case 1: {
                return this.c.getIconHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                return 1.0f;
            }
        }
        return super.getAlignment(n);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n <= n3) {
            Rectangle rectangle = shape.getBounds();
            if (n == n3) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        throw new BadLocationException(n + " not in range " + n2 + "," + n3, n);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f < (float)(rectangle.x + rectangle.width / 2)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public void setSize(float f, float f2) {
    }
}

