/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class JPEGImageDecoderImpl
implements JPEGImageDecoder {
    private static final Class InputStreamClass = class$java$io$InputStream == null ? (class$java$io$InputStream = JPEGImageDecoderImpl.class$("java.io.InputStream")) : class$java$io$InputStream;
    private JPEGDecodeParam param = null;
    private InputStream input = null;
    private WritableRaster aRas = null;
    private BufferedImage aBufImg = null;
    private ColorModel cm = null;
    private boolean unpack = false;
    private boolean flip = false;
    static /* synthetic */ Class class$java$io$InputStream;

    public JPEGImageDecoderImpl(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        this.input = inputStream;
        this.initDecoder(InputStreamClass);
    }

    public JPEGImageDecoderImpl(InputStream inputStream, JPEGDecodeParam jPEGDecodeParam) {
        this(inputStream);
        this.setJPEGDecodeParam(jPEGDecodeParam);
    }

    public JPEGDecodeParam getJPEGDecodeParam() {
        if (this.param != null) {
            return (JPEGDecodeParam)this.param.clone();
        }
        return null;
    }

    public void setJPEGDecodeParam(JPEGDecodeParam jPEGDecodeParam) {
        this.param = (JPEGDecodeParam)jPEGDecodeParam.clone();
    }

    public synchronized InputStream getInputStream() {
        return this.input;
    }

    public synchronized Raster decodeAsRaster() throws ImageFormatException {
        try {
            this.param = this.readJPEGStream(this.input, this.param, false);
        }
        catch (IOException iOException) {
            System.out.println("Can't open input Stream" + iOException);
            iOException.printStackTrace();
        }
        return this.aRas;
    }

    public synchronized BufferedImage decodeAsBufferedImage() throws ImageFormatException {
        try {
            this.param = this.readJPEGStream(this.input, this.param, true);
        }
        catch (IOException iOException) {
            System.out.println("Can't open input Stream" + iOException);
            iOException.printStackTrace();
        }
        return this.aBufImg;
    }

    private native void initDecoder(Class var1);

    private synchronized native JPEGDecodeParam readJPEGStream(InputStream var1, JPEGDecodeParam var2, boolean var3) throws IOException, ImageFormatException;

    private void readTables() throws IOException {
        try {
            this.param = this.readJPEGStream(this.input, null, false);
        }
        catch (ImageFormatException imageFormatException) {
            imageFormatException.printStackTrace();
        }
    }

    private int getDecodedColorModel(int n, boolean bl) throws ImageFormatException {
        int[] nArray = new int[]{8};
        int[] nArray2 = new int[]{8, 8, 8};
        int[] nArray3 = new int[]{8, 8, 8, 8};
        this.cm = null;
        this.unpack = false;
        this.flip = false;
        if (!bl) {
            return n;
        }
        switch (n) {
            case 1: {
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, false, false, 1, 0);
                return n;
            }
            case 5: {
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1002), nArray2, false, false, 1, 0);
                return n;
            }
            case 10: {
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1002), nArray3, true, false, 3, 0);
                return n;
            }
            case 2: 
            case 3: {
                this.unpack = true;
                this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
                return 2;
            }
            case 8: 
            case 9: {
                this.flip = true;
            }
            case 6: 
            case 7: {
                this.unpack = true;
                this.cm = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                return 6;
            }
        }
        throw new ImageFormatException("Can't construct a BufferedImage for given COLOR_ID");
    }

    private Object allocateDataBuffer(int n, int n2, int n3) {
        Object[] objectArray;
        if (this.unpack) {
            if (n3 == 3) {
                int[] nArray = new int[]{0xFF0000, 65280, 255};
                this.aRas = Raster.createPackedRaster(3, n, n2, nArray, new Point(0, 0));
            } else if (n3 == 4) {
                int[] nArray = new int[]{0xFF0000, 65280, 255, -16777216};
                this.aRas = Raster.createPackedRaster(3, n, n2, nArray, new Point(0, 0));
            } else {
                throw new ImageFormatException("Can't unpack with anything other than 3 or 4 components");
            }
            objectArray = ((DataBufferInt)this.aRas.getDataBuffer()).getData();
        } else {
            this.aRas = Raster.createInterleavedRaster(0, n, n2, n3, new Point(0, 0));
            objectArray = ((DataBufferByte)this.aRas.getDataBuffer()).getData();
        }
        if (this.cm != null) {
            this.aBufImg = new BufferedImage(this.cm, this.aRas, true, null);
        }
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
    }
}

