/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import sun.jdbc.odbc.JdbcOdbcObject;

public class JdbcOdbcBoundArrayOfParams
extends JdbcOdbcObject {
    protected int numParams;
    protected Hashtable hashedLenIdx;
    protected Object[] storedParams;
    protected int[] paramLenIdx;
    protected Object[][] storedInputStreams;
    protected Object[][] paramSets;
    protected int[][] paramLenIdxSets;
    protected int batchSize;

    public JdbcOdbcBoundArrayOfParams(int n) {
        this.numParams = n;
        this.initialize();
    }

    public void initialize() {
        this.storedParams = new Object[this.numParams];
        this.paramLenIdx = new int[this.numParams];
        this.hashedLenIdx = new Hashtable();
        this.batchSize = 0;
        int n = 0;
        while (n < this.numParams) {
            this.paramLenIdx[n] = -5;
            ++n;
        }
    }

    public void storeValue(int n, Object object, int n2) {
        this.storedParams[n] = object;
        this.paramLenIdx[n] = n2;
    }

    public void clearParameterSet() {
        if (this.storedParams != null) {
            int n = 0;
            while (n < this.numParams) {
                this.storedParams[n] = new Object();
                this.paramLenIdx[n] = -5;
                ++n;
            }
        }
    }

    public Object[] getStoredParameterSet() {
        Object[] objectArray = new Object[]{};
        if (this.storedParams != null) {
            objectArray = new Object[this.numParams];
            try {
                int n = 0;
                while (n < this.numParams) {
                    objectArray[n] = this.storedParams[n];
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("exception: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return objectArray;
    }

    public void storeRowIndex(int n, int[] nArray) {
        this.hashedLenIdx.put(new Integer(n), nArray);
    }

    public int[] getStoredRowIndex(int n) {
        return (int[])this.hashedLenIdx.get(new Integer(n));
    }

    public void clearStoredRowIndexs() {
        if (!this.hashedLenIdx.isEmpty()) {
            this.hashedLenIdx.clear();
        }
    }

    public int[] getStoredIndexSet() {
        int[] nArray = new int[]{};
        if (this.paramLenIdx != null) {
            nArray = new int[this.numParams];
            try {
                int n = 0;
                while (n < this.numParams) {
                    nArray[n] = this.paramLenIdx[n];
                    if (nArray[n] == -5) {
                        nArray = new int[]{};
                        return nArray;
                    }
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("exception: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return nArray;
    }

    public void builtColumWiseParameteSets(int n, Vector vector) {
        int[] nArray = new int[]{};
        Object[] objectArray = new Object[]{};
        this.batchSize = n;
        if (vector.size() == this.batchSize) {
            this.storedInputStreams = new Object[this.batchSize][this.numParams];
            this.paramSets = new Object[this.batchSize][this.numParams];
            this.paramLenIdxSets = new int[this.batchSize][this.numParams];
            int n2 = 0;
            while (n2 < this.batchSize) {
                nArray = this.getStoredRowIndex(n2);
                objectArray = (Object[])vector.elementAt(n2);
                int n3 = 0;
                while (n3 < this.numParams) {
                    this.paramSets[n2][n3] = objectArray[n3];
                    this.paramLenIdxSets[n2][n3] = nArray[n3];
                    ++n3;
                }
                ++n2;
            }
        }
    }

    public Object[] getColumnWiseParamSet(int n) {
        Object[] objectArray = new Object[this.batchSize];
        if (this.paramSets != null) {
            int n2 = 0;
            while (n2 < this.batchSize) {
                objectArray[n2] = this.paramSets[n2][n - 1];
                ++n2;
            }
        }
        return objectArray;
    }

    public int[] getColumnWiseIndexArray(int n) {
        int[] nArray = new int[this.batchSize];
        if (this.paramLenIdxSets != null) {
            int n2 = 0;
            while (n2 < this.batchSize) {
                nArray[n2] = this.paramLenIdxSets[n2][n - 1];
                ++n2;
            }
        }
        return nArray;
    }

    public void setInputStreamElements(int n, Object[] objectArray) {
        if (n >= 1 && n <= this.numParams && this.storedInputStreams != null && objectArray != null) {
            int n2 = 0;
            while (n2 < this.batchSize) {
                this.storedInputStreams[n2][n - 1] = objectArray[n2];
                ++n2;
            }
        }
    }

    public InputStream getInputStreamElement(int n, int n2) {
        InputStream inputStream = null;
        if (n >= 1 && n <= this.numParams && n2 >= 1 && n2 <= this.batchSize) {
            inputStream = (InputStream)this.storedInputStreams[n2 - 1][n - 1];
        }
        return inputStream;
    }

    public int getElementLength(int n, int n2) {
        return this.paramLenIdxSets[n2 - 1][n - 1];
    }
}

