/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnection;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;

public class JdbcOdbcDriver
extends JdbcOdbcObject
implements JdbcOdbcDriverInterface {
    protected static JdbcOdbc OdbcApi;
    protected static int hEnv;
    protected static int hDbc;
    protected static Hashtable connectionList;
    protected static String nativePrefix;

    public JdbcOdbcDriver() {
        connectionList = new Hashtable();
        nativePrefix = "";
    }

    protected synchronized void finalize() {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Driver.finalize");
        }
        try {
            if (hDbc != 0) {
                this.disconnect(hDbc);
                this.closeConnection(hDbc);
                hDbc = 0;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Driver.connect (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (hDbc != 0) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0;
        }
        if (!this.initialize()) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection(OdbcApi, hEnv, this);
        jdbcOdbcConnection.initialize(JdbcOdbcDriver.getSubName(string), properties, DriverManager.getLoginTimeout());
        jdbcOdbcConnection.setURL(string);
        return jdbcOdbcConnection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        boolean bl = false;
        if (this.knownURL(string) && this.trusted()) {
            bl = true;
        }
        return bl;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Driver.getPropertyInfo (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (!this.initialize()) {
            return null;
        }
        String string2 = JdbcOdbcDriver.makeConnectionString(properties);
        String string3 = "";
        string3 = this.getConnectionAttributes(JdbcOdbcDriver.getSubName(string), string2);
        Hashtable hashtable = this.getAttributeProperties(string3);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[hashtable.size()];
        int n = 0;
        while (n < hashtable.size()) {
            driverPropertyInfoArray[n] = (DriverPropertyInfo)hashtable.get(new Integer(n));
            ++n;
        }
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private boolean initialize() throws SQLException {
        boolean bl = true;
        if (OdbcApi == null) {
            try {
                OdbcApi = new JdbcOdbc(nativePrefix);
                JdbcOdbcDriver.OdbcApi.charSet = System.getProperty("file.encoding");
            }
            catch (Exception exception) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Unable to load JdbcOdbc library");
                }
                bl = false;
            }
        }
        if (hEnv == 0) {
            try {
                hEnv = OdbcApi.SQLAllocEnv();
            }
            catch (Exception exception) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Unable to allocate environment");
                }
                bl = false;
            }
        }
        return bl;
    }

    private boolean knownURL(String string) {
        String string2 = JdbcOdbcDriver.getProtocol(string);
        if (!string2.equalsIgnoreCase("jdbc")) {
            return false;
        }
        string2 = JdbcOdbcDriver.getSubProtocol(string);
        return string2.equalsIgnoreCase("odbc");
    }

    public static String getProtocol(String string) {
        String string2 = "";
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getSubProtocol(String string) {
        int n;
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0 && (n = string.indexOf(58, n2 + 1)) >= 0) {
            string2 = string.substring(n2 + 1, n);
        }
        return string2;
    }

    public static String getSubName(String string) {
        int n;
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0 && (n = string.indexOf(58, n2 + 1)) >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private boolean trusted() {
        SecurityManager securityManager;
        boolean bl = false;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("JDBC to ODBC Bridge: Checking security");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            try {
                String string = System.getProperty("browser");
                if (string != null && string.equalsIgnoreCase("Netscape Navigator")) {
                    nativePrefix = "Netscape_";
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                securityManager.checkWrite("JdbcOdbcSecurityCheck");
                bl = true;
            }
            catch (SecurityException securityException) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Security check failed: " + securityException.getMessage());
                }
                bl = false;
            }
        } else {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("No SecurityManager present, assuming trusted application/applet");
            }
            bl = true;
        }
        bl = true;
        return bl;
    }

    public String getConnectionAttributes(String string, String string2) throws SQLException {
        String string3;
        String string4 = "DSN=" + string + string2;
        if (hDbc == 0) {
            hDbc = this.allocConnection(hEnv);
        }
        if ((string3 = OdbcApi.SQLBrowseConnect(hDbc, string4)) == null) {
            string3 = "";
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0;
        }
        return string3;
    }

    public Hashtable getAttributeProperties(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Hashtable hashtable = new Hashtable();
        int n4 = string.length();
        while (n < n4) {
            boolean bl = true;
            String string2 = null;
            String string3 = null;
            String[] stringArray = null;
            String string4 = null;
            n2 = string.indexOf(";", n);
            if (n2 < 0) {
                n2 = n4;
            }
            String string5 = string.substring(n, n2);
            int n5 = 0;
            int n6 = string5.indexOf(":", 0);
            int n7 = string5.indexOf("=", 0);
            if (string5.startsWith("*")) {
                bl = false;
                ++n5;
            }
            if (n6 > 0) {
                string2 = string5.substring(n5, n6);
            }
            if (n6 > 0 && n7 > 0) {
                string3 = string5.substring(n6 + 1, n7);
            }
            if (n7 > 0 && (string4 = string5.substring(n7 + 1)).equals("?")) {
                string4 = null;
            }
            if (string4 != null && string4.startsWith("{")) {
                stringArray = JdbcOdbcDriver.listToArray(string4);
                string4 = null;
            }
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, string4);
            driverPropertyInfo.description = string3;
            driverPropertyInfo.required = bl;
            driverPropertyInfo.choices = stringArray;
            hashtable.put(new Integer(n3), driverPropertyInfo);
            ++n3;
            n = n2 + 1;
        }
        return hashtable;
    }

    protected static String makeConnectionString(Properties properties) {
        String string = "";
        Enumeration enumeration = properties.propertyNames();
        JdbcOdbcDriver.OdbcApi.charSet = properties.getProperty("charSet", System.getProperty("file.encoding"));
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string2.equalsIgnoreCase("user")) {
                string2 = "UID";
            }
            if (string2.equalsIgnoreCase("password")) {
                string2 = "PWD";
            }
            if (string3 == null) continue;
            string = string + ";" + string2 + "=" + string3;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    protected static String[] listToArray(String var0) {
        var1_1 = null;
        var3_2 = new Hashtable();
        var4_3 = 0;
        var5_4 = 1;
        var6_5 = 1;
        var7_6 = var0.length();
        if (!var0.startsWith("{")) {
            return null;
        }
        if (var0.endsWith("}")) ** GOTO lbl19
        return null;
lbl-1000:
        // 1 sources

        {
            var6_5 = var0.indexOf(",", var5_4);
            if (var6_5 < 0) {
                var6_5 = var7_6 - 1;
            }
            var2_7 = var0.substring(var5_4, var6_5);
            var3_2.put(new Integer(var4_3), var2_7);
            ++var4_3;
            var5_4 = var6_5 + 1;
lbl19:
            // 2 sources

            ** while (var5_4 < var7_6)
        }
lbl20:
        // 1 sources

        var1_1 = new String[var4_3];
        var5_4 = 0;
        while (var5_4 < var4_3) {
            var1_1[var5_4] = var2_7 = (String)var3_2.get(new Integer(var5_4));
            ++var5_4;
        }
        return var1_1;
    }

    public int allocConnection(int n) throws SQLException {
        int n2 = 0;
        n2 = OdbcApi.SQLAllocConnect(n);
        connectionList.put(new Integer(n2), new Integer(n));
        return n2;
    }

    public void closeConnection(int n) throws SQLException {
        OdbcApi.SQLFreeConnect(n);
        Integer n2 = (Integer)connectionList.remove(new Integer(n));
        if (connectionList.size() == 0 && hEnv != 0) {
            OdbcApi.SQLFreeEnv(hEnv);
            hEnv = 0;
        }
    }

    public void disconnect(int n) throws SQLException {
        OdbcApi.SQLDisconnect(n);
    }

    static {
        block3: {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("JdbcOdbcDriver class loaded");
            }
            JdbcOdbcDriver jdbcOdbcDriver = new JdbcOdbcDriver();
            try {
                DriverManager.registerDriver(jdbcOdbcDriver);
            }
            catch (SQLException sQLException) {
                if (!JdbcOdbcObject.isTracing()) break block3;
                JdbcOdbcObject.trace("Unable to register driver");
            }
        }
    }
}

