/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class FileMenuListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;

    FileMenuListener(PolicyTool policyTool, ToolWindow toolWindow) {
        this.tool = policyTool;
        this.tw = toolWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block17: {
            if (actionEvent.getActionCommand().equals("Exit")) {
                ToolDialog toolDialog = new ToolDialog("Save Changes", this.tool, this.tw, true);
                toolDialog.displayUserSave(1);
            } else if (actionEvent.getActionCommand().equals("New")) {
                ToolDialog toolDialog = new ToolDialog("Save Changes", this.tool, this.tw, true);
                toolDialog.displayUserSave(2);
            } else if (actionEvent.getActionCommand().equals("Open")) {
                ToolDialog toolDialog = new ToolDialog("Save Changes", this.tool, this.tw, true);
                toolDialog.displayUserSave(3);
            } else if (actionEvent.getActionCommand().equals("Save")) {
                String string = ((TextField)this.tw.getComponent(1)).getText();
                if (string == null || string.length() == 0) {
                    ToolDialog toolDialog = new ToolDialog("Save As", this.tool, this.tw, true);
                    toolDialog.displaySaveAsDialog(0);
                } else {
                    try {
                        this.tool.savePolicy(string);
                        this.tw.displayStatusDialog(null, "Policy successfully written to " + string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (string == null || string.equals("")) {
                            this.tw.displayErrorDialog(null, new FileNotFoundException("null filename"));
                            break block17;
                        }
                        this.tw.displayErrorDialog(null, new FileNotFoundException(string + " not found"));
                    }
                    catch (Exception exception) {
                        this.tw.displayErrorDialog(null, exception);
                    }
                }
            } else if (actionEvent.getActionCommand().equals("Save As")) {
                ToolDialog toolDialog = new ToolDialog("Save As", this.tool, this.tw, true);
                toolDialog.displaySaveAsDialog(0);
            } else if (actionEvent.getActionCommand().equals("View Warning Log")) {
                this.tw.displayWarningLog(null);
            }
        }
    }
}

