/*****************************************************************************
*                                                                            *
* Copyright (c) 1996-1997 Funduc Software Inc.   All rights reserved.        *
*                                                                            *
* These programs are the sole property of Funduc Software Inc. and contain   *
* proprietary information.  These routines should not by used by anyone      *
* except Funduc Software Inc.'s customers in accoordance with terms of a     *
* license.  To get one, visit us at http://www.funduc.com                    *
* or E-MAIL: sales@funduc.com                                                *
*                                                                            *
*****************************************************************************/
// detesvw.cpp : implementation of the CDetestView class
//

#include "stdafx.h"
#include "detest.h"
#include "decenc.h"

#include "detesdoc.h"
#include "detesvw.h"
#include "dispfile.h"
#include "EncDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDetestView

IMPLEMENT_DYNCREATE(CDetestView, CView)

BEGIN_MESSAGE_MAP(CDetestView, CView)
    //{{AFX_MSG_MAP(CDetestView)
    ON_COMMAND(ID_FILE_DECODE, OnFileDecode)
    ON_COMMAND(ID_FILE_ENCODEUUENCODED, OnFileEncodeuuencoded)
    ON_COMMAND(ID_FILE_DECODE_SHOWFILENAMES, OnFileDecodeShowfilenames)
    ON_COMMAND(ID_FILE_DECODE_OVERWRITEPROMPTONLY, OnFileDecodeOverwritepromptonly)
    ON_COMMAND(ID_FILE_ENCODEBINHEX, OnFileEncodebinhex)
    ON_COMMAND(ID_FILE_ENCODEXXENCODED, OnFileEncodexxencoded)
    ON_COMMAND(ID_UTIL_CONCATENATEFILES, OnUtilConcatenatefiles)
    ON_COMMAND(ID_UTIL_SPLITFILE, OnUtilSplitfile)
    ON_COMMAND(ID_FILE_ENCODEMIMEBASE64, OnFileEncodemimebase64)
    ON_COMMAND(ID_FILE_ENCODE_QUOTEDPRINTABLE, OnFileEncodeQuotedprintable)
	ON_COMMAND(ID_UTIL_ENCODEBUFFER, OnUtilEncodebuffer)
	ON_COMMAND(ID_UTIL_SHOWMESSAGEHEADERS, OnUtilShowmessageheaders)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDetestView construction/destruction

CDetestView::CDetestView()
{
    m_strBoundary = _T("=======Next-Part-23642332=========");
}

CDetestView::~CDetestView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CDetestView drawing

void CDetestView::OnDraw(CDC* )
{
    CDetestDoc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CDetestView diagnostics

#ifdef _DEBUG
void CDetestView::AssertValid() const
{
    CView::AssertValid();
}

void CDetestView::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CDetestDoc* CDetestView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDetestDoc)));
    return (CDetestDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDetestView message handlers

void CDetestView::OnFileDecode()
{          
    int nDecodeType;
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileIn = fileOpen.GetPathName();
        SetEncodingApplication(AfxGetAppName()); 
        nDecodeType = DecodeFile(strFileIn, strFileOut, PROMPT_ALL);
        if (nDecodeType)
        {             
            strFileOut.ReleaseBuffer();
            TRACE1("Decoded file: %s\n", (LPCSTR)strFileOut);
        }
    }
}

void CDetestView::OnFileEncodeuuencoded()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".UUE";

        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        SetEncodingApplication(AfxGetAppName()); 
        if (EncodeFile(strFileIn, strFileOut, m_strBoundary, UUE_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
		FinishAttachments(strFileOut);
    }
}

void CDetestView::OnFileDecodeShowfilenames()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {
        strFileIn = fileOpen.GetPathName();
        SetEncodingApplication(AfxGetAppName()); 
        CDispFilesDlg dlg(strFileIn, this);
        dlg.DoModal();
    }
}

void CDetestView::OnFileDecodeOverwritepromptonly()
{
    int nDecodeType;
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileIn = fileOpen.GetPathName();
        SetEncodingApplication(AfxGetAppName()); 
        nDecodeType = DecodeFile(strFileIn, strFileOut, PROMPT_OVERWRITE);
        if (nDecodeType)
        {             
            strFileOut.ReleaseBuffer();
            TRACE1("Decoded file: %s\n", (LPCSTR)strFileOut);
        }
    }
}

void CDetestView::OnFileEncodebinhex()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".HQX";
          
        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        if (EncodeFile(strFileIn, strFileOut, m_strBoundary, BINHEX_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
		FinishAttachments(strFileOut);
    }
}

void CDetestView::OnFileEncodexxencoded()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".XXE";

        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        if (EncodeFile(strFileIn, strFileOut, m_strBoundary, XXE_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
		FinishAttachments(strFileOut);
    }
}

void CDetestView::OnUtilConcatenatefiles()
{
    CString strFileIn, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    // Select an encoded file for splitting, then concatenate it using the first
    // one (ie. file1.mim)
    if (fileOpen.DoModal() == IDOK)
    {
        strViewer = strFileIn = fileOpen.GetPathName();
        if (ConcatenateRelated(TRUE, strFileIn.GetBuffer(255)))
        {             
            strFileIn.ReleaseBuffer();
            TRACE2("Concatenated file(s) %s to: %s\n", (LPCSTR)strViewer,
                   (LPCSTR)strFileIn);
        }
        else
            strFileIn.ReleaseBuffer();
    }
}

/* This function will split a file into as many smaller files as necessary
   For example: file.dat of size 100000 will be split into
   file1.dat (size 35000), file2.dat(35000), file3.dat(size 30000)
   if 35000 is used for the lFileSize parameter 
   The name of the last split file is returned in szFileName
*/
void CDetestView::OnUtilSplitfile()
{
    CString strFileIn, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    // Select an encoded file for splitting, then concatenate it using the first
    // one (ie. file1.mim)
    if (fileOpen.DoModal() == IDOK)
    {
        strViewer = strFileIn = fileOpen.GetPathName();
        if (SplitFile(strFileIn.GetBuffer(255), 35000L))
        {             
            strFileIn.ReleaseBuffer();
            TRACE2("Split file(s) %s to: %s\n", (LPCSTR)strViewer,
                   (LPCSTR)strFileIn);
        }
        else
            strFileIn.ReleaseBuffer();
    }
}

void CDetestView::OnFileEncodemimebase64()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {   
        // To set your application name in the registered version, use this call
        SetEncodingApplication(AfxGetAppName()); 
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".MIM";

        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        if (EncodeFile(strFileIn, strFileOut, m_strBoundary, B64_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
	    if (fileOpen.DoModal() == IDOK)  // File selected
		{
			// Example showing another file attached
	        strFileIn = fileOpen.GetPathName();
			// Make sure and set Append to TRUE !
			if (EncodeFile(strFileIn, strFileOut, m_strBoundary, B64_TYPE, TRUE))
			{
				TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
			}
		}
		FinishAttachments(strFileOut);
    }
}

void CDetestView::OnFileEncodeQuotedprintable()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;
    if (fileOpen.DoModal() == IDOK)  // File selected
    {   
        // To set your application name in the registered version, use this call
        SetEncodingApplication(AfxGetAppName()); 
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".QP";

        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        if (EncodeFile(strFileIn, strFileOut, m_strBoundary, TEXT_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
		FinishAttachments(strFileOut);
    }
}

void CDetestView::OnUtilEncodebuffer() 
{
    CEncodeDlg dlgEncode;
    dlgEncode.DoModal();
}

void CDetestView::OnUtilShowmessageheaders() 
{
    int nDecodeType;
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
       // You can alternatively use one of more of the following calls:
       // GetMessageHeaderField(DECENC_MSG_DATE_TIME_RECEIVED);
       // GetMessageHeaderField(DECENC_MSG_FROM);
       // GetMessageHeaderField(DECENC_MSG_TO);
       // GetMessageHeaderField(DECENC_MSG_SUBJECT);
       // GetMessageHeaderField(DECENC_MSG_DATE_TIME_SENT);
       DECENC_MSG_INFO MsgInfo;
       CString strMessage;
       if (GetMessageInfo(fileOpen.GetPathName(), &MsgInfo))
       {
           if (MsgInfo.m_szDateTimeReceived)
           {
               strMessage += "Message Received at: ";
               strMessage += MsgInfo.m_szDateTimeReceived;
           }
           if (MsgInfo.m_szFrom)
           {
               if (!strMessage.IsEmpty())
                   strMessage += '\n';
               strMessage += "From: ";
               strMessage += MsgInfo.m_szFrom;
           }
           if (MsgInfo.m_szTo)
           {
               if (!strMessage.IsEmpty())
                   strMessage += '\n';
               strMessage += "To: ";
               strMessage += MsgInfo.m_szTo;
           }
           if (MsgInfo.m_szSubject)
           {
               if (!strMessage.IsEmpty())
                   strMessage += '\n';
               strMessage += "Subject: ";
               strMessage += MsgInfo.m_szSubject;
           }
           if (MsgInfo.m_szDateTimeSent)
           {
               if (!strMessage.IsEmpty())
                   strMessage += '\n';
               strMessage += "Sent at: ";
               strMessage += MsgInfo.m_szDateTimeSent;
           }
           if (MsgInfo.m_szCC)
           {
               if (!strMessage.IsEmpty())
                   strMessage += '\n';
               strMessage += "CC: ";
               strMessage += MsgInfo.m_szCC;
           }
           if (MsgInfo.m_szReplyTo)
           {
               if (!strMessage.IsEmpty())
                   strMessage += '\n';
               strMessage += "Reply To: ";
               strMessage += MsgInfo.m_szReplyTo;
           }
           if (MsgInfo.m_szCompany)
           {
               if (!strMessage.IsEmpty())
                   strMessage += '\n';
               strMessage += "Organization: ";
               strMessage += MsgInfo.m_szCompany;
           }
           AfxMessageBox(strMessage);
           FreeMessageInfo(&MsgInfo);
       }
       CString strOutFile(fileOpen.GetPathName());
       int nLastSlash = strOutFile.ReverseFind('\\');
       if (nLastSlash > -1)
       {
           strOutFile = strOutFile.Left(nLastSlash + 1);
           strOutFile += _T("Message.txt");
           if (GetMessageText(fileOpen.GetPathName(), _T("Message.txt")) != NONE_TYPE)
           {
#ifdef WIN32
               try
#endif
               {
                   CFile fileMsg(strOutFile, CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone);
                   strMessage.ReleaseBuffer(fileMsg.Read(strMessage.GetBuffer(1024), 1024));
                   AfxMessageBox(strMessage);
               }
#ifdef WIN32
               catch (CException *e)
               {
                   e->ReportError();
                   e->Delete();
               }
#endif
           }
       }
    }
}
