/*****************************************************************************
*                                                                            *
* Copyright (c) 1996-2002 Funduc Software Inc.   All rights reserved.        *
*                                                                            *
* These programs are the sole property of Funduc Software Inc. and contain   *
* proprietary information.  These routines should not by used by anyone      *
* except Funduc Software Inc.'s customers in accoordance with terms of a     *
* license.  To get one, visit us at http://www.funduc.com                    *
* or E-MAIL: sales@funduc.com                                                *
*                                                                            *
*****************************************************************************/
// dispfile.cpp : implementation file
//

#include "stdafx.h"
#include "detest.h"
#include "dispfile.h"
#include "decenc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDispFilesDlg dialog


CDispFilesDlg::CDispFilesDlg(CString &strFileName, CWnd* pParent /*=NULL*/)
    : CDialog(CDispFilesDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CDispFilesDlg)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    m_strFileName = strFileName;
}

void CDispFilesDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CDispFilesDlg)
    DDX_Control(pDX, IDC_FILE_LIST, m_lbFileList);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDispFilesDlg, CDialog)
    //{{AFX_MSG_MAP(CDispFilesDlg)
    ON_LBN_DBLCLK(IDC_FILE_LIST, OnDblclkFileList)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDispFilesDlg message handlers

void CDispFilesDlg::OnDblclkFileList()
{
    CString strFileIn, strFileOut, strViewer;
    int nSelFile = m_lbFileList.GetCurSel();
    if (nSelFile == LB_ERR)
        return;
    m_lbFileList.GetText(nSelFile, strFileIn);
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(FALSE, NULL, strFileIn, 
                    OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
                    strExeFilter, this);
    CString strDir = strFileIn;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileIn = fileOpen.GetPathName();
        m_lbFileList.InsertString(nSelFile, strFileIn);
        m_lbFileList.DeleteString(nSelFile + 1);
    }
}

/* Sample function for changing the path of the files to a given path */
void DecodeToPath(CString &strFileToDecode, CString &strPath)
{
    if (!strPath.IsEmpty() && (strPath[strPath.GetLength() - 1] != '\\'))
        strPath += '\\';
    /* How many files are encoded */
    int nNumFiles = GetNumFilesToDecode(strFileToDecode); 
    CString strOutFile, strOutFileList;
    int nLastSlash;
    for (int nInx = 0; nInx < nNumFiles; ++nInx)
    {
        /* 0 relative index into the array of names (see call above) */
        GetEncodedFile(strOutFile.GetBuffer(255), nInx);
        strOutFile.ReleaseBuffer();
        nLastSlash = strOutFile.ReverseFind('\\');
        if (nLastSlash != -1)
            strOutFile = strPath + strOutFile.Mid(nLastSlash + 1);
        if (strOutFileList.IsEmpty())  // First time
        {
            strOutFileList += strOutFile;
        }                               
        else
        {   
            strOutFileList += ';';
            strOutFileList += strOutFile;
        }                               
    }

    if (nNumFiles)
    {
        int nDecodeType = DecodeFile(strFileToDecode, strOutFileList, PROMPT_NONE);
    }
}

void CDispFilesDlg::OnOK()
{
    int nCount = m_lbFileList.GetCount();
    CString strFileNames, strFileName;
    for (int nInx = 0; nInx < nCount; ++nInx)
    { 
        m_lbFileList.GetText(nInx, strFileName);
        if (strFileNames.IsEmpty())  // First time
        {
            strFileNames += strFileName;
        }                               
        else
        {   
            strFileNames += ';';
            strFileNames += strFileName;
        }                               
    }
    if (nCount)
    {
        int nDecodeType = DecodeFile(m_strFileName, strFileNames, PROMPT_NONE);
    }
    
    CDialog::OnOK();
}

BOOL CDispFilesDlg::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    CenterWindow();

    /* How many files are encoded */
    int nNumFiles = GetNumFilesToDecode(m_strFileName); 
    CString strOutFile;
    for (int nInx = 0; nInx < nNumFiles; ++nInx)
    {
        /* 0 relative index into the array of names (see call above) */
        GetEncodedFile(strOutFile.GetBuffer(255), nInx);
        strOutFile.ReleaseBuffer();
        m_lbFileList.AddString(strOutFile);
    }
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}
