// s5dialogDlg.cpp : implementation file
//

#include "stdafx.h"
#include "s5dialog.h"
#include "s5dialogDlg.h"
#include <dos.h>
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MAXINT 32767
#define MAXAWL 100
#define MAXEAMTZ 2
int speed;

// Declare Information for ICON.. Global variable!
int ICON_X =  50;       // Small Icon position.
int ICON_Y = 450;
int ICON_WIDTH = 32;    // Small Icon Width.
int ICON_HEIGHT = 32;
int COUNT = 20;                 
int TIME = 10;


// for credits
char *pArrCredit = { "|S5 Simulation for WIN32\t||Copyright (c) 1999|"
        "Peter Sieg|All Rights Reserved||"
//        "BITMAP1^||"    // this is a quoted bitmap resource 
        "Project Manager\r||Peter Sieg|||"
        "This credit scrolling code\r||Pal K.Tonder|||"
        "Background image display code\r||Joerg Koenig|||"
        "Special forms button code\r||Pavel A. Simakov|||"
        "Wave playing code\r||Anthony Petruso|||"
        "Printing code\r||Jeroen Clarysse|||"
        "Cool shrink to icon\r||Seo-Woonseok|||"
        "Various code fragments from:\r||www.codeguru.com||||"
//        "BITMAP2^|||"  // this is a quoted bitmap resource 
        "* * * * * * * * *\t|||"
//        "BITMAP3^||"
//        "BITMAP4^|||||"
        };


/* external declaration from s5console.c */
extern "C" char filename[256];	// contains the awl filename
extern "C" char msg[256];		// contains any messages
extern "C" int anz_aw;			// if zero not loaded
extern "C" int act_aw;			// points to actual aw
extern "C" int port;			// io-port 0=disabled
extern "C" int e[MAXEAMTZ][8];
extern "C" int a[MAXEAMTZ][8]; 
extern "C" int m[MAXEAMTZ][8];
extern "C" void load(void);		// load awl file
extern "C" void step_awl(void);	// one step through awl
extern "C" void print_info(void);//print act_aw + info in msg

BOOL PlayResource(LPSTR lpName)
{
	BOOL bRtn;
	LPSTR lpRes;
	HANDLE hRes;
	HRSRC hResInfo;
	HINSTANCE Nl = AfxGetInstanceHandle();

	// find the wave ressource
	// include the wave file by editing the *.rc file and include:
	// <Name_Of_Sound>	WAVE	<Location_Of_File>
	//ex: Hello	WAVE	"res\\s5.wav"
	//
	hResInfo=FindResource(Nl,lpName,"WAVE");
	if (hResInfo == NULL) return FALSE;

	// load the wave ressource
	hRes = LoadResource(Nl,hResInfo);
	if (hRes == NULL) return FALSE;

	// lock the wave ressource
	lpRes = (LPSTR)LockResource(hRes);
	if (lpRes == NULL) return FALSE;

	// play the ressource
	bRtn = sndPlaySound(lpRes,SND_MEMORY | SND_SYNC);
	if (bRtn == NULL) return FALSE;

	// free the ressource and return
	FreeResource(hRes);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual BOOL OnInitDialog();
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
	PlayResource("Hello");

}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CS5dialogDlg dialog

CS5dialogDlg::CS5dialogDlg(CWnd* pParent /*=NULL*/)
	: CBitmapDialog(CS5dialogDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CS5dialogDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CS5dialogDlg::DoDataExchange(CDataExchange* pDX)
{
	CBitmapDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CS5dialogDlg)
	DDX_Control(pDX, IDC_STOP, m_btnStop);
	DDX_Control(pDX, IDC_RUN, m_btnRun);
	DDX_Control(pDX, IDC_NEXT, m_btnNext);
	DDX_Control(pDX, IDC_LOAD, m_btnLoad);
	DDX_Control(pDX, IDC_B_VALUE, m_b_value);
	DDX_Control(pDX, IDC_IOPORTGROUP, m_ioportgroup);
	DDX_Control(pDX, IDC_LISTBOX, m_listbox);
	DDX_Control(pDX, IDC_AWLNAME, m_awlname);
	DDX_Control(pDX, IDC_MESSAGE, m_message);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CS5dialogDlg, CBitmapDialog)
	//{{AFX_MSG_MAP(CS5dialogDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_NEXT, OnNext)
	ON_BN_CLICKED(IDC_RUN, OnRun)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_BN_CLICKED(IDC_LOAD, OnLoad)
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_RADIO5, OnRadio5)
	ON_BN_CLICKED(MY_BTN3, OnBDown)
	ON_BN_CLICKED(MY_BTN4, OnBUp)
	ON_BN_CLICKED(MY_BTN12, OnBE)
	ON_BN_CLICKED(MY_BTN13, OnBA)
	ON_BN_CLICKED(MY_BTN14, OnBM)
	ON_BN_CLICKED(MY_BTN7, OnWordpad)
	ON_BN_CLICKED(IDC_RADIO6, OnRadio6)
	ON_BN_CLICKED(IDC_RADIO7, OnRadio7)
	ON_BN_CLICKED(IDC_RADIO8, OnRadio8)
	ON_BN_CLICKED(IDC_PRINT, OnPrint)
	ON_BN_CLICKED(IDC_SMALL_BUTTON, OnSmallButton)
	// *** included *** + OnSmallButton
	ON_WM_CREATE() // Sehr wichtig, sonst sieht man das Icon nicht!
    ON_WM_NCLBUTTONDBLCLK()
    ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CS5dialogDlg message handlers

BOOL CS5dialogDlg::OnInitDialog()
{
	CBitmapDialog::OnInitDialog();

	CWinApp* pApp = AfxGetApp();
	if (pApp != 0)
	{
		m_hIconLoad = pApp->LoadIcon(IDI_LOAD);
		ASSERT(m_hIconLoad);
		m_btnLoad.SetIcon(m_hIconLoad);

		m_hIconNext = pApp->LoadIcon(IDI_NEXT);
		ASSERT(m_hIconNext);
		m_btnNext.SetIcon(m_hIconNext);

		m_hIconRun  = pApp->LoadIcon(IDI_RUN);
		ASSERT(m_hIconRun);
		m_btnRun.SetIcon(m_hIconRun);

		m_hIconStop = pApp->LoadIcon(IDI_STOP);
		ASSERT(m_hIconStop);
		m_btnStop.SetIcon(m_hIconStop);
	}

	m_static.SubclassDlgItem(IDC_STATIC_CREDITS,this);
	m_static.SetCredits(pArrCredit);
	m_static.SetSpeed(DISPLAY_MEDIUM);
	// m_static.SetColor(BACKGROUND_COLOR, RGB(80,50,200));
	m_static.SetBkImage(IDB_BITMAP2);
	m_static.StartScrolling();

	// create special shaped buttons
	HRGN cr; 
	HRGN c;
	HRGN r1;

	// HALF_ELLIPSE: create left and right buttons splitting ellipse in half
	HRGN rgnR = CreateRectRgn(0, 0, 127, 31);
	HRGN rgnE = CreateEllipticRgn(0, 0, 127, 31);
	OffsetRgn(rgnR, 63, 0);
	CombineRgn(rgnE, rgnE, rgnR, RGN_DIFF);
	m_Btn3.Create("  <", WS_CHILD | WS_VISIBLE, CPoint(210, 440), rgnE, this, MY_BTN3, 2, GetSysColor(COLOR_BTNFACE), RGB(156, 175, 194), RGB(237, 175, 71), GetSysColor(COLOR_BTNFACE)); 

	rgnR = CreateRectRgn(0, 0, 127, 31);
	rgnE = CreateEllipticRgn(0, 0, 127, 31);
	OffsetRgn(rgnR, -63, 0);
	CombineRgn(rgnE, rgnE, rgnR, RGN_DIFF);
	OffsetRgn(rgnE, -64, 0);
	m_Btn4.Create(">  ", WS_CHILD | WS_VISIBLE, CPoint(210 + 64, 440), rgnE, this, MY_BTN4, 2, GetSysColor(COLOR_BTNFACE), RGB(156, 175, 194), RGB(237, 175, 71), GetSysColor(COLOR_BTNFACE)); 

	DeleteObject(rgnE);
	DeleteObject(rgnR);

	// Notepad Button
	HDC hDC = CreateCompatibleDC(GetDC() -> GetSafeHdc());

	BeginPath(hDC);
	MoveToEx(hDC, 0, 0, NULL);
	LineTo(hDC, 64, 0);
	LineTo(hDC, 64, 16);
	LineTo(hDC, 48, 32);
	LineTo(hDC, 0, 32);
	LineTo(hDC, 0, 0);
	EndPath(hDC);
	cr = CreateRectRgn(0, 0, 63, 63);
	cr = PathToRegion(hDC);
	m_Btn7.Create("Notepad", WS_CHILD | WS_VISIBLE, CPoint(585, 108), cr, this, MY_BTN7, 1, RGB(151, 244, 219), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE)); 
	// small pink triangel
	BeginPath(hDC);
	MoveToEx(hDC, 64, 16, NULL);
	LineTo(hDC, 64, 32);
	LineTo(hDC, 48, 32);
	LineTo(hDC, 64, 16);
	EndPath(hDC);
	cr = PathToRegion(hDC);
	m_Btn8.Create("", WS_CHILD | WS_VISIBLE, CPoint(585 + 48, 108 + 16), cr, this, MY_BTN8, 1, RGB(247, 211, 254), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE)); 

	// MERGED BUTTONS
	c = CreateRectRgn(8, 0, 55, 31);
	r1 = CreateEllipticRgn(48, 8, 15 + 48, 15 + 8);
	CombineRgn(c, c, r1, RGN_OR);
	m_Btn12.Create(" E ", WS_CHILD | WS_VISIBLE, CPoint(16, 440), c, this, MY_BTN12, 1, RGB(151, 219, 244), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE)); 
	r1 = CreateEllipticRgn(0, 8, 15, 15 + 8);
	CombineRgn(c, c, r1, RGN_DIFF);
	m_Btn13.Create(" A ", WS_CHILD | WS_VISIBLE, CPoint(16 + 48, 440), c, this, MY_BTN13, 1, RGB(151, 244, 219), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE));
	m_Btn14.Create(" M ", WS_CHILD | WS_VISIBLE, CPoint(16 + 48 + 48, 440), c, this, MY_BTN14, 1, RGB(244, 151, 219), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE));
	//m_Btn15.Create("Insert",WS_CHILD |WS_VISIBLE, CPoint(16 + 48 + 48 + 48, 63 + 32 + 64 + 128), c, this, MY_BTN15, 1, RGB(151, 219, 244), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE));
	//m_Btn16.Create("Tools", WS_CHILD |WS_VISIBLE, CPoint(16 + 48 + 48 + 48 + 48, 63 + 32 + 64 + 128), c, this, MY_BTN16, 1, RGB(151, 219, 244), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE));
	//m_Btn17.Create("Help",  WS_CHILD |WS_VISIBLE, CPoint(16 + 48 + 48 + 48 + 48 + 48, 63 + 32 + 64 + 128), c, this, MY_BTN17, 1, RGB(151, 244, 219), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE));
	//c = CreateRectRgn(8, 0, 63, 31);
	//r1 = CreateEllipticRgn(0, 8, 15, 15 + 8);
	//CombineRgn(c, c, r1, RGN_DIFF);
	//m_Btn18.Create("Exit",  WS_CHILD |WS_VISIBLE, CPoint(16 + 48 + 48 + 48 + 48 + 48 + 48, 63 + 32 + 64 + 128), c, this, MY_BTN18, 1, RGB(244, 151, 219), RGB(211, 247, 254), RGB(211, 247, 254), GetSysColor(COLOR_BTNFACE));

	DeleteObject(c);
	DeleteObject(r1);

	// end of special button creation

	// set background image
	SetBitmap(IDB_BITMAP1);
	// m_nType is a protected member of CBitmapDialog
	m_nType = CBitmapDialog::BITMAP_TILE;
	// m_nType = CBitmapDialog::BITMAP_CENTER;
	// m_nType = CBitmapDialog::BITMAP_TILE;
	// force the background to repaint
	Invalidate();
	
	// init awl filename and b_value +++
	m_awlname.SetWindowText("\\my.awl");
	m_b_value.SetWindowText("0");
	port = 0;
	speed= 100; // medium speed; set OnRun(); used OnTimer()
	
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// Code for OnCreate method.
int CS5dialogDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
        if (CDialog::OnCreate(lpCreateStruct) == -1)
                return -1;

        // Create small bitmap icon..
        CClientDC dc (this);
        m_dcSmallIcon.CreateCompatibleDC(&dc);
        CBitmap bitmap;
        bitmap.LoadBitmap(IDB_BITMAP);
        m_dcSmallIcon.SelectObject(&bitmap);
        bitmap.DeleteObject();  
        return 0;
}



// Code for OnNcLButtonDblClk and OnNcHitTest
void CS5dialogDlg::OnNcLButtonDblClk(UINT nHitTest, CPoint point)
{
        if( IsSmall == TRUE)
                LargeWindow();
        else
                CWnd::OnNcLButtonDblClk(nHitTest, point);
}


UINT CS5dialogDlg::OnNcHitTest(CPoint point)
{
        UINT nHitTest = CWnd::OnNcHitTest(point);
        if( nHitTest == HTCLIENT)
                nHitTest = HTCAPTION;

        return nHitTest;
}


/////////////////////////////////////////////////////////////////////////////////
// Code for LargeWindow() function.
void CS5dialogDlg::LargeWindow()
{
        CWindowDC dc(NULL);
        dc.SelectStockObject(WHITE_PEN);

        // Declare variable

        CRect m_rcClient;
        GetWindowRect(&m_rcClient);

        dc.DPtoLP(&m_rcClient);

        ICON_X = m_rcClient.left;
        ICON_Y = m_rcClient.top;
        m_rcClient = m_rcOldRect;

        int differ_x,differ_y;
        int differ_x1, differ_y1;

        dc.BitBlt(ICON_X, ICON_Y, ICON_WIDTH,ICON_HEIGHT, &dc, 0,0,SRCCOPY);

        differ_x = (ICON_X - m_rcClient.left)/COUNT;
        differ_y = (ICON_Y - m_rcClient.top)/COUNT;
        differ_x1 = (ICON_X+ICON_WIDTH - m_rcClient.right) /COUNT;
        differ_y1 = (ICON_Y+ICON_HEIGHT - m_rcClient.bottom) /COUNT;

        CRect rect;
        rect = m_rcClient;

        if( ICON_X > m_rcClient.right )
                rect.right = ICON_X;

        if( ICON_Y > m_rcClient.top)
                rect.top = ICON_Y;

        for( int i = COUNT ; i > 0 ; i--)
        {
                dc.MoveTo(m_rcClient.left+differ_x*i, m_rcClient.top + differ_y*i);
                dc.LineTo(m_rcClient.right+differ_x1*i,m_rcClient.top + differ_y*i);
                dc.LineTo(m_rcClient.right+differ_x1*i , m_rcClient.bottom + differ_y1*i);
                dc.LineTo(m_rcClient.left+differ_x*i,m_rcClient.bottom + differ_y1*i);
                dc.LineTo(m_rcClient.left+differ_x*i, m_rcClient.top + differ_y*i);
                ::Sleep(5);
        }       
        ::InvalidateRect(NULL, &rect, FALSE);
        MoveWindow(m_rcOldRect.left, m_rcOldRect.top,  m_rcOldRect.Width(),m_rcOldRect.Height());
        IsSmall = FALSE;
        InvalidateRect(m_rcOldRect,FALSE);
}


void CS5dialogDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CBitmapDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.


void CS5dialogDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting
		
		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	// *** included ***
    else if ( IsSmall == TRUE)
    {
        CWindowDC dc(this);
        dc.BitBlt(0, 0 ,32, 32, &m_dcSmallIcon, 0,0,SRCCOPY);
        CDialog::OnPaint();
    }
	else
	{
		CBitmapDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CS5dialogDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CS5dialogDlg::OnNext() 
{
	int n;
	// AfxMessageBox( "Next activated" );
	step_awl();
	m_message.SetWindowText(msg);
	// update listbox entry
	n = act_aw;
	
	if (n > 1)
	{
		m_listbox.InsertString(n-1,msg);
		m_listbox.DeleteString(n);
	}
	m_listbox.SetCurSel(act_aw - 1);

    // AfxMessageBox( msg );
	// TODO: Add your control notification handler code here
	
}

void CS5dialogDlg::OnRun() 
{
	AfxMessageBox( "Run activated" );
	m_static.EndScrolling();
	SetTimer( 1, speed, NULL);
	// TODO: Add your control notification handler code here
	
}

void CS5dialogDlg::OnStop() 
{
	KillTimer ( 1 );
	m_static.StartScrolling();
	AfxMessageBox( "Stop activated" );
	// TODO: Add your control notification handler code here
	
}

void CS5dialogDlg::OnLoad() 
{
	CString fname;
	int n,nlen;
    // AfxMessageBox( "Load activated" );
	nlen = m_awlname.LineLength();
	if (nlen < 1) AfxMessageBox("You must specify a filename.");
	else
	{
		m_awlname.GetWindowText(fname);
		// AfxMessageBox(fname);
		sprintf(filename,"%s",fname);
		m_static.EndScrolling();
		load();
		m_static.StartScrolling();
		AfxMessageBox( msg );

		// clear messages
		m_message.SetWindowText(" ");

		// delete anything in listbox from last awl
		m_listbox.ResetContent();
		m_listbox.AddString(fname);
		// show awl in listbox
		for (n = 1; n <= anz_aw; n++)
		{
			act_aw = n;
			print_info();
			m_listbox.AddString(msg);
		}
		act_aw = 1; // reset act_aw to start value!
	}
    // TODO: Add your control notification handler code here
	
}

void CS5dialogDlg::OnAbout() 
{
	char s[256];
	// test show value of m_ioportgroup
	sprintf(s,"Value of port=0x%x (%d) ",port,port);
	AfxMessageBox(s);
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
	// TODO: Add your control notification handler code here
	
}

void CS5dialogDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	int n;
		
	step_awl();
	m_message.SetWindowText(msg);
	// update listbox entry
	n = act_aw;
	
	if (n > 1)
	{
		m_listbox.InsertString(n-1,msg);
		m_listbox.DeleteString(n);
	}
	m_listbox.SetCurSel(act_aw - 1);
	// CDialog::OnTimer(nIDEvent);
}

void CS5dialogDlg::OnRadio1() 
{
	// TODO: Add your control notification handler code here
	port = 0; // disabled;
}

void CS5dialogDlg::OnRadio2() 
{
	// TODO: Add your control notification handler code here
	port = 0x278;
}

void CS5dialogDlg::OnRadio3() 
{
	// TODO: Add your control notification handler code here
	port = 0x378;
}

void CS5dialogDlg::OnRadio4() 
{
	// TODO: Add your control notification handler code here
	port = 0x3bc;
}

void CS5dialogDlg::OnRadio5() 
{
	// TODO: Add your control notification handler code here
	port = 0; // disabled. Will later change to request value
}

void CS5dialogDlg::OnBDown() 
{
	int i;
	CString s;
	m_b_value.GetWindowText(s);
	sscanf(s,"%d",&i);
	if (i > 0) i--;
	switch (i)
	{
	case 0:
		m_b_value.SetWindowText("0"); break;
	case 1:
		m_b_value.SetWindowText("1"); break;
	case 2:
		m_b_value.SetWindowText("2"); break;
	case 3:
		m_b_value.SetWindowText("3"); break;
	case 4:
		m_b_value.SetWindowText("4"); break;
	case 5:
		m_b_value.SetWindowText("5"); break;
	case 6:
		m_b_value.SetWindowText("6"); break;
	case 7:
		m_b_value.SetWindowText("7"); break;
	} 
	Invalidate(TRUE);
	// TODO: Add your control notification handler code here
}

void CS5dialogDlg::OnBUp() 
{
	int i;
	CString s;
	m_b_value.GetWindowText(s);
	sscanf(s,"%d",&i);
	if (i < 7) i++;
	switch (i)
	{
	case 0:
		m_b_value.SetWindowText("0"); break;
	case 1:
		m_b_value.SetWindowText("1"); break;
	case 2:
		m_b_value.SetWindowText("2"); break;
	case 3:
		m_b_value.SetWindowText("3"); break;
	case 4:
		m_b_value.SetWindowText("4"); break;
	case 5:
		m_b_value.SetWindowText("5"); break;
	case 6:
		m_b_value.SetWindowText("6"); break;
	case 7:
		m_b_value.SetWindowText("7"); break;
	} 
	Invalidate(TRUE);
	// TODO: Add your control notification handler code here
}

void CS5dialogDlg::OnBE() 
{
	int i;
	CString s;
	m_b_value.GetWindowText(s);
	sscanf(s,"%d",&i);
	if (e[0][i] == 0) e[0][i] = 1;
	else e[0][i] = 0;
	// TODO: Add your control notification handler code here
}

void CS5dialogDlg::OnBA() 
{
	int i;
	CString s;
	m_b_value.GetWindowText(s);
	sscanf(s,"%d",&i);
	if (a[0][i] == 0) a[0][i] = 1;
	else a[0][i] = 0;
	// TODO: Add your control notification handler code here
}

void CS5dialogDlg::OnBM() 
{
	int i;
	CString s;
	m_b_value.GetWindowText(s);
	sscanf(s,"%d",&i);
	if (m[0][i] == 0) m[0][i] = 1;
	else m[0][i] = 0;
	// TODO: Add your control notification handler code here
}

void CS5dialogDlg::OnWordpad() 
{
	CString fname;
	int nlen;
    // AfxMessageBox( "Notepad activated" );
	nlen = m_awlname.LineLength();
	if (nlen < 1) AfxMessageBox("You must specify a filename.");
	else
	{
		m_awlname.GetWindowText(fname);
		// AfxMessageBox(fname);
		sprintf(filename,"Notepad.exe %s",fname);
		system(filename);
	}
	// TODO: Add your control notification handler code here
	
}

void CS5dialogDlg::OnRadio6() 
{
	speed = 1000;
	// TODO: Add your control notification handler code here
	
}

void CS5dialogDlg::OnRadio7() 
{
	speed = 100;
	// TODO: Add your control notification handler code here
	
}

void CS5dialogDlg::OnRadio8() 
{
	speed = 10;
	// TODO: Add your control notification handler code here
	
}


BOOL CAboutDlg::OnInitDialog()
{
	// CG: Folowing code is added by System Info Component
	{
	CDialog::OnInitDialog();
#ifndef _MAC
	CString strFreeDiskSpace;
	CString strFreeMemory;
	CString strFmt;
	char s[40];
	OSVERSIONINFO osinfo;

	// Fill available memory
	MEMORYSTATUS MemStat;
	MemStat.dwLength = sizeof(MEMORYSTATUS);
	GlobalMemoryStatus(&MemStat);
	strFmt.LoadString(CG_IDS_PHYSICAL_MEM);
	strFreeMemory.Format(strFmt, MemStat.dwTotalPhys / 1024L);

	//TODO: Add a static control to your About Box to receive the memory
	//      information.  Initialize the control with code like this:
	SetDlgItemText(IDC_STATIC_MEM, strFreeMemory);

	// Fill disk free information
	struct _diskfree_t diskfree;
	int nDrive = _getdrive(); // use current default drive
	if (_getdiskfree(nDrive, &diskfree) == 0)
	{
		strFmt.LoadString(CG_IDS_DISK_SPACE);
		strFreeDiskSpace.Format(strFmt,
			(DWORD)diskfree.avail_clusters *
			(DWORD)diskfree.sectors_per_cluster *
			(DWORD)diskfree.bytes_per_sector / (DWORD)1024L,
			nDrive-1 + _T('A'));
	}
 	else
 		strFreeDiskSpace.LoadString(CG_IDS_DISK_SPACE_UNAVAIL);

	//TODO: Add a static control to your About Box to receive the memory
	//      information.  Initialize the control with code like this:
	SetDlgItemText(IDC_STATIC_DISC, strFreeDiskSpace);

	// get os version info
	osinfo.dwOSVersionInfoSize = sizeof(osinfo);
	(void) GetVersionEx(&osinfo);
	// format output string
	sprintf(s,"%d.%d  Build:%d",osinfo.dwMajorVersion, osinfo.dwMinorVersion, osinfo.dwBuildNumber);
	SetDlgItemText(IDC_STATIC_OSVER, s);



#endif //_MAC
	}

	return TRUE;
}

// p points to the start of the buffer, pSize holds the number of characters
void PrintString(char *p, DWORD pSize)
{
    CDC             dc;
    CPrintDialog    printDlg(FALSE);
    CRect           r;
    int             nHeight;
    
    // ask the user to select a printer
    if (printDlg.DoModal() == IDCANCEL)
        return;
    
    // Attach a printer DC
    dc.Attach(printDlg.GetPrinterDC());
    dc.m_bPrinting = TRUE;

    // use Textmappingmode, that's easiest to map the fontsize
    dc.SetMapMode(MM_TEXT);
    
    // setup font specifics
    LOGFONT LogFont;
    
    CFont       aFont, *oldFont;
    
    LogFont.lfHeight = -MulDiv(10, GetDeviceCaps(dc, LOGPIXELSY), 72);
    LogFont.lfWidth = 0;
    LogFont.lfEscapement = 0;
    LogFont.lfOrientation = 0;
    LogFont.lfWeight = FW_BOLD;
    LogFont.lfItalic = FALSE;
    LogFont.lfUnderline = 0;
    LogFont.lfStrikeOut = 0;
    LogFont.lfCharSet = ANSI_CHARSET;
    LogFont.lfOutPrecision = OUT_TT_PRECIS;
    LogFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
    LogFont.lfQuality = DEFAULT_QUALITY;
    LogFont.lfPitchAndFamily = FF_MODERN;
    lstrcpy (LogFont.lfFaceName, "MS Sans Serif");
    dc.SetBkMode(OPAQUE);
    aFont.CreateFontIndirect ( &LogFont );
    // ok, we've build the font, now use it
    oldFont = dc.SelectObject( &aFont );        
        
    // Get the application title
    CString strTitle;
    strTitle.LoadString(AFX_IDS_APP_TITLE);
    
    // Initialise print document details
    
    DOCINFO di;
    ::ZeroMemory (&di, sizeof (DOCINFO));
    di.cbSize = sizeof (DOCINFO);
    // application title appears in the spooler view
    di.lpszDocName = strTitle;
    
    // Begin a new print job
    BOOL bPrintingOK = dc.StartDoc( &di );
        
    // Get the printing extents and store in the m_rectDraw field of a 
    // CPrintInfo object
    CPrintInfo Info;
    int w = dc.GetDeviceCaps(HORZRES);
    int h = dc.GetDeviceCaps(VERTRES);
    Info.m_rectDraw.SetRect(0,0, w, h);
    
    char *startAt = p;
    int totalDone = 0;
    int lengthToGo = pSize;
    
    for (UINT page = Info.GetMinPage();
    bPrintingOK & totalDone < lengthToGo; page++)
    {
        // begin new page
        dc.StartPage();
        Info.m_nCurPage = page;
        
        // calc how much text fits on one page
        r = Info.m_rectDraw;
        r.bottom = r.top;
        int i = 0;
        while (r.bottom < Info.m_rectDraw.bottom & totalDone + i < lengthToGo)
        {
            r.right = Info.m_rectDraw.right;
            nHeight = dc.DrawText(startAt, i++, r, 
                DT_CALCRECT|DT_WORDBREAK|DT_NOCLIP|DT_EXPANDTABS);
        }
        // go one back to assure correct height
        if (r.bottom >= Info.m_rectDraw.bottom)
            i--;
        
        
        // print that text
        dc.DrawText(startAt, i, r, DT_WORDBREAK|DT_NOCLIP|DT_EXPANDTABS);
        
        // go to next page
        startAt += i;
        totalDone += i;
        
        // end page
        bPrintingOK = (dc.EndPage() > 0);
    }
    
    // end a print job
    if (bPrintingOK)
        dc.EndDoc();
    else
        // abort job.
        dc.AbortDoc();
    
    
    // restore font
    dc.SelectObject(oldFont);
    // free font memory
    // qFont.DeleteObject();
    aFont.DeleteObject();
    // detach the printer DC
    dc.Detach();
}


void CS5dialogDlg::OnPrint() 
{
	// TODO: Add your control notification handler code here
	// CString s;
	// s = "This is a very long test line\nThis is line two?";
	// long l = s.GetLength();
	// ::PrintString((char*)LPCSTR(s),l);
	/*
	char buf[4800]; // 60 lines with max 80 chars.
	char s[80];
    buf[0] = '\0';
	sprintf(s,"Printout of s5 plc like simulation program:\n");
	strcat(buf,s);
	sprintf(s,"------------------------------------------------\n");
	strcat(buf,s);
	long l = strlen(buf);
	::PrintString((char*)buf,l);
	*/
	CString s;
	CString t;
	int i;

	if (anz_aw > 0)
	{
	m_static.EndScrolling();

	s = "Printout of s5 plc like simulation program:\n";
	s = s + "-------------------------------------------\n";

	// print awl+info's from m_listbox
	for (i=0; i<=anz_aw; i++)
	{
		m_listbox.GetText(i,t);
		s = s + t;
		s = s + "\n";
	
	}
	long l = s.GetLength();
	::PrintString((char*)LPCSTR(s),l);

	m_static.StartScrolling();
	}
}

void CS5dialogDlg::OnSmallButton() 
{
	// TODO: Add your control notification handler code here

        CWindowDC dc(NULL);
        dc.SelectStockObject(WHITE_PEN);
        // Declare variable
        CRect m_rcClient;
        GetWindowRect(&m_rcClient);
        GetWindowRect(&m_rcOldRect);
        dc.DPtoLP(&m_rcClient);
        dc.DPtoLP(&m_rcOldRect);
        int differ_x,differ_y;
        int differ_x1, differ_y1;
        dc.BitBlt(ICON_X, ICON_Y, ICON_WIDTH,ICON_HEIGHT, &dc, 0,0,SRCCOPY);    // Draw Icon
        differ_x = (ICON_X - m_rcClient.left)/COUNT;
        differ_y = (ICON_Y - m_rcClient.top)/COUNT;
        differ_x1 = (ICON_X+ICON_WIDTH - m_rcClient.right) /COUNT;
        differ_y1 = (ICON_Y+ICON_HEIGHT - m_rcClient.bottom) /COUNT;

        CRect rect;
        rect = m_rcClient;

        if( ICON_X > m_rcClient.right )
                rect.right = ICON_X;

        if( ICON_Y > m_rcClient.top)
                rect.top = ICON_Y;

        for( int i = 0 ; i < COUNT; i++)
        {
                dc.MoveTo(m_rcClient.left+differ_x*i, m_rcClient.top + differ_y*i);
                dc.LineTo(m_rcClient.right+differ_x1*i,m_rcClient.top + differ_y*i);
                dc.LineTo(m_rcClient.right+differ_x1*i , m_rcClient.bottom + differ_y1*i);
                dc.LineTo(m_rcClient.left+differ_x*i,m_rcClient.bottom + differ_y1*i);
                dc.LineTo(m_rcClient.left+differ_x*i, m_rcClient.top + differ_y*i);

//              dc.Rectangle(m_rcClient.left+differ_x*i, m_rcClient.top + differ_y*i, 
//                      m_rcClient.right+differ_x1*i , m_rcClient.bottom + differ_y1*i);

                // If you want to draw line between icon and app, insert following comment code.
/*
                dc.MoveTo(m_rcClient.left+differ_x*i,m_rcClient.top + differ_y*i);
                dc.LineTo(ICON_X, ICON_Y);
                dc.MoveTo(m_rcClient.left , m_rcClient.bottom + differ_y1*i);
                dc.LineTo(ICON_WIDTH+ICON_X, ICON_Y);
                dc.MoveTo(m_rcClient.right + differ_x1*i, m_rcClient.top + differ_y*i);
                dc.LineTo(ICON_X+ICON_WIDTH, ICON_Y);
                dc.MoveTo(m_rcClient.right + differ_x1*i, m_rcClient.bottom + differ_y1*i);
                dc.LineTo(ICON_X+ICON_WIDTH, ICON_Y+ ICON_HEIGHT);

*/
                ::Sleep(TIME);
        }       
        ::InvalidateRect(NULL, &rect, FALSE);
        IsSmall = TRUE;
        SetWindowPos(NULL,0,0,ICON_WIDTH, ICON_HEIGHT,SWP_NOMOVE|SWP_NOZORDER);
        MoveWindow(ICON_X, ICON_Y,ICON_WIDTH, ICON_HEIGHT,TRUE);
        OnPaint();

}
