/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Archiver;
import common.ComboDir;
import common.DButton;
import common.DMessageBar;
import common.DPanel;
import common.DToolBar;
import common.Deleter;
import common.DialogMessage;
import common.DirBox;
import common.DirTools;
import common.Directory;
import common.Disk;
import common.History;
import common.Icons;
import common.Input;
import common.Path;
import common.Preferences;
import common.Style;
import common.Temporary;
import common.Tool;
import common.VectorString;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;

public class DirManager
extends Panel
implements ActionListener,
ComponentListener,
KeyListener,
MouseListener {
    public Directory dir = new Directory(true);
    public ComboDir combo;
    public DirBox dirList;
    public DMessageBar statusBar;
    public History history = null;
    public Archiver archiver = null;
    public Temporary tempo = null;
    public String ZipName;
    public String m_dirName;
    public String m_fileName;
    public String m_pathName;
    public Label labelDirSize;
    public DToolBar toolbar;
    public DButton buttonOpen;
    public DButton buttonHome;
    public DButton buttonParent;
    public DButton buttonMake;
    public DButton buttonDelete;
    public DButton buttonCancel;
    public MenuItem miOpen;
    public MenuItem miRun;
    public MenuItem miEdit;
    public MenuItem miRename;
    public MenuItem miDelete;
    public MenuItem miInfo;
    public MenuItem miAddPrg;
    public MenuItem miAddDoc;
    public MenuItem miCopy;
    public MenuItem miUnarc;
    public Frame frame;
    public DPanel panelDirList;
    public Component vParent;
    public PopupMenu popup = null;
    public String MemName = "IZ.Memory";
    public String MemDir = System.getProperty("user.dir");
    public boolean associated = false;
    public boolean modified = false;
    public static final int SOURCE = 0;
    public static final int TARGET = 1;
    public static final int UNKNOW = 2;
    public int usage = 2;
    public String dirmade = "";
    public static String graflist = ".gif.jpg.ico.raw.pal.aaz.bmp.pcx.pic.tga.png.xbm.tiff.jpeg.jpe.";
    public static String others = ".class.hlp.";
    public static String soundlist = ".wav.au.aif.";
    public boolean addit = false;
    Process process;
    transient ActionListener actionListener;
    KeyListener keyListener;

    public DirManager(Frame frame) {
        this.frame = frame;
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.toolbar = new DToolBar();
        this.add((Component)this.toolbar, "North");
        this.panelDirList = new DPanel();
        this.panelDirList.setLayout(new BorderLayout(0, 0));
        this.add(this.panelDirList);
        this.combo = new ComboDir();
        this.combo.setBounds(2, 3, 368, 22);
        this.combo.setArrowStyle(true, false, 1);
        this.combo.setMaxItems(16);
        this.combo.setEditable(true);
        this.combo.setShowFocus(true);
        this.combo.addKeyListener(this);
        this.combo.addActionListener(this);
        this.combo.editBox.addKeyListener(this);
        this.panelDirList.add((Component)this.combo, "North");
        this.dirList = new DirBox(true);
        this.dirList.addActionListener(this);
        this.dirList.addMouseListener(this);
        this.dirList.addKeyListener(this);
        this.dirList.setFocusable(true);
        this.panelDirList.add((Component)this.dirList, "Center");
        this.labelDirSize = new Label("");
        this.labelDirSize.setBounds(14, 335, 258, 16);
        this.labelDirSize.setFont(new Font("SansSerif", 0, 14));
        this.add((Component)this.labelDirSize, "South");
        DButton.ADJUSTSIZE = false;
        DButton.setDefaultSize(36, 24);
        this.buttonOpen = new DButton(Icons.DirOpen);
        this.buttonOpen.setTip("Open or process according to the extension");
        this.buttonOpen.addActionListener(this);
        this.toolbar.add(this.buttonOpen);
        this.buttonHome = new DButton(Icons.DirHome);
        this.buttonHome.setTip("Go to home directory");
        this.buttonHome.addActionListener(this);
        this.toolbar.add(this.buttonHome);
        this.buttonParent = new DButton(Icons.DirParent);
        this.buttonParent.setTip("Go to parent directory");
        this.buttonParent.addActionListener(this);
        this.toolbar.add(this.buttonParent);
        this.toolbar.setHeight(24);
        this.toolbar.addSeparator(11, 22);
        this.buttonMake = new DButton(Icons.DirMake);
        this.buttonMake.setTip("Create a new sub-directory");
        this.buttonMake.addActionListener(this);
        this.toolbar.add(this.buttonMake);
        this.buttonDelete = new DButton(Icons.DirDel);
        this.buttonDelete.setTip("Cross out / Delete selection");
        this.buttonDelete.addActionListener(this);
        this.toolbar.add(this.buttonDelete);
        this.buttonCancel = new DButton(Icons.Cancel);
        this.buttonCancel.setTip("Cancel selection / Refresh the display");
        this.buttonCancel.addActionListener(this);
        this.toolbar.add(this.buttonCancel);
        this.setPath(this.MemDir);
        this.addComponentListener(this);
        this.dir.jarMask = true;
        this.addMouseListener(this);
    }

    public DirManager(Frame frame, DMessageBar dMessageBar) {
        this(frame);
        this.setObjets(dMessageBar);
    }

    public void setPopupParent(Component component, Font font) {
        this.popup = new PopupMenu();
        this.vParent = component;
        this.vParent.add(this.popup);
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.miOpen = new MenuItem("Open");
        this.miOpen.addActionListener(this);
        this.miOpen.setFont(font2);
        this.popup.add(this.miOpen);
        this.miRun = new MenuItem("Run");
        this.miRun.addActionListener(this);
        this.miRun.setFont(font);
        this.popup.add(this.miRun);
        this.miEdit = new MenuItem("Edit");
        this.miEdit.addActionListener(this);
        this.miEdit.setFont(font);
        this.popup.add(this.miEdit);
        this.popup.addSeparator();
        this.miInfo = new MenuItem("More info", new MenuShortcut(73));
        this.miInfo.addActionListener(this);
        this.miInfo.setFont(font);
        this.popup.add(this.miInfo);
        this.miRename = new MenuItem("Rename", new MenuShortcut(78));
        this.miRename.addActionListener(this);
        this.miRename.setFont(font);
        this.popup.add(this.miRename);
        this.miDelete = new MenuItem("Delete");
        this.miDelete.addActionListener(this);
        this.miDelete.setFont(font);
        this.popup.add(this.miDelete);
        this.miAddPrg = new MenuItem("Add to Tools");
        this.miAddPrg.addActionListener(this);
        this.miAddPrg.setFont(font);
        this.popup.add(this.miAddPrg);
        this.miAddDoc = new MenuItem("Add to References");
        this.miAddDoc.addActionListener(this);
        this.miAddDoc.setFont(font);
        this.popup.add(this.miAddDoc);
        this.popup.addSeparator();
        this.miCopy = new MenuItem("Copy", new MenuShortcut(67));
        this.miCopy.addActionListener(this);
        this.miCopy.setFont(font);
        this.popup.add(this.miCopy);
        this.miUnarc = new MenuItem("Extract", new MenuShortcut(85));
        this.miUnarc.addActionListener(this);
        this.miUnarc.setFont(font);
        this.popup.add(this.miUnarc);
    }

    public void setUsage(int n) {
        this.usage = n;
    }

    public int getUsage() {
        return this.usage;
    }

    public void setObjets(DMessageBar dMessageBar) {
        this.statusBar = dMessageBar;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public void setFilename(String string) {
        this.MemName = string;
    }

    public void setArchiver(Archiver archiver) {
        this.archiver = archiver;
    }

    public void setTemporary(Temporary temporary) {
        this.tempo = temporary;
    }

    public void addNotify() {
        super.addNotify();
        this.combo.setBackground(this.getParent().getBackground());
    }

    public void addButton(DButton dButton) {
        this.toolbar.add(dButton);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (this.modified) {
            this.dir.updated = false;
        }
    }

    public void requestFocus() {
        this.dirList.requestFocus();
    }

    public void comboResize(int n) {
        this.combo.Resize(n);
    }

    public void setStyle(Style style) {
        this.dirList.setStyle(style);
        this.combo.setStyle(style);
        Dimension dimension = new Dimension();
        Dimension dimension2 = this.combo.getSize();
        dimension.height = style.font.getSize();
        dimension.width = dimension2.width;
        this.combo.setSize(dimension);
    }

    public void message(String string) {
        this.dispTip(string);
        if (this.history != null) {
            this.history.tell(string);
        }
    }

    public void dispTip(String string) {
        if (this.statusBar != null) {
            this.statusBar.setText(" ".concat(String.valueOf(String.valueOf(string))));
        }
    }

    public boolean testSelected(int n) {
        if (this.dirList.isSelected()) {
            return true;
        }
        this.noSelected(n);
        return false;
    }

    public void noSelected(int n) {
        String[] stringArray = new String[]{" in source", " in target", ""};
        this.dispTip(String.valueOf(String.valueOf(new StringBuffer("Select a file").append(stringArray[n]).append(", please..."))));
        Tool.beep();
    }

    public void noSelected() {
        this.noSelected(2);
    }

    boolean error(String string) {
        System.out.println(string);
        return false;
    }

    public String getDrive() {
        return this.dir.getDrive();
    }

    public String getPath() {
        return this.dir.getPath();
    }

    public String getDir() {
        return this.dir.getDir();
    }

    public int firstFile() {
        return this.dir.MAXINDIRS;
    }

    public void setPath(String string) {
        if (string == null) {
            string = this.MemDir;
        }
        this.dir.setPath(string);
        this.updatePath(string);
    }

    public void updatePath(String string) {
        try {
            String string2 = this.dir.filter.length() > 0 ? " filter ".concat(String.valueOf(String.valueOf(this.dir.filter))) : "";
            this.dispTip(String.valueOf(String.valueOf(new StringBuffer("New path ").append(this.dir.getPath()).append(string2))));
        }
        catch (NullPointerException nullPointerException) {
            this.dir.filter = "";
            String string3 = "";
        }
    }

    public void makePath(String string, String string2) {
        this.m_dirName = string;
        this.m_fileName = string2;
        this.m_pathName = Path.merge(this.m_dirName, this.m_fileName);
    }

    public boolean selected() {
        return this.isSelected();
    }

    public boolean isSelected() {
        return this.dirList.isSelected();
    }

    public boolean isTagged() {
        return this.dirList.isTagged();
    }

    public void setSelected(String string, boolean bl) {
        if (this.dirList.countItems() > 0) {
            this.dirList.setSelectedItem(string, bl);
        }
    }

    public void showIt(int n) {
        this.dirList.showIt(n);
    }

    public void setSelected(int n) {
        if (this.dirList.countItems() > 0) {
            this.dirList.setSelectedIndex(n, true);
        }
    }

    public void selectCtrl(String string) {
        this.dirList.selectMultiple(this.dirList.getIndex(string), false, true);
    }

    public int getSelectedIndex() {
        return this.dirList.getSelectedIndex();
    }

    public String[] getFiles() {
        return this.dirList.getFiles(this.getDir());
    }

    public String[] getSelectedItems() {
        return this.dirList.getSelectedItems();
    }

    public int[] getSelectedIndexes() {
        return this.dirList.getSelectedIndexes();
    }

    public String getSelected() {
        return this.dirList.getSelectedItem();
    }

    public String[] getTaggedItems() {
        return this.dirList.getTaggedItems();
    }

    public String getTagged() {
        return this.dirList.getTaggedItem();
    }

    public void deselectAll() {
        this.dirList.deselectAll();
    }

    public void selectAll() {
        this.dirList.selectAllFiles(this.firstFile());
    }

    public void selectAny() {
        this.dirList.selectAll();
    }

    public int countSelected() {
        return this.dirList.countSelected;
    }

    public void setArcSort(boolean bl) {
        this.dir.setArcSort(bl);
    }

    public String[] getListItems() {
        return this.dirList.getListItems();
    }

    public int countItems() {
        return this.dirList.countItems();
    }

    public void setPainting(boolean bl) {
        this.dirList.setPainting(bl);
    }

    public void update(boolean bl) {
        this.dirList.update(bl);
    }

    public void selectMultiple(int n) {
        this.dirList.selectMultiple(n, false, true);
    }

    public boolean isDir() {
        int[] nArray = this.dirList.getSelectedIndexes();
        if (nArray.length > 1) {
            return false;
        }
        String string = Path.merge(this.dir.getDir(), this.dirList.getSelectedItem());
        return new File(string).isDirectory();
    }

    public void refresh(boolean bl) {
        int n = bl ? 0 : this.dirList.getTopRow();
        this.dirDisp(n);
        this.showIt(n);
    }

    public void dirDisp(boolean bl) {
        int n = bl ? 0 : this.dirList.getTopRow();
        this.dirDisp(n);
    }

    public void dirDisp(int n) {
        this.dir.dispDir(this.dirList, this.dir.filter, n);
        String string = this.dir.MAXINDIRS > 1 ? " directories   " : " directory   ";
        String string2 = this.dir.MAXINFILES > 1 ? " files" : " file";
        String string3 = this.dir.Masked > 0 ? String.valueOf(String.valueOf(new StringBuffer("   ").append(this.dir.Masked).append(" hidden"))) : "";
        long l = this.dirList.TotalSize;
        String string4 = l > (long)0xA00000 ? String.valueOf(String.valueOf(l / (long)0x100000)).concat(" megas used") : String.valueOf(String.valueOf(l)).concat(" bytes used");
        this.labelDirSize.setText(String.valueOf(String.valueOf(new StringBuffer(" ").append(this.dir.MAXINDIRS).append(string).append(this.dir.Displayed).append(string2).append(string3).append("   ").append(string4))));
        this.combo.setText(this.dir.getPath());
        this.modified = false;
    }

    public void parent() {
        String string = this.dir.goParent();
        this.updatePath(this.dir.getPath());
        this.dirDisp(true);
        if (string.length() > 0) {
            this.dirList.showIt(string);
        } else {
            this.dirList.showIt(0);
        }
    }

    public void home() {
        this.dir.goHome();
        this.updatePath(this.dir.getPath());
        this.dirDisp(true);
        this.setSelected(0);
    }

    public void make() {
        this.make("Creating a sub-directory");
    }

    public void make(String string) {
        if (this.isInside()) {
            return;
        }
        this.dispTip(string);
        Input input = new Input(this.frame);
        input.setTitle(string);
        input.setLabel("Type a name for the sub-directory to create:");
        input.setInput("");
        input.setVisible(true);
        String string2 = input.getInput();
        if (input.ok()) {
            File file = new File(this.dir.getDir(), string2);
            if (file.mkdir()) {
                this.message(String.valueOf(String.valueOf(string2)).concat(" directory created"));
                this.modified = true;
                this.dirmade = string2;
                if (this.usage != 1) {
                    this.dirDisp(true);
                }
                this.sendAction("md");
            } else {
                this.dispTip("Not made");
            }
        } else {
            this.dispTip("Cancelled");
        }
    }

    public void cancel() {
        this.dirDisp(true);
    }

    public boolean isInside() {
        if (this.dir.zipMode) {
            this.dispTip("This can't be performed inside archive");
            return true;
        }
        return false;
    }

    public void moreInfo() {
        if (this.isInside()) {
            return;
        }
        String string = this.dir.getDir();
        String[] stringArray = this.dirList.getSelectedItems();
        if (stringArray.length == 1) {
            String string2 = this.dirList.getSelectedItem();
            if (!new File(this.getDir(), string2).isDirectory()) {
                this.message(DirTools.info(Path.merge(string, string2)));
                return;
            }
        }
        int n = 0;
        this.dirList.setCursor(new Cursor(3));
        this.dispTip("calculating...");
        if (stringArray.length == 0) {
            stringArray = this.dirList.getListItems();
            n = 1;
        }
        DirTools.occupation(string, stringArray, n);
        this.message(DirTools.message);
        this.dirList.setCursor(Cursor.getDefaultCursor());
    }

    public boolean open() {
        if (!this.selected()) {
            return false;
        }
        this.makePath(this.dir.getDir(), this.dirList.getSelectedItem());
        if (this.dir.zipMode) {
            return this.openInside(false);
        }
        return this.openCommon(true);
    }

    public boolean openInside(boolean bl) {
        this.message(String.valueOf(String.valueOf(new StringBuffer("Viewing ").append(this.m_fileName).append(" inside ").append(this.dir.arcname))));
        if (this.tempo == null) {
            System.out.println("Temporary dir not created");
            return false;
        }
        if (this.tempo.open(this.m_dirName, this.dir.arcname, this.m_fileName)) {
            if (bl) {
                this.executable(this.tempo.createdPath, this.tempo.createdFile);
            } else {
                this.openPath(this.tempo.createdPath, this.tempo.createdFile, false, false);
            }
        } else {
            this.message(this.tempo.message);
        }
        return this.tempo.result;
    }

    public boolean openCommon(boolean bl) {
        File file = new File(this.m_dirName, this.m_fileName);
        if (file.isDirectory()) {
            this.dispTip("Directory");
            this.setPath(this.m_pathName);
            this.dirDisp(true);
            this.setSelected(0);
            this.dirList.requestFocusInWindow();
            return true;
        }
        return this.openAny(this.m_pathName, this.m_fileName, true, true);
    }

    public boolean openAny(String string, String string2, boolean bl, boolean bl2) {
        if (Directory.isArchive(string)) {
            return this.openZip();
        }
        this.openPath(string, string2, bl, bl2);
        return true;
    }

    public void viewZip() {
        if (!this.testSelected(0)) {
            return;
        }
        File file = new File(this.dir.getDir(), this.dirList.getSelectedItem());
        if (file.isDirectory()) {
            this.noSelected();
            return;
        }
        this.openZip();
    }

    public boolean openZip() {
        this.message("Opening archive ".concat(String.valueOf(String.valueOf(this.m_fileName))));
        this.makePath(this.dir.getDir(), this.dirList.getSelectedItem());
        this.ZipName = this.m_fileName;
        this.dir.setArchive(true);
        this.setPath(this.m_pathName);
        this.setCursor(new Cursor(3));
        this.dirDisp(true);
        this.setCursor(Cursor.getDefaultCursor());
        if (this.dir.zipMode) {
            this.message("Inside archive ".concat(String.valueOf(String.valueOf(this.m_fileName))));
            this.showIt(0);
            return true;
        }
        this.ZipName = "";
        this.setPath(this.m_dirName);
        this.message("Format not supported");
        new DialogMessage(this.frame, "Zip format not supported").setVisible(true);
        return false;
    }

    public static boolean inside(String string, String string2) {
        int n;
        if (string2 == null) {
            return false;
        }
        if (string2.equals("")) {
            return false;
        }
        String string3 = string2.toLowerCase();
        if (!string3.startsWith(".")) {
            string3 = ".".concat(String.valueOf(String.valueOf(string3)));
        }
        if (!string3.endsWith(".")) {
            string3 = String.valueOf(String.valueOf(string3)).concat(".");
        }
        return (n = string.indexOf(string3)) != -1;
    }

    public void openPath(String string, String string2, boolean bl, boolean bl2) {
        this.addit = bl;
        this.m_pathName = string = string.toLowerCase();
        this.m_fileName = string2;
        if (Preferences.AssFirst) {
            System.out.println("first");
            this.associated = false;
            this.sendAction("assoc");
            if (this.associated) {
                return;
            }
        }
        if (DirTools.isExecutable(string2)) {
            if (bl2) {
                this.executable(this.m_pathName, string2);
            }
            return;
        }
        String string3 = Path.getExtension(string2);
        if (DirManager.inside(graflist, string3)) {
            this.sendAction("graph");
            return;
        }
        if (DirManager.inside(soundlist, string3)) {
            this.sendAction("sound");
            return;
        }
        if (!Preferences.AssFirst) {
            this.associated = false;
            this.sendAction("assoc");
            if (this.associated) {
                return;
            }
        }
        this.sendAction("text");
    }

    public boolean openRun() {
        if (!this.selected()) {
            return false;
        }
        this.makePath(this.dir.getDir(), this.dirList.getSelectedItem());
        File file = new File(this.m_dirName, this.m_fileName);
        if (file.isDirectory()) {
            return false;
        }
        if (this.dir.zipMode) {
            return this.openInside(true);
        }
        return this.executable(this.m_pathName, this.m_fileName);
    }

    public boolean executable(String string, String string2) {
        if (DirTools.isMSDOS(string)) {
            this.dispTip(String.valueOf(String.valueOf(string2)).concat(" is a MS-DOS program. Run it with Explorer"));
            return false;
        }
        if (DirTools.isCOMMAND()) {
            this.dispTip(String.valueOf(String.valueOf(string2)).concat(" is a command, open the DOS window and type it"));
            return false;
        }
        String string3 = "";
        if (DirTools.isWIN31()) {
            string3 = "Windows 3.1 program ";
        }
        this.message(String.valueOf(String.valueOf(new StringBuffer("Launching ").append(string3).append(string2))));
        this.launch(string, string2);
        return true;
    }

    public void launch(String string, String string2) {
        boolean bl = false;
        String string3 = "Enable to run ".concat(String.valueOf(String.valueOf(string)));
        try {
            this.process = Runtime.getRuntime().exec(string);
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!bl) {
            this.message(string3);
        }
    }

    public boolean run(String string, String string2, String string3) {
        Runtime runtime = Runtime.getRuntime();
        boolean bl = false;
        String string4 = String.valueOf(String.valueOf(new StringBuffer("Enable to run ").append(string).append(" with ").append(string2)));
        try {
            Process process = Runtime.getRuntime().exec(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(string2))));
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            string4 = String.valueOf(String.valueOf(new StringBuffer("Launched ").append(string).append(" with ").append(string2)));
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.message(string4);
        return bl;
    }

    String pluriel(int n) {
        if (n > 1) {
            return "s";
        }
        return "";
    }

    public void crossOut() {
        boolean bl = false;
        int n = this.dirList.countItems();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.dirList.isSelected(i)) continue;
            this.dirList.setDeselected(i);
            this.dirList.crossOut(i);
            bl = true;
            ++n2;
        }
        if (bl) {
            this.dirList.blockPaint(false);
            this.message(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" file").append(this.pluriel(n2)).append(" crossed out for deletion"))));
        } else {
            this.noSelected();
        }
    }

    public int deleteConditional(String string, String string2) {
        Deleter.message = String.valueOf(String.valueOf(string2)).concat(" not deleted");
        int n = Deleter.conditional(this.frame, string, string2);
        if (n < 1) {
            this.message(Deleter.message);
            return 0;
        }
        if (n == 1) {
            this.message(String.valueOf(String.valueOf(string2)).concat(" deleted"));
        }
        return n;
    }

    public void deleteSecond() {
        int n = 0;
        int n2 = 0;
        String string = this.dir.getDir();
        this.dispTip("Deleting crossed out files");
        int n3 = this.dirList.countItems();
        int n4 = -1;
        int n5 = this.dirList.getTopRow();
        for (int i = 0; i < n3; ++i) {
            if (!this.dirList.isCrossOut(i)) continue;
            this.dirList.crossOut(i, false);
            ++n2;
            n += this.deleteConditional(string, this.dirList.getText(i));
            if (n4 == -1) {
                n4 = i;
            }
            if (i >= n5) continue;
            n5 = i;
        }
        if (n > 0) {
            n3 = Math.max(0, n3 - n);
            n4 = Math.min(n4, n3 - 1);
            n4 = Math.max(0, n4);
            if (n > 1) {
                this.message(String.valueOf(String.valueOf(n)).concat(" deleted"));
            }
            this.dirDisp(this.dirList.getTopRow());
            this.setSelected(n4);
            this.sendAction("modified");
        }
    }

    void delete() {
        if (this.isInside()) {
            return;
        }
        if (this.dirList.isCrossOut()) {
            this.deleteSecond();
        } else {
            this.crossOut();
        }
    }

    boolean rename() {
        if (this.isInside()) {
            return false;
        }
        boolean bl = false;
        int n = this.dirList.getSelectedIndex();
        String string = this.dirList.getSelectedItem();
        String string2 = this.dir.getDir();
        if (n == -1) {
            Tool.beep();
            return false;
        }
        if (string == null || string.length() == 0) {
            Tool.beep();
            return false;
        }
        Input input = new Input(this.frame);
        input.setTitle("Rename a file or a directory");
        input.setLabel("Type the new name:");
        input.setInput(string);
        input.setVisible(true);
        if (input.ok()) {
            File file = new File(string2, string);
            File file2 = new File(string2, input.getInput());
            try {
                if (file.renameTo(file2)) {
                    this.dirList.setText(n, file2.getName());
                    bl = true;
                } else {
                    bl = false;
                }
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            if (bl) {
                this.message(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" renamed ").append(file2.getName()))));
                this.sendAction("modified");
            } else {
                this.message(String.valueOf(String.valueOf(new StringBuffer("Enable to rename ").append(string).append(" to ").append(file2.getName()))));
            }
        }
        return true;
    }

    public boolean unArchive(String string) {
        this.makePath(this.getDir(), this.getSelected());
        Archiver.setMessage("Error");
        if (this.dir.zipMode) {
            String[] stringArray = this.dirList.getSelectedItems();
            int n = stringArray.length;
            if (n > 0) {
                String string2 = n > 1 ? "tagged list" : this.m_fileName;
                this.message(String.valueOf(String.valueOf(new StringBuffer("Extracting ").append(string2).append(" from ").append(this.dir.arcname))));
                String string3 = Path.merge(this.m_dirName, this.dir.arcname);
                for (int i = 0; i < n; ++i) {
                    String string4 = stringArray[i];
                    if (Archiver.extractFile(string3, string4, string, Preferences.ArcRestore)) continue;
                    this.message(Archiver.getMessage());
                }
                return true;
            }
            this.dispTip("Select entries to unarchive, please!");
            return false;
        }
        if (Path.isDirectory(this.m_pathName)) {
            this.noSelected();
            return false;
        }
        this.dispTip("Unarchiving ".concat(String.valueOf(String.valueOf(this.m_pathName))));
        Point point = this.archiver.unArchive(this.m_pathName, string);
        if (point.y == 0) {
            this.message(Archiver.getMessage());
            Tool.beep();
        } else {
            String string5 = "";
            if (point.y < point.x) {
                string5 = "Error - ";
            }
            this.message(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string5))).append(this.m_pathName).append(" unarchived in ").append(point.y).append("/").append(point.x).append(" file(s)"))));
        }
        if (Archiver.error) {
            new DialogMessage(this.frame, "Error, not unarchived!").setVisible(true);
        }
        return true;
    }

    public boolean testSelected() {
        this.makePath(this.dir.getDir(), this.dirList.getSelectedItem());
        if (this.m_pathName == null) {
            return false;
        }
        return !new File(this.m_pathName).isDirectory();
    }

    public void addPrg() {
        if (!this.testSelected()) {
            return;
        }
        this.sendAction("addprg");
    }

    public void addDoc() {
        if (!this.testSelected()) {
            return;
        }
        this.sendAction("adddoc");
    }

    public void setPathCombo() {
        String string = Path.setCanonical(this.combo.getText());
        this.setPath(string);
        this.dirDisp(true);
    }

    public void pathDelete() {
        this.message(String.valueOf(String.valueOf(new StringBuffer("Removing ").append(this.dir.getPath()).append(" from list"))));
        this.combo.deleteInList();
        this.combo.setBaseSize();
        this.setPath(this.combo.getText());
        this.dirDisp(true);
    }

    public void showMenu() {
        if (this.vParent == null) {
            return;
        }
        this.popup.show(this.dirList, this.dirList.popx, this.dirList.popy);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonParent) {
            this.parent();
        } else if (object == this.buttonHome) {
            this.home();
        } else if (object == this.buttonOpen) {
            this.open();
        } else if (object == this.buttonMake) {
            this.make();
        } else if (object == this.buttonDelete) {
            this.delete();
        } else if (object == this.buttonCancel) {
            this.cancel();
        } else {
            if (object == this.combo) {
                String string = actionEvent.getActionCommand();
                if (string != null && string.equals("del")) {
                    this.pathDelete();
                    return;
                }
                this.setPath(this.combo.getSelectedItem());
                this.dirDisp(true);
                this.dirList.showIt(0);
                return;
            }
            if (object == this.dirList) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Enter")) {
                    this.open();
                    return;
                }
                if (string.equals("Popup")) {
                    this.showMenu();
                    return;
                }
                if (string.equals("Delete")) {
                    this.delete();
                    return;
                }
                if (string.equals("Esc")) {
                    this.cancel();
                    return;
                }
                if (string.equals("Up")) {
                    this.parent();
                    return;
                }
            } else if (object == this.miOpen) {
                this.open();
            } else if (object == this.miRun) {
                this.openRun();
            } else if (object == this.miEdit) {
                this.sendAction("edit");
            } else if (object == this.miRename) {
                this.rename();
            } else if (object == this.miDelete) {
                this.delete();
            } else if (object == this.miInfo) {
                this.moreInfo();
            } else if (object == this.miCopy) {
                if (this.dir.zipMode) {
                    this.sendAction("unarc");
                } else {
                    this.sendAction("copy");
                }
            } else if (object == this.miUnarc) {
                this.sendAction("unarc");
            } else if (object == this.miAddPrg) {
                this.addPrg();
            } else if (object == this.miAddDoc) {
                this.addDoc();
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void sendAction(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        int n = keyEvent.getKeyCode();
        if (keyEvent.isAltDown()) {
            switch (n) {
                default: 
            }
            if (this.keyListener != null) {
                this.keyListener.keyPressed(keyEvent);
            }
        }
        if (object == this.combo.editBox) {
            if (n == 10) {
                this.setPathCombo();
                keyEvent.consume();
                return;
            }
            if (keyEvent.isControlDown()) {
                if (n == 65) {
                    this.combo.addUnicItem(this.combo.editBox.getText());
                    this.combo.separeDrives();
                    keyEvent.consume();
                    return;
                }
                if (n == 89 || n == 68) {
                    this.pathDelete();
                    keyEvent.consume();
                    return;
                }
            }
        } else if (object == this.dirList && keyEvent.isControlDown()) {
            switch (n) {
                case 78: {
                    this.rename();
                    break;
                }
                case 75: 
                case 77: {
                    this.make();
                    break;
                }
                case 73: {
                    this.moreInfo();
                    break;
                }
                default: {
                    return;
                }
            }
            keyEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        int n = mouseEvent.getClickCount();
        if (n == 2 && object == this.dirList) {
            this.open();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void save() {
        int n;
        String[] stringArray = this.combo.getListItems();
        int n2 = stringArray.length;
        if (n2 > (n = 16)) {
            n2 = n;
        }
        VectorString vectorString = new VectorString();
        vectorString.addElement("SEB=".concat(String.valueOf(String.valueOf(this.getDir()))));
        for (int i = 0; i < n2; ++i) {
            vectorString.addElement("BKM=".concat(String.valueOf(String.valueOf(stringArray[i]))));
        }
        int n3 = Disk.saveLines(this.MemDir, this.MemName, vectorString);
    }

    public boolean load(String string, String string2) {
        this.MemDir = string;
        return this.load(string2);
    }

    public boolean load(String string) {
        this.MemName = string;
        return this.load();
    }

    public boolean load() {
        int n;
        int n2;
        VectorString vectorString = new VectorString();
        VectorString vectorString2 = new VectorString();
        int n3 = 16;
        int n4 = Disk.loadUnicLines(this.MemDir, this.MemName, vectorString2);
        int n5 = vectorString2.size();
        for (n2 = 0; n2 < n5; ++n2) {
            String string = vectorString2.elementAt(n2);
            n = string.indexOf("=");
            if (n <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (string2 == null || string3 == null) continue;
            if (string3.length() < 1) {
                System.out.println(String.valueOf(String.valueOf(string2)).concat(" Error: Empty field"));
                continue;
            }
            if (string2.equals("BKM")) {
                vectorString.addElement(string3);
                continue;
            }
            if (!string2.equals("SEB")) continue;
            this.setPath(string3);
        }
        this.combo.clear();
        this.combo.setMaxItems(16);
        if (n5 < 1) {
            return false;
        }
        int n6 = vectorString.separeDrives();
        this.combo.setBaseSize(n6);
        n = vectorString.size();
        for (n2 = 0; n2 < n; ++n2) {
            this.combo.addItem(vectorString.elementAt(n2));
        }
        return true;
    }

    public void addDrives(VectorString vectorString) {
        int n = vectorString.size();
        for (int i = 0; i < n; ++i) {
            this.combo.addUnicItem(vectorString.elementAt(i));
        }
        this.combo.setBaseSize(n);
        this.combo.separeDrives();
    }

    public void componentShown(ComponentEvent componentEvent) {
        String string = this.dir.getDir();
        if (!string.equalsIgnoreCase(this.m_dirName)) {
            this.modified = true;
        }
        if (this.modified) {
            this.refresh(false);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }
}

