/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.HSliderThumb;
import common.HSliderThumbBot;
import common.HSliderThumbBoth;
import common.HSliderThumbTop;
import common.Slider;
import common.SliderTick;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;

public class HSlider
extends Slider {
    protected static final int TICK_HEIGHT = 4;
    protected String actionCommand = "HSliderMoved";
    private HSliderThumb thumb = new HSliderThumbBoth();
    private Mouse mouse = null;
    private MouseMtn mouseMotion = null;

    public HSlider() {
        this.width = 24 + this.freq * (this.max + 1);
        this.height = 20;
    }

    protected HSlider(int n, int n2) {
        this();
        this.setBounds(n, n2, this.width, this.height);
    }

    protected HSlider(int n, int n2, int n3) {
        this();
        this.setValue(n3);
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.width = n3;
        this.height = n4;
    }

    public void setTickStyle(int n) {
        if (this.style != n) {
            super.setTickStyle(n);
            switch (n) {
                case 2: {
                    this.thumb = new HSliderThumbTop();
                    break;
                }
                case 1: {
                    this.thumb = new HSliderThumbBot();
                    break;
                }
                default: {
                    this.thumb = new HSliderThumbBoth();
                }
            }
            this.repaint();
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMtn();
            this.addMouseMotionListener(this.mouseMotion);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        super.removeNotify();
    }

    protected void do_reshape(int n, int n2) {
        int n3 = 12;
        int n4 = 8;
        if (n < n3) {
            n3 = n / 4;
        }
        if (n2 < n4) {
            n4 = n2 / 4;
        }
        int n5 = n3;
        int n6 = n - n3 - 1;
        int n7 = n4 + 1;
        int n8 = n2 - n4 - 1;
        int n9 = (this.max - this.min) / this.freq + 1;
        this.tick = new SliderTick[n9];
        int n10 = this.tickWidth;
        for (int i = 0; i < n9; ++i) {
            int n11 = i * n10;
            this.tick[i] = new SliderTick(n7, n8, n5 + n11, n11);
        }
        this.thumb.resize(5, n8 - n7 - 4 - 1);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!this.notified) {
            return;
        }
        super.paint(graphics);
        if (this.tick.length == 0) {
            return;
        }
        int n = this.width - 1;
        int n2 = this.height - 1;
        int n3 = 1 + n - 2;
        int n4 = 1 + n2 - 2;
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n, n2);
        graphics.setColor(this.background);
        graphics.fillRect(2, 2, n - 4, n2 - 4);
        if (this.borderStyle == 2) {
            graphics.setColor(this.background.brighter());
            graphics.drawLine(1, 1, n3, 1);
            graphics.drawLine(1, 1, 1, n4);
            graphics.drawLine(2, 2, n3 - 1, 2);
            graphics.drawLine(2, 2, 2, n4 - 1);
            graphics.setColor(this.background.darker());
            graphics.drawLine(2, n4, n3, n4);
            graphics.drawLine(n3, 2, n3, n4);
            graphics.drawLine(3, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, 3, n3 - 1, n4 - 1);
        } else if (this.borderStyle == 1) {
            graphics.setColor(this.background.darker());
            graphics.drawLine(1, 1, n3, 1);
            graphics.drawLine(1, 1, 1, n4);
            graphics.drawLine(2, 2, n3 - 1, 2);
            graphics.drawLine(2, 2, 2, n4 - 1);
            graphics.setColor(this.background.brighter());
            graphics.drawLine(2, n4, n3, n4);
            graphics.drawLine(n3, 2, n3, n4);
            graphics.drawLine(3, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, 3, n3 - 1, n4 - 1);
        }
        graphics.setColor(Color.black);
        if (this.style > 0) {
            for (int i = 0; i < this.tick.length; i += this.tickStep) {
                boolean bl = i == 0 || i == this.tick.length - 1;
                SliderTick sliderTick = this.tick[i];
                if (this.style == 2 || this.style == 3) {
                    graphics.drawLine(sliderTick.x, sliderTick.yt + (bl ? 0 : 1), sliderTick.x, sliderTick.yt + 4);
                }
                if (this.style != 1 && this.style != 3) continue;
                graphics.drawLine(sliderTick.x, sliderTick.yb - 4, sliderTick.x, sliderTick.yb - (bl ? 0 : 1));
            }
        }
        SliderTick sliderTick = this.tick[0];
        int n5 = 9;
        int n6 = sliderTick.x - 5;
        int n7 = this.tick[this.tick.length - 1].x + 5;
        graphics.drawLine(n6, n5, n7, n5);
        graphics.drawLine(n6, n5 + 1, n7, n5 + 1);
        graphics.setColor(Color.gray);
        graphics.drawLine(n7 + 1, n5 - 1, n6 - 1, n5 - 1);
        graphics.drawLine(n6 - 1, n5 - 1, n6 - 1, n5 + 1);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n7 + 1, n5 + 1, n7 + 1, n5);
        graphics.setColor(Color.white);
        graphics.drawLine(n6 - 1, n5 + 2, n7 + 2, n5 + 2);
        graphics.drawLine(n7 + 2, n5 + 2, n7 + 2, n5 - 1);
        this.thumb.draw(graphics, this.tick[this.curPos]);
        this.prevPos = this.curPos;
    }

    class MouseMtn
    extends MouseMotionAdapter
    implements Serializable {
        MouseMtn() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            HSlider.this.moveThumb(mouseEvent.getX(), false);
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        Mouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            HSlider.this.moveThumb(mouseEvent.getX(), true);
        }
    }
}

