/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.ScrollPane;

public class ScrollingPanel
extends ScrollPane {
    private int width = 100;
    private int height = 100;

    public ScrollingPanel() {
    }

    public ScrollingPanel(int n) {
        super(n);
    }

    public ScrollingPanel(Component component, int n, int n2) {
        this.addImpl(component, null, -1);
        this.setSize(n, n2);
    }

    public void setMinimumWidth(int n) {
        this.width = n;
    }

    public int getMinimumWidth() {
        return this.width;
    }

    public void setMinimumHeight(int n) {
        this.height = n;
    }

    public int getMinimumHeight() {
        return this.height;
    }

    public void setComponent(Component component) {
        this.addImpl(component, null, -1);
    }

    public Component getComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    public void scrollUp() {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x, point.y - this.getVAdjustable().getUnitIncrement()));
    }

    public void scrollLeft() {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x - this.getHAdjustable().getUnitIncrement(), point.y));
    }

    public void scrollDown() {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x, point.y + this.getVAdjustable().getUnitIncrement()));
    }

    public void scrollRight() {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x + this.getHAdjustable().getUnitIncrement(), point.y));
    }

    public void scrollPageUp() {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x, point.y - this.getVAdjustable().getBlockIncrement()));
    }

    public void scrollPageLeft() {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x - this.getHAdjustable().getBlockIncrement(), point.y));
    }

    public void scrollPageDown() {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x, point.y + this.getVAdjustable().getBlockIncrement()));
    }

    public void scrollPageRight() {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x + this.getHAdjustable().getBlockIncrement(), point.y));
    }

    public void scrollVerticalAbsolute(int n) {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(point.x, n));
    }

    public void scrollHorizontalAbsolute(int n) {
        Point point = this.getScrollPosition();
        this.setScrollPosition(new Point(n, point.y));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.minimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }
}

