/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DTreeNode;
import common.OS;
import common.Style;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;

public class DTreeView
extends Panel
implements ItemSelectable {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    public int selectedIndex;
    public String selectedText;
    public int existIndex;
    int sbVPosition = 0;
    int sbVWidth;
    int sbHPosition = 0;
    int sbHHeight = 0;
    long sbVTimer = -1L;
    int cellSize = 16;
    int clickSize = 8;
    int imageInset = 3;
    int textInset = 14;
    int textBaseLine = 3;
    int doubleClickResolution = 333;
    protected DTreeNode rootNode;
    protected DTreeNode selectedNode;
    protected DTreeNode topVisibleNode;
    protected Scrollbar verticalScrollBar;
    protected boolean sbVShow = false;
    protected int count = 0;
    protected int viewCount = 0;
    protected Scrollbar horizontalScrollBar;
    protected int sbHSize;
    protected int newWidth = 0;
    protected boolean sbHShow = false;
    protected boolean needResetVector;
    protected int sbHLineIncrement = 4;
    protected int viewHeight = 300;
    protected int viewWidth = 300;
    protected int viewWidest = 0;
    protected Key key = null;
    protected Mouse mouse = null;
    protected Adjustment adjustment = null;
    protected ActionListener actionListener = null;
    protected ItemListener itemListener = null;
    protected Focus focus = null;
    protected Vector v;
    protected Vector e;
    protected transient boolean redrawTriggered = false;
    transient boolean hasFocus = false;
    protected transient FontMetrics fm;
    transient long timeMouseDown;
    protected transient boolean isSun1_1;
    protected transient Image im1;
    protected transient Graphics g1 = null;

    public DTreeView() {
        super.setLayout(null);
        this.verticalScrollBar = new Scrollbar(1);
        this.verticalScrollBar.setVisible(false);
        this.add(this.verticalScrollBar);
        this.horizontalScrollBar = new Scrollbar(0);
        this.horizontalScrollBar.setVisible(false);
        this.add(this.horizontalScrollBar);
        this.needResetVector = true;
    }

    public DTreeView(DTreeNode dTreeNode) {
        this();
        this.selectedNode = this.rootNode = dTreeNode;
        this.count = 1;
    }

    public void setStyle(Style style) {
        this.setFont(style.font);
        this.setBackground(style.background);
        this.setForeground(style.foreground);
        this.verticalScrollBar.setBackground(style.background);
        this.horizontalScrollBar.setBackground(style.background);
        this.triggerRedraw();
        this.invalidate();
    }

    public Object[] getSelectedObjects() {
        if (this.selectedNode == null) {
            return null;
        }
        Object[] objectArray = new DTreeNode[]{this.selectedNode};
        return objectArray;
    }

    public void clear() {
        this.selectedNode = null;
        this.rootNode = null;
        this.count = 0;
        this.v = new Vector();
        this.e = new Vector();
        this.triggerRedraw();
        this.invalidate();
    }

    public DTreeNode getRootNode() {
        return this.rootNode;
    }

    public int getCount() {
        return this.count;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    boolean viewable(DTreeNode dTreeNode) {
        for (int i = 0; i < this.viewCount; ++i) {
            if (dTreeNode != this.v.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    boolean viewable(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this.viewCount; ++i) {
            DTreeNode dTreeNode = (DTreeNode)this.v.elementAt(i);
            if (dTreeNode.text == null || !string.equals(dTreeNode.text)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(DTreeNode dTreeNode) {
        this.recount();
        for (int i = 0; i < this.count; ++i) {
            if (dTreeNode != this.e.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(String string) {
        this.recount();
        this.existIndex = -1;
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            DTreeNode dTreeNode = (DTreeNode)this.e.elementAt(i);
            if (dTreeNode.text == null) continue;
            this.existIndex = i;
            if (!string.equals(dTreeNode.text)) continue;
            return true;
        }
        return false;
    }

    public void append(DTreeNode dTreeNode) {
        if (this.rootNode == null) {
            this.selectedNode = this.rootNode = dTreeNode;
            this.count = 1;
            this.redrawTriggered = true;
        } else {
            this.recount();
            if (this.e.contains(dTreeNode)) {
                System.err.println(new Exception("append: Node already exists in tree."));
            } else {
                this.addSibling(dTreeNode, this.rootNode, true);
            }
        }
    }

    public void addChild(DTreeNode dTreeNode, DTreeNode dTreeNode2) {
        if (dTreeNode2.child == null) {
            dTreeNode2.child = dTreeNode;
            dTreeNode.parent = dTreeNode2;
            ++this.count;
            this.redrawTriggered = true;
        } else {
            this.addSibling(dTreeNode, dTreeNode2.child, true);
        }
        ++dTreeNode2.numberOfChildren;
    }

    public void addSibling(DTreeNode dTreeNode, DTreeNode dTreeNode2) {
        this.addSibling(dTreeNode, dTreeNode2, true);
    }

    public void addSibling(DTreeNode dTreeNode, DTreeNode dTreeNode2, boolean bl) {
        if (bl) {
            DTreeNode dTreeNode3 = dTreeNode2;
            while (dTreeNode3.sibling != null) {
                dTreeNode3 = dTreeNode3.sibling;
            }
            dTreeNode3.sibling = dTreeNode;
        } else {
            dTreeNode.sibling = dTreeNode2.sibling;
            dTreeNode2.sibling = dTreeNode;
        }
        dTreeNode.parent = dTreeNode2.parent;
        ++this.count;
        this.redrawTriggered = true;
    }

    public void insert(DTreeNode dTreeNode, DTreeNode dTreeNode2, int n) {
        if (dTreeNode == null || dTreeNode2 == null) {
            return;
        }
        if (!this.exists(dTreeNode2)) {
            return;
        }
        switch (n) {
            case 0: {
                this.addChild(dTreeNode, dTreeNode2);
                break;
            }
            case 1: {
                this.addSibling(dTreeNode, dTreeNode2, false);
                break;
            }
            case 2: {
                this.addSibling(dTreeNode, dTreeNode2, true);
                break;
            }
            default: {
                return;
            }
        }
    }

    public DTreeNode remove(String string) {
        this.recount();
        for (int i = 0; i < this.count; ++i) {
            DTreeNode dTreeNode = (DTreeNode)this.e.elementAt(i);
            if (dTreeNode.text == null || !string.equals(dTreeNode.text)) continue;
            this.remove(dTreeNode);
            this.redrawTriggered = true;
            return dTreeNode;
        }
        return null;
    }

    public void removeSelected() {
        if (this.selectedNode != null) {
            this.remove(this.selectedNode);
        }
    }

    public void remove(DTreeNode dTreeNode) {
        if (!this.exists(dTreeNode)) {
            return;
        }
        if (dTreeNode == this.selectedNode) {
            int n = this.v.indexOf(this.selectedNode);
            if (n == -1) {
                n = this.e.indexOf(this.selectedNode);
            }
            if (n > this.viewCount - 1) {
                n = this.viewCount - 1;
            }
            if (n > 0) {
                this.changeSelection((DTreeNode)this.v.elementAt(n - 1));
            } else if (this.viewCount > 1) {
                this.changeSelection((DTreeNode)this.v.elementAt(1));
            }
        }
        if (dTreeNode.parent != null) {
            if (dTreeNode.parent.child == dTreeNode) {
                if (dTreeNode.sibling != null) {
                    dTreeNode.parent.child = dTreeNode.sibling;
                } else {
                    dTreeNode.parent.child = null;
                    dTreeNode.parent.collapse();
                }
            } else {
                DTreeNode dTreeNode2 = dTreeNode.parent.child;
                while (dTreeNode2.sibling != dTreeNode) {
                    dTreeNode2 = dTreeNode2.sibling;
                }
                dTreeNode2.sibling = dTreeNode.sibling != null ? dTreeNode.sibling : null;
            }
        } else if (dTreeNode == this.rootNode) {
            this.rootNode = dTreeNode.sibling == null ? null : dTreeNode.sibling;
        } else {
            DTreeNode dTreeNode3 = this.rootNode;
            while (dTreeNode3.sibling != dTreeNode) {
                dTreeNode3 = dTreeNode3.sibling;
            }
            dTreeNode3.sibling = dTreeNode.sibling != null ? dTreeNode.sibling : null;
        }
        this.recount();
        this.redrawTriggered = true;
    }

    public DTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedText() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getText();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.redrawTriggered || dimension.width != this.viewWidth || dimension.height != this.viewHeight) {
            this.redraw(graphics);
        }
        graphics.translate(-this.sbHPosition, 0);
        graphics.clipRect(this.sbHPosition, 0, dimension.width - this.sbVWidth, dimension.height - this.sbHHeight);
        graphics.drawImage(this.im1, 1, 1, this);
        graphics.setColor(Color.black);
        graphics.drawRect(this.sbHPosition, 0, dimension.width - 1, dimension.height - 1);
    }

    public void redraw(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.redrawTriggered = false;
        if (this.needResetVector) {
            this.resetVector();
        } else {
            this.needResetVector = true;
        }
        this.newWidth = this.compWidth(graphics);
        int n = (dimension.height - this.sbHHeight) / this.cellSize;
        if (this.viewCount > n) {
            this.sbVShow = true;
            this.sbVWidth = this.verticalScrollBar.getPreferredSize().width;
        } else {
            this.sbVShow = false;
            this.sbVWidth = 0;
            this.sbVPosition = 0;
        }
        if (this.newWidth > dimension.width - this.sbVWidth) {
            this.sbHShow = true;
            this.sbHHeight = this.horizontalScrollBar.getPreferredSize().height;
        } else {
            this.sbHShow = false;
            this.sbHHeight = 0;
            this.sbHPosition = 0;
        }
        this.drawTree();
        if (this.sbVShow) {
            this.verticalScrollBar.setBounds(dimension.width - this.sbVWidth, 0, this.sbVWidth, dimension.height - this.sbHHeight);
            this.verticalScrollBar.setValues(this.sbVPosition, n, 0, this.viewCount);
            this.verticalScrollBar.setBlockIncrement(n - 1);
            this.verticalScrollBar.setVisible(true);
        } else {
            this.verticalScrollBar.setVisible(false);
        }
        if (this.sbHShow) {
            this.horizontalScrollBar.setBounds(0, dimension.height - this.sbHHeight, dimension.width - this.sbVWidth, this.sbHHeight);
            this.horizontalScrollBar.setValues(this.sbHPosition, dimension.width - this.sbVWidth, 0, this.sbHSize - (dimension.width - this.sbVWidth));
            this.horizontalScrollBar.setBlockIncrement(dimension.width - this.sbVWidth);
            this.horizontalScrollBar.setUnitIncrement(this.sbHLineIncrement);
            this.horizontalScrollBar.setVisible(true);
        } else {
            this.horizontalScrollBar.setVisible(false);
        }
    }

    public void drawTree() {
        Font font;
        Dimension dimension = this.getSize();
        if (this.needResetVector) {
            this.resetVector();
        }
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight || this.g1 == null || this.sbHSize != this.newWidth) {
            this.sbHSize = this.newWidth;
            this.im1 = this.createImage(Math.max(this.sbHSize, dimension.width) - 2 - this.sbVWidth, dimension.height - 2);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = dimension.width;
            this.viewHeight = dimension.height;
        }
        if ((font = this.getFont()) == null) {
            font = new Font("TimesRoman", 0, 13);
            this.g1.setFont(font);
            this.setFont(font);
        }
        if (this.g1.getFont() == null) {
            this.g1.setFont(font);
        }
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(this.getBackground());
        this.g1.fillRect(0, 0, this.im1.getWidth(this), dimension.height);
        int n = this.sbVPosition + this.viewHeight / this.cellSize + 1;
        if (n > this.viewCount) {
            n = this.viewCount;
        }
        DTreeNode dTreeNode = null;
        if (!this.v.isEmpty()) {
            dTreeNode = (DTreeNode)this.v.elementAt(this.sbVPosition);
        }
        for (int i = this.sbVPosition; i < n; ++i) {
            int n2;
            DTreeNode dTreeNode2 = (DTreeNode)this.v.elementAt(i);
            int n3 = this.cellSize * (dTreeNode2.depth + 1);
            int n4 = (i - this.sbVPosition) * this.cellSize;
            this.g1.setColor(this.getForeground());
            if (dTreeNode2.sibling != null) {
                n2 = this.v.indexOf(dTreeNode2.sibling) - i;
                if (n2 > n) {
                    n2 = n;
                }
                this.drawDotLine(n3 - this.cellSize / 2, n4 + this.cellSize / 2, n3 - this.cellSize / 2, n4 + this.cellSize / 2 + n2 * this.cellSize);
            }
            for (n2 = 0; n2 < i; ++n2) {
                DTreeNode dTreeNode3 = (DTreeNode)this.v.elementAt(n2);
                if (dTreeNode3.sibling != dTreeNode2 || n2 >= this.sbVPosition) continue;
                this.drawDotLine(n3 - this.cellSize / 2, 0, n3 - this.cellSize / 2, n4 + this.cellSize / 2);
            }
            if (dTreeNode2.isExpanded()) {
                this.drawDotLine(n3 + this.cellSize / 2, n4 + this.cellSize - 2, n3 + this.cellSize / 2, n4 + this.cellSize + this.cellSize / 2);
            }
            this.g1.setColor(this.getForeground());
            this.drawDotLine(n3 - this.cellSize / 2, n4 + this.cellSize / 2, n3 + this.cellSize / 2, n4 + this.cellSize / 2);
            this.drawNodeToggle(dTreeNode2, n3, n4);
            Image image = dTreeNode2.getImage();
            if (image != null) {
                this.g1.drawImage(image, n3 + this.imageInset, n4, this);
            }
            if (dTreeNode2.text != null) {
                this.drawNodeText(dTreeNode2, n4, dTreeNode2 == this.selectedNode);
            }
            if (dTreeNode.depth <= dTreeNode2.depth) continue;
            dTreeNode = dTreeNode2;
        }
        if (dTreeNode != null) {
            while ((dTreeNode = dTreeNode.parent) != null) {
                if (dTreeNode.sibling == null) continue;
                this.drawDotLine(this.cellSize * (dTreeNode.depth + 1) - this.cellSize / 2, 0, this.cellSize * (dTreeNode.depth + 1) - this.cellSize / 2, dimension.height);
            }
        }
        this.needResetVector = true;
    }

    protected void drawNodeToggle(DTreeNode dTreeNode, int n, int n2) {
        if (dTreeNode.isExpandable()) {
            this.g1.setColor(this.getBackground());
            this.g1.fillRect(this.cellSize * dTreeNode.depth + this.cellSize / 4, n2 + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(this.cellSize * dTreeNode.depth + this.cellSize / 4, n2 + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.drawLine(this.cellSize * dTreeNode.depth + this.cellSize / 4 + 2, n2 + this.cellSize / 2, this.cellSize * dTreeNode.depth + this.cellSize / 4 + this.clickSize - 2, n2 + this.cellSize / 2);
            if (!dTreeNode.isExpanded()) {
                this.g1.drawLine(this.cellSize * dTreeNode.depth + this.cellSize / 2, n2 + this.clickSize / 2 + 2, this.cellSize * dTreeNode.depth + this.cellSize / 2, n2 + this.clickSize / 2 + this.clickSize - 2);
            }
        }
    }

    public synchronized Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public synchronized Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public boolean isFocusable() {
        return true;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.adjustment == null) {
            this.adjustment = new Adjustment();
            this.verticalScrollBar.addAdjustmentListener(this.adjustment);
            this.horizontalScrollBar.addAdjustmentListener(this.adjustment);
        }
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.adjustment != null) {
            this.verticalScrollBar.removeAdjustmentListener(this.adjustment);
            this.horizontalScrollBar.removeAdjustmentListener(this.adjustment);
            this.adjustment = null;
        }
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    public void triggerRedraw() {
        this.redrawTriggered = true;
        this.repaint();
    }

    protected void complete(DTreeNode dTreeNode, int n, int n2) {
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    protected void drawNodeText(DTreeNode dTreeNode, int n, boolean bl) {
        Color color;
        Color color2;
        if (dTreeNode == null) {
            return;
        }
        int n2 = dTreeNode.depth;
        Image image = dTreeNode.getImage();
        int n3 = (n2 + 1) * this.cellSize + this.cellSize + this.textInset - (image == null ? 12 : 0);
        if (dTreeNode == this.selectedNode && this.hasFocus) {
            if (OS.isMacintosh()) {
                color2 = Color.white;
                color = new Color(0, 0, 128);
            } else {
                color2 = SystemColor.textHighlightText;
                color = SystemColor.textHighlight;
            }
        } else {
            color2 = this.getForeground();
            color = this.getBackground();
        }
        if (bl) {
            this.g1.setColor(color);
            this.g1.fillRect(n3 - 1, n + 1, this.fm.stringWidth(dTreeNode.text) + 4, this.cellSize - 1);
        }
        if (dTreeNode == this.selectedNode) {
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(n3 - 1, n + 1, this.fm.stringWidth(dTreeNode.text) + 3, this.cellSize - 2);
            this.repaint(Math.max(0, n3 - 1 - this.sbHPosition), n + 1, this.fm.stringWidth(dTreeNode.text) + 4, this.cellSize - 1);
        }
        this.g1.setColor(color2);
        this.g1.drawString(dTreeNode.text, n3, n + this.cellSize - this.textBaseLine);
    }

    protected void sendActionEvent(String string) {
        this.selectedText = new String(this.selectedNode.getText());
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    protected void sendSelectionEvent(int n) {
        this.selectedIndex = n;
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Select"));
        }
    }

    protected int compWidth(Graphics graphics) {
        int n = 0;
        Font font = this.getFont();
        if (font == null) {
            font = new Font("TimesRoman", 0, 13);
            if (graphics != null) {
                graphics.setFont(font);
            }
            this.setFont(font);
        }
        this.fm = graphics == null ? null : graphics.getFontMetrics();
        if (this.fm == null) {
            this.fm = this.getFontMetrics(font);
        }
        if (this.fm == null || this.v == null) {
            n = 100;
        } else {
            for (int i = 0; i < this.v.size(); ++i) {
                DTreeNode dTreeNode = (DTreeNode)this.v.elementAt(i);
                int n2 = (dTreeNode.depth + 1) * this.cellSize + this.cellSize + this.textInset - (dTreeNode.getImage() == null ? 12 : 0);
                if (n >= n2 + this.fm.stringWidth(dTreeNode.text) + 6) continue;
                n = n2 + this.fm.stringWidth(dTreeNode.text) + 6;
            }
        }
        return n;
    }

    protected void drawDotLine(int n, int n2, int n3, int n4) {
        if (n2 == n4) {
            for (int i = n; i < n3; i += 2) {
                this.g1.drawLine(i, n2, i, n4);
            }
        } else {
            for (int i = n2; i < n4; i += 2) {
                this.g1.drawLine(n, i, n3, i);
            }
        }
    }

    protected void changeSelection(DTreeNode dTreeNode) {
        if (dTreeNode == this.selectedNode) {
            return;
        }
        DTreeNode dTreeNode2 = this.selectedNode;
        this.selectedNode = dTreeNode;
        this.drawNodeText(dTreeNode2, (this.v.indexOf(dTreeNode2) - this.sbVPosition) * this.cellSize, true);
        this.drawNodeText(dTreeNode, (this.v.indexOf(dTreeNode) - this.sbVPosition) * this.cellSize, true);
        int n = this.v.indexOf(this.selectedNode);
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, dTreeNode2, 2));
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
        }
        if (n < this.sbVPosition) {
            --this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        if (n >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            ++this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        this.sendSelectionEvent(n);
        this.repaint();
    }

    protected void absoluteSelection(DTreeNode dTreeNode) {
        if (dTreeNode == this.selectedNode) {
            return;
        }
        DTreeNode dTreeNode2 = this.selectedNode;
        this.selectedNode = dTreeNode;
        this.drawNodeText(dTreeNode2, (this.v.indexOf(dTreeNode2) - this.sbVPosition) * this.cellSize, true);
        this.drawNodeText(dTreeNode, (this.v.indexOf(dTreeNode) - this.sbVPosition) * this.cellSize, true);
        int n = this.v.indexOf(this.selectedNode);
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, dTreeNode2, 2));
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
        }
        if (n < this.sbVPosition) {
            this.sbVPosition = n;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        if (n >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            this.sbVPosition = n;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        this.sendSelectionEvent(n);
        this.repaint();
    }

    protected DTreeNode newTreeNode(String string, DTreeView dTreeView) {
        return new DTreeNode(string, dTreeView);
    }

    protected void recount() {
        this.count = 0;
        this.e = new Vector();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    protected void traverse(DTreeNode dTreeNode) {
        ++this.count;
        this.e.addElement(dTreeNode);
        if (dTreeNode.child != null) {
            dTreeNode.child.depth = dTreeNode.depth + 1;
            this.traverse(dTreeNode.child);
        }
        if (dTreeNode.sibling != null) {
            dTreeNode.sibling.depth = dTreeNode.depth;
            this.traverse(dTreeNode.sibling);
        }
    }

    protected void resetVector() {
        this.v = new Vector(this.count);
        this.viewWidest = 30;
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, true, this.v);
        this.viewCount = this.v.size();
        this.needResetVector = false;
    }

    protected void vectorize(DTreeNode dTreeNode, boolean bl, Vector vector) {
        if (dTreeNode == null) {
            return;
        }
        vector.addElement(dTreeNode);
        if (!bl && dTreeNode.child != null || dTreeNode.isExpanded()) {
            dTreeNode.child.depth = dTreeNode.depth + 1;
            this.vectorize(dTreeNode.child, bl, vector);
        }
        if (dTreeNode.sibling != null) {
            dTreeNode.sibling.depth = dTreeNode.depth;
            this.vectorize(dTreeNode.sibling, bl, vector);
        }
    }

    protected void debugVector() {
        for (int i = 0; i < this.count; ++i) {
            DTreeNode dTreeNode = (DTreeNode)this.v.elementAt(i);
            System.out.println(dTreeNode.text);
        }
    }

    public int getSelectedIndex() {
        if (this.selectedNode != null) {
            for (int i = 0; i < this.viewCount; ++i) {
                if (this.selectedNode != this.v.elementAt(i)) continue;
                return i;
            }
        }
        return 0;
    }

    protected void handleMousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n2 / this.cellSize + this.sbVPosition;
        if (n3 > this.viewCount - 1) {
            return;
        }
        DTreeNode dTreeNode = this.selectedNode;
        DTreeNode dTreeNode2 = (DTreeNode)this.v.elementAt(n3);
        int n4 = dTreeNode2.getDepth();
        Rectangle rectangle = new Rectangle(this.cellSize * n4 + this.cellSize / 4, (n3 - this.sbVPosition) * this.cellSize + this.clickSize / 2, this.clickSize, this.clickSize);
        if (rectangle.contains(n, n2)) {
            this.complete(dTreeNode2, n, n2);
            dTreeNode2.toggle();
            this.resetVector();
            if (!dTreeNode2.isExpanded() && !this.v.contains(this.selectedNode)) {
                this.changeSelection(dTreeNode2);
            }
            this.triggerRedraw();
            this.invalidate();
        } else {
            this.changeSelection(dTreeNode2);
            if (dTreeNode2 == dTreeNode && mouseEvent.getWhen() - this.timeMouseDown < (long)this.doubleClickResolution) {
                dTreeNode2.toggle();
                this.resetVector();
                this.triggerRedraw();
                this.invalidate();
                return;
            }
            this.timeMouseDown = mouseEvent.getWhen();
        }
    }

    protected void handleAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.verticalScrollBar) {
            if (this.sbVPosition != this.verticalScrollBar.getValue()) {
                this.sbVPosition = this.verticalScrollBar.getValue();
                this.triggerRedraw();
            }
        } else if (adjustmentEvent.getAdjustable() == this.horizontalScrollBar && this.sbHPosition != this.horizontalScrollBar.getValue()) {
            this.sbHPosition = this.horizontalScrollBar.getValue();
            this.triggerRedraw();
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        int n = this.v.indexOf(this.selectedNode);
        int n2 = this.viewHeight / this.cellSize;
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.sendActionEvent("Enter");
                this.requestFocus();
                break;
            }
            case 127: {
                this.sendActionEvent("Del");
                this.requestFocus();
                break;
            }
            case 32: {
                if (keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown()) break;
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.complete(this.selectedNode, 0, 0);
                    this.triggerRedraw();
                    break;
                }
                if (!this.selectedNode.isExpanded()) break;
                this.selectedNode.toggle();
                this.triggerRedraw();
                break;
            }
            case 37: {
                if (keyEvent.isControlDown()) {
                    if (this.sbHPosition <= 0) break;
                    this.horizontalScrollBar.setValue(Math.max(this.sbHPosition -= this.sbHLineIncrement, 0));
                    this.repaint();
                    break;
                }
                n = this.v.indexOf(this.selectedNode.getParent());
                this.absoluteSelection((DTreeNode)this.v.elementAt(n));
                this.requestFocus();
                break;
            }
            case 38: {
                if (n <= 0) break;
                this.changeSelection((DTreeNode)this.v.elementAt(--n));
                this.requestFocus();
                break;
            }
            case 39: {
                if (keyEvent.isControlDown()) {
                    int n3 = this.horizontalScrollBar.getMaximum() - (this.getSize().width - this.sbVWidth);
                    if (!this.sbHShow || this.sbHPosition >= n3) break;
                    this.horizontalScrollBar.setValue(Math.min(this.sbHPosition += this.sbHLineIncrement, n3));
                    this.repaint();
                    break;
                }
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.complete(this.selectedNode, 0, 0);
                    this.triggerRedraw();
                    break;
                }
                if (!this.selectedNode.isExpandable()) break;
            }
            case 40: {
                if (n >= this.viewCount - 1) break;
                this.changeSelection((DTreeNode)this.v.elementAt(++n));
                this.requestFocus();
                break;
            }
            case 36: {
                if (n <= 0) break;
                n = 0;
                this.absoluteSelection((DTreeNode)this.v.elementAt(n));
                this.requestFocus();
                break;
            }
            case 33: {
                if (n > this.sbVPosition) {
                    n = this.sbVPosition;
                    this.absoluteSelection((DTreeNode)this.v.elementAt(n));
                    this.requestFocus();
                    break;
                }
                n = Math.max(0, n - n2);
                this.absoluteSelection((DTreeNode)this.v.elementAt(n));
                this.requestFocus();
                break;
            }
            case 34: {
                int n4 = this.sbVPosition + n2 - 1;
                n = n < n4 ? n4 : (n += n2);
                this.absoluteSelection((DTreeNode)this.v.elementAt(n));
                this.requestFocus();
                break;
            }
            case 35: {
                if (n < this.viewCount - 1) {
                    n = this.viewCount - 1;
                    this.absoluteSelection((DTreeNode)this.v.elementAt(n));
                    this.requestFocus();
                    break;
                }
                if (n >= this.count - 1) break;
                n = this.count - 1;
                this.absoluteSelection((DTreeNode)this.v.elementAt(n));
                this.requestFocus();
                break;
            }
        }
    }

    class Focus
    extends FocusAdapter
    implements Serializable {
        Focus() {
        }

        public void focusGained(FocusEvent focusEvent) {
            DTreeView.this.hasFocus = true;
            if (DTreeView.this.selectedNode != null && DTreeView.this.v != null) {
                DTreeView.this.drawNodeText(DTreeView.this.selectedNode, (DTreeView.this.v.indexOf(DTreeView.this.selectedNode) - DTreeView.this.sbVPosition) * DTreeView.this.cellSize, true);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            DTreeView.this.hasFocus = false;
            if (DTreeView.this.selectedNode != null && DTreeView.this.v != null) {
                DTreeView.this.drawNodeText(DTreeView.this.selectedNode, (DTreeView.this.v.indexOf(DTreeView.this.selectedNode) - DTreeView.this.sbVPosition) * DTreeView.this.cellSize, true);
            }
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        Key() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            DTreeView.this.handleKeyPressed(keyEvent);
        }
    }

    class Mouse
    extends MouseAdapter {
        Mouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DTreeView.this.handleMousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class Adjustment
    implements AdjustmentListener,
    Serializable {
        Adjustment() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            DTreeView.this.handleAdjustmentEvent(adjustmentEvent);
        }
    }
}

