/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.Serializable;
import java.net.URL;

public class ListItem
implements Serializable {
    URL url = null;
    transient Image image;
    String sText;
    boolean bEnabled;
    boolean bSelected;
    transient boolean bDirty;
    Color color;
    int lineWidth;
    boolean bCellBorder;
    Color cellBorderColor;
    boolean bEdited = false;
    boolean deleted = false;
    boolean tagged = false;

    public ListItem(Image image, String string, boolean bl, FontMetrics fontMetrics, boolean bl2) {
        this.image = image;
        this.sText = string;
        this.bEnabled = bl;
        this.bSelected = false;
        this.bDirty = true;
        this.color = null;
        this.bCellBorder = bl2;
        this.cellBorderColor = Color.black;
        this.updateWidth(fontMetrics);
    }

    public ListItem(Image image, URL uRL, String string, boolean bl, FontMetrics fontMetrics, boolean bl2) {
        this(image, string, bl, fontMetrics, bl2);
        this.url = uRL;
    }

    public void updateWidth(FontMetrics fontMetrics) {
        this.lineWidth = fontMetrics != null ? fontMetrics.stringWidth(this.sText) : 0;
    }

    public String toString() {
        String string = "ListItem ".concat(String.valueOf(String.valueOf(this.sText)));
        if (this.image != null) {
            string = String.valueOf(String.valueOf(string)).concat(" [Image]");
        }
        if (this.color != Color.black) {
            string = String.valueOf(String.valueOf(string)).concat(" [Colored]");
        }
        string = this.bEnabled ? String.valueOf(String.valueOf(string)).concat(" [Enabled]") : String.valueOf(String.valueOf(string)).concat(" [Disabled]");
        string = this.bSelected ? String.valueOf(String.valueOf(string)).concat(" [Selected]") : String.valueOf(String.valueOf(string)).concat(" [Not Selected]");
        if (this.bDirty) {
            string = String.valueOf(String.valueOf(string)).concat(" [Dirty]");
        }
        return string;
    }
}

