/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ColorUtils;
import common.DButtonBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;

public class TButton
extends DButtonBase
implements Serializable {
    protected Color textColor = null;
    protected Color disabledTextColor = null;
    Image icon;

    public TButton() {
        this("");
    }

    public TButton(String string) {
        this.label = string;
        this.textColor = Color.black;
        this.disabledTextColor = ColorUtils.lighten(this.textColor, 0.5);
    }

    public TButton(Image image, String string) {
        this(string);
        this.icon = image;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 5, dimension.height + 5);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 3, dimension.height + 3);
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        Graphics graphics = this.buttonImage.getGraphics();
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.setFont(super.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight() + 4;
        int n4 = fontMetrics.stringWidth(this.label) + 6;
        int n5 = (n - n4) / 2 + 3;
        int n6 = (n2 - n3) / 2 + 3 + 13;
        if (this.icon != null) {
            int n7 = this.icon.getWidth(this);
            int n8 = n2 - 8;
            n5 = n2 + (n - n2 - n4) / 2;
            graphics.drawImage(this.icon, 4, (n2 - n8) / 2, n7, n8, this);
        }
        if (this.isEnabled()) {
            graphics.setColor(this.textColor);
        } else {
            graphics.setColor(this.disabledTextColor);
        }
        graphics.drawString(this.label, n5, n6);
        if (graphics != null) {
            graphics.dispose();
        }
    }

    protected boolean isValidBevelSize(int n) {
        Dimension dimension = this.getSize();
        int n2 = n * 2 + 4;
        return n >= 0 && dimension.width >= n2 && dimension.height >= n2;
    }
}

