// LockCheck
// A Simple utility for use in Win32 command line batch files to determine if a file is in use

#include <iostream.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>

int main(int argc, char *argv[])
{
    int handle;
    
    if (argc != 2)
    {
        cout << "\nLockCheck 1.00" << endl;
        cout << "Usage: LockChk <filename>\n";
        return (1);
    }

    handle = sopen(argv[1], O_EXCL, SH_DENYRW);
    if (handle == -1)
    {
        cout << "\nLockCheck: The file does not exist or is locked by another process\n";
        return (1);
    }

    close (handle);
    cout << "\nLockCheck: The file is not locked\n";
    return (0);
}
