// mcchkDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mcchk.h"
#include "mcchkDlg.h"

#include <direct.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// obtain file type

int ftype( const char *fname, BOOL *exists)
{
	struct _stat stat_buf;

	*exists = FALSE;
    if( 0 != _stat( fname, &stat_buf )) return 0;

	*exists = TRUE;
	return stat_buf.st_mode;
}



/////////////////////////////////////////////////////////////////////////////
// write an output message to list

void CMcchkDlg::checkout(const char *file_name, const char *msg)
{
	CString out = CString(file_name) + CString(" ") + CString(msg);

	CListBox *pBox = ( CListBox *) GetDlgItem(IDC_LIST1);
	int numItems = pBox->GetCount();
	pBox->DeleteString(numItems-1);
	pBox->InsertString( -1, (LPCTSTR) out);
}

/////////////////////////////////////////////////////////////////////////////
// check - scan a regular file for integrity

const size_t buffer_size = 1440000L;
static char buffer[buffer_size];

void CMcchkDlg::check(const char *file_name)
{
	FILE *fp_in;
	int file_error;
	size_t bytes_read;
	int file_number =0;
	size_t bytes_unread, num_of_bytes_to_read;
	struct _stat stat_buf;
 

	// tell user file is being processed
	CString out = CString(file_name) + CString(" processing");
	CListBox *pBox = ( CListBox *) GetDlgItem(IDC_LIST1);
	pBox->InsertString(-1, (LPCTSTR) out);
  
	BOOL exists;
	int type = ftype(file_name, &exists);
	if( !exists )
	{
		checkout(file_name, "nonexistent");
		return;
	}

	/* must be a regular file */
	if(!(type & _S_IFREG))
	{
		checkout(file_name, "non-regular file");
		return;
	}

   
	/* open file for reading */
	fp_in = fopen(file_name, "rb");
	if(!fp_in)
    {
		checkout(file_name, "non-existent");
		return;
	}

	/* loop over input file */
	_stat(file_name, &stat_buf);
	bytes_unread = stat_buf.st_size;
	while(bytes_unread >0)
	{

		/* read the minimum of buffer-size and bytes_unread */
		num_of_bytes_to_read = bytes_unread;
		if(num_of_bytes_to_read > buffer_size)
			num_of_bytes_to_read = buffer_size;

		bytes_read = fread(buffer,1,num_of_bytes_to_read, fp_in);


		/* check number of bytes read is correct */
		if(bytes_read != num_of_bytes_to_read)
		{
			checkout(file_name, "fail");
			return;
		}

		/* check for errors */      
		file_error = ferror(fp_in);
		if(file_error)
		{
			checkout(file_name, "fail");
			return;
		}

		bytes_unread -= bytes_read;
	} /* end while */

	checkout(file_name, "ok"); /* success at last! */
	return;
}



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMcchkDlg dialog

CMcchkDlg::CMcchkDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMcchkDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMcchkDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMcchkDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMcchkDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMcchkDlg, CDialog)
	//{{AFX_MSG_MAP(CMcchkDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_SCAN, OnButtonScan)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMcchkDlg message handlers

BOOL CMcchkDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	CEdit *pEdit = ( CEdit *) GetDlgItem(IDC_EDIT_DIR);
	CString editText("a:\\.");
	pEdit->SetWindowText( (LPCTSTR) editText );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMcchkDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMcchkDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMcchkDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// markc
void CMcchkDlg::OnButtonScan() 
{
	CString input;
	GetDlgItem(IDC_EDIT_DIR)->GetWindowText(input);
	const char *p_input = (LPCTSTR) input;

	int file_type;

	// empty list box
	CListBox *pBox = ( CListBox *) GetDlgItem(IDC_LIST1);
	pBox->ResetContent();


	BOOL exists;
	file_type = ftype(p_input, &exists);
	if(exists)
	{
		if( file_type & _S_IFREG)
		{
			check(p_input);
		}
		else if( file_type & _S_IFDIR )
		{
			curz(p_input);
		}
		else
		{
			CString out = CString(p_input) + 
				CString(" unprocessable - skipping");
			pBox->InsertString(-1, (LPCTSTR) out);
		}
	}
	else
	{
		CString out = CString(p_input) + 
			CString(" unprocessable - non-existent");
		pBox->InsertString(-1, (LPCTSTR) out);
	}

}



int CMcchkDlg::curz(const char *dir_name)
{

	int file_number =0;
	struct _stat stat_buf;
	int result;
	char filespec[FILENAME_MAX];

	/* Get data associated with dir_name */
	result = _stat( dir_name, &stat_buf );

	/* Check if statistics are valid: */
	if( result != 0 )
	{
		checkout(dir_name, "non-existent" );
		return EXIT_FAILURE;
	}

	/* demand that it is a directory */
	if(! (stat_buf.st_mode & _S_IFDIR))
	{
		checkout(dir_name, "Error - not a directory" );
		return EXIT_FAILURE;
	}

	sprintf(filespec,"%s\\*.*",dir_name);
	struct _finddata_t fileinfo;
	long search_handle = _findfirst( filespec,  &fileinfo);
	if(-1 == search_handle)
	{
		checkout(dir_name, "Error - invalid file spec");
		return EXIT_FAILURE;
	}
  

	while(1)
	{
		/* full file name */
		sprintf(filespec,"%s\\%s", dir_name, fileinfo.name);
		
		/* determine file type */
		result = _stat( filespec, &stat_buf );
		if( result != 0 )
		{
			checkout( filespec, "Error - non-existent" );
			return EXIT_FAILURE;
		}
		int file_type = stat_buf.st_mode;

		/* perform action according to file type */
		if((file_type & _S_IFDIR) && strcmp(".", fileinfo.name) && strcmp("..", fileinfo.name))
		{
			/* recurse directory */
			curz(filespec);
		}
		else if(file_type & _S_IFREG)
		{			
			check(filespec);
		}


		/* any more files in directory? */
		if(-1 == _findnext(search_handle, &fileinfo)) break;
	}

	_findclose(search_handle);
	return EXIT_SUCCESS;
}
