/*
* This file is released into the Public Domain.
* M Carter  02-dec-2000 Begin
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <io.h>
//#include <sys/stat.h>

//#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>



  

void process_args(int argc, char *argv[]);

size_t buffer_size = 1440000L;
char *buffer;

/*
 * check file
 */
int check(char *file_name)
{
  FILE *fp_in;
   int file_error;
  size_t bytes_read;
  int file_number =0;
  size_t bytes_unread, num_of_bytes_to_read;
   struct _stat stat_buf;
   int result;

  printf("%s ", file_name);


   /* Get data associated with "stat.c": */
   result = _stat( file_name, &stat_buf );

   /* Check if statistics are valid: */
   if( result != 0 )
   {
      puts( "non-existent" );
	  return EXIT_SUCCESS;
	  }

   /* must be a regular file */
if(!(stat_buf.st_mode & _S_IFREG))
{
	puts("non-regular file");
	return EXIT_SUCCESS;
}

   
   /* open file for reading */
  fp_in = fopen(file_name, "rb");
  if(!fp_in)
    {
      puts("non-existent");
      return EXIT_FAILURE;
    }



  /* loop over input file */
  bytes_unread = stat_buf.st_size;
  while(bytes_unread >0)
  {

	/* read the minimum of buffer-size and bytes_unread */
	num_of_bytes_to_read = bytes_unread;
	if(num_of_bytes_to_read > buffer_size)
		num_of_bytes_to_read = buffer_size;

	bytes_read = fread(buffer,1,num_of_bytes_to_read, fp_in);


	/* check number of bytes read is correct */
	if(bytes_read != num_of_bytes_to_read)
	{
		puts("fail");
		return EXIT_FAILURE;
	}

	/* check for errors */      
	file_error = ferror(fp_in);
    if(file_error)
	{
		puts("fail");
		return EXIT_FAILURE;
	}

	bytes_unread -= bytes_read;
  } /* end while */

  puts("ok"); /* success at last! */
}


/*
 * main
 */
int main(int argc, char *argv[])
{
	buffer = (char *) malloc(buffer_size);
	if(!buffer)
	{
		fprintf(stderr, "Couldn't allocate memory\n");
		return EXIT_FAILURE;
	}

	process_args(argc, argv);

	free(buffer);

	return EXIT_SUCCESS;
}

/*
* process arguments 
*/

void process_args(int argc, char *argv[])
{
  int arg_num;
  char *arg;
  if(1 == argc)
    {
      fprintf(stderr,"No arguments. Try %s --help\n", argv[0]);
    }


  for(arg_num = 1; arg_num<argc; arg_num++)
  {
      arg = argv[arg_num];
      if(0==strcmp("-h",arg) || 0 ==strcmp("--help",arg))
	{
	  printf("Usage: %s [OPTION] ... [FILE] ...\n",argv[0]);
	  puts("Checks that files can be read.");
	  puts(""); 
	  puts("-h, --help     Display this help");
	  puts("-v, --version  Version information");
	  return;
	}
      else if(0==strcmp("-v", arg) || 0==strcmp("--version",arg))
	{
	  puts("mccheck (MC fileutils) 0.1");
	  return;
	}
      else
	  {
	check(arg);
	  }
  }


}
