
#include <direct.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <string.h>


char *command = 0; /* e.g. "echo". Set by main. */

int curz(char *dir_name);
void list_regular_files_in_dir(char *dir_name);
void execute_command(char *filespec);



int curz(char *dir_name)
{

  int file_number =0;
   struct _stat stat_buf;
   int result;
   

   /* Get data associated with dir_name */
   result = _stat( dir_name, &stat_buf );

   /* Check if statistics are valid: */
   if( result != 0 )
   {
      puts( "non-existent" );
	  return EXIT_SUCCESS;
   }

   /* demand that it is a directory */
   if(! (stat_buf.st_mode & _S_IFDIR))
   {
	   printf("Error: %s is not a directory\n", dir_name);
	   return EXIT_FAILURE;
   }


	list_regular_files_in_dir(dir_name);
}

void execute_command(char *filespec)
{
	
	char *full_command;

	/* allocate memory full command */
	full_command = malloc(strlen(command) + 1 + strlen(filespec) +1);
	if(0 == full_command)
	{
		fprintf(stderr,"Memory allocation failure\n");
		return;
	}

	/* create the command line we wnat to execute */
	sprintf(full_command,"%s %s", command, filespec);

	/* now execute it */
	system(full_command);

	free(full_command);
}


void list_regular_files_in_dir(char *dir_name)
{
	struct _finddata_t fileinfo;
	char filespec[FILENAME_MAX];
	long search_handle;
	int result;
	struct _stat stat_buf;
	int file_type;

	sprintf(filespec,"%s\\*.*",dir_name);
	search_handle = _findfirst( filespec,  &fileinfo);
	if(-1 == search_handle)
	{
		printf("%s: Error invalid file spec\n",dir_name);
		return;
	}
  

	while(1)
	{
		/* full file name */
		sprintf(filespec,"%s\\%s", dir_name, fileinfo.name);
		
		/* determine file type */
		result = _stat( filespec, &stat_buf );
		if( result != 0 )
		{
			printf( "Error: %s non-existent", filespec);
			return ;
		}
		file_type = stat_buf.st_mode;

		/* perform action according to file type */
		if((file_type & _S_IFDIR) && strcmp(".", fileinfo.name) && strcmp("..", fileinfo.name))
		{
			/* recurse directory */
			curz(filespec);
		}
		else if(file_type & _S_IFREG)
		{			
			execute_command(filespec);
		}


		/* any more files in directory? */
		if(-1 == _findnext(search_handle, &fileinfo)) break;
	}

	_findclose(search_handle);
}

void main( int argc, char *argv[] )
{
	/* E.g. in "mccurz /etc foo bar", foo is arg 2 */
	int arg_at_which_command_begins =2;
	int arg =0; /* looping variable over arguments */
	int command_strlen; /* number of chars required for command */

	char *dir = argv[1];

	/* ensure that there's a command to execute */
	if(arg_at_which_command_begins > argc)
	{
		fprintf(stderr, "Error: no command to execute\n");
		return;
	}

	/* determine the memory required for the command */
	command_strlen = 0;
	for(arg = arg_at_which_command_begins; arg < argc; arg++)
	{
		/* "+1" for space separator of null terminator */
		command_strlen += strlen(argv[arg]) +1;
	}

	/* allocate space for command */
	command	= malloc(command_strlen);
	if(0 == command)
	{
		fprintf(stderr, "Memory allocation failure "
			"trying to construct command\n");
		return;
	}

	/* construct the command */
	command[0] = '\0';
	for(arg = arg_at_which_command_begins; arg < argc; arg++)
	{
		strcat(command, argv[arg]);

		/* add inter-command space */
		if(arg + 1 < argc)
			strcat(command, " ");
	}

	curz(dir);


}

  
