/*
* This file is released into the Public Domain.
* M Carter  18-nov-2000 Begin
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

  size_t buffer_size = 1440000L;
  char *buffer;

/*
 * append file fp_in to fp_out.
 * Caller must check that fp_in and fp_out are valid
 */
void append(FILE *fp_in, char * in_file_name, FILE* fp_out, 
	    char *out_file_name)
{
  char msg[1000];
  size_t bytes_read;



  /* loop over the input file as many times as necessary */
  while(1)
    {
      bytes_read = fread(buffer, 1, buffer_size, fp_in);

      if(bytes_read>0)
	{
	  /* clear error flags set due to reading less than
	   * precisely buffer_size bytes 
	   */
	  clearerr(fp_in);
 
	  /* write to file */  
	  fwrite(buffer, 1, bytes_read, fp_out);
	  if(ferror(fp_out))
	    {
	      sprintf(msg,"Error: %s",out_file_name);
	      perror(msg);
	      return;
	    }
	}
      else
	{
	  /* check for errors */
	  if(ferror(fp_in) )
	    {
	      sprintf(msg,"Error: %s",in_file_name);
	      perror(msg);
	    }

	  return;
	}
 

    }
}


/*
 * join files
 */
void join(char *base_file_name)
{
  FILE *fp_in;
  FILE  *fp_out;

  char in_file_name[1000]; /* labelled myfile.001, myfile.002, etc. */
  int file_number =0;

  /* open file for writing */
  fp_out = fopen(base_file_name, "wb");
  if(!fp_out)
    {
      fprintf(stderr,"Error: Couldn't open %s\n",base_file_name);
      return;
    }



  /* loop over input files */
  while(1)
    {
      file_number++;

      /* determine file name */
      sprintf(in_file_name,"%s.%03d", base_file_name, file_number);
 
      /* open file for reading */ 
      fp_in = fopen(in_file_name, "rb");
      if(!fp_in) /* only an error if it's the first file */ 
	{
	  if(1 == file_number)
	    {
	      fprintf(stderr,"Error : File %s does not exist\n",
		      in_file_name);
	      return;
	    }
	  else /* we've exhausted all the input files, so return */
	    return;
	}

      printf("Joining %s\n", in_file_name);
      append(fp_in, in_file_name, fp_out, base_file_name);

    }
}


/*
 * main
 */
int main(int argc, char *argv[])
{
  /* process arguments */
  int arg_num;
  char *arg;

  if(1 == argc)
    {
      fprintf(stderr,"No arguments. Try %s --help\n", argv[0]);
	  exit(EXIT_FAILURE);
    }

  /* allocate memory for the buffer */
  buffer = (char *)malloc(buffer_size);
  if(!buffer)
    {
      fprintf(stderr,"Memory allocation error : abort");
      exit(EXIT_FAILURE);
    }  for(arg_num = 1; arg_num<argc; arg_num++)
  {
      arg = argv[arg_num];
      if(0==strcmp("-h",arg) || 0 ==strcmp("--help",arg))
	{
	  printf("Usage: %s [OPTION] ... [BASE] ...\n",argv[0]);
	  puts("Joins  short files into a long file.");
	  puts("BASE is base name of file");
	  puts("E.g. if the following files exist: myfile.001, myfile.002, "
	       "myfile.003");
	  printf("Then: '%s myfile' concatenates them to create myfile\n",
		  argv[0]);  
	  puts(""); 
	  puts("-h, --help     Display this help");
	  puts("-v, --version  Version information");
	}
      else if(0==strcmp("-v", arg) || 0==strcmp("--version",arg))
	{
	  puts("mcjoin (MC fileutils) 0.1");
	}
      else
	join(arg);
  }
	return EXIT_SUCCESS;
}
