/*
* This file is released into the Public Domain.
* M Carter  18-nov-2000 Begin
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>


void ranfile(long num_bytes, char *file_name)
{
  FILE *fp_out;
  long i; /* number of bytes to write */
  char msg[1000];
  char buffer[1]; /* only need to write 1 byte at a time */
  long random_char;
  time_t t_secs;

  /* set seed */
  time(&t_secs );
  srand(t_secs);

  /* create a file for writing */
  fp_out = fopen(file_name, "wb");
  if(!fp_out)
    {
      fprintf(stderr,"Error: Couldn't write to file %s\n", file_name);
      return;
    }
  printf("Writing file %s\n",file_name);
  
  for(i =0; i< num_bytes; i++)
    {
      /* generate a random number */
      random_char = rand() % 255;
      buffer[0] = (char) random_char;

      /* write to file */
      fwrite(buffer, 1, 1, fp_out);
      if(ferror(fp_out))
	{
	  sprintf(msg,"Error: %s", file_name);
	  perror(msg);
	  return;
	}

    }
}


/*
 * main
 */
void main(int argc, char *argv[])
{
  long num_bytes = 1440000L ; /* default value for number of bytes to write */

  /* process arguments */
  int arg_num;
  char *arg;
  if(1 == argc)
    {
      fprintf(stderr,"No arguments. Try %s --help\n", argv[0]);
    }


  for(arg_num = 1; arg_num<argc; arg_num++)
  {
      arg = argv[arg_num];
      if(0==strcmp("-h",arg) || 0 ==strcmp("--help",arg))
	{
	  printf("Usage: %s [OPTION] ... [FILE]\n",argv[0]);
	  puts("Creates a file of random bytes.");
	  puts(""); 
	  puts("-s, --size     Number of bytes to write.");
	  puts("-h, --help     Display this help");
	  puts("-v, --version  Version information");
	}
      else if(0==strcmp("-v", arg) || 0==strcmp("--version",arg))
	{
	  puts("mcsplit (MC fileutils) 0.1");
	}
      else if(0==strcmp("-s",arg) || 0 == strcmp("--size",arg))
	{
	  arg_num++;
	  if(arg_num >= argc)
	    {
	      fprintf(stderr,"Error: Not enough arguments");
	      exit(EXIT_FAILURE);
	    }
	  num_bytes = atol(argv[arg_num]);
	}
	  else
	    {
	      ranfile(num_bytes, arg);
	    }
	}
}


