{******************************************************}
{ StrFuncs unit                                        }
{ Copyright (c) 1998-1999 Magnus Bck                  }
{ baeck@swipnet.se                                     }
{******************************************************}
{ This software may be distributed and modified freely }
{ as long as the original copyright is not removed and }
{ no profit is made from it.                           }
{******************************************************}

unit StrFuncs;

interface

uses SysUtils;

function Chop(S: string): string;
function Same(S1, S2: string): Boolean;
function PadRight(const S: string; Width: Byte): string;
function PadLeft(const S: string; Width: Byte): string;
function Replace(const S, ReplWhat, ReplWith: string): string;
function PadThousand(const S: string; Delimiter: Char): string;
function TrailingBackslash(S: string): string;
function StripExtension(S: string): string;
function ConstructPath(FilePath, FileName, FileExt: TFileName): string;
function StripTrailingBlanks(S: string): string;
function StripLeadingBlanks(S: string): string;

implementation

function Chop(S: string): string;
var
	TempS: string;
begin
	TempS := S;
	Delete(TempS, Length(TempS), 1);
	Result := TempS;
end;

function Same(S1, S2: string): Boolean;
begin
	Same := AnsiCompareText(S1, S2) = 0;
end;

function PadThousand(const S: string; Delimiter: Char): string;
var
	TempS: string;
begin
	TempS := S;
	if Length(TempS) > 3 then
		Insert(Delimiter,TempS,Length(TempS) - 2);
	if Length(TempS) > 7 then
		Insert(Delimiter,TempS,Length(TempS) - 6);
	if Length(TempS) > 11 then
		Insert(Delimiter,TempS,Length(TempS) - 10);
	if Length(TempS) > 18 then
		Insert(Delimiter,TempS,Length(TempS) - 17);
	Result := TempS;
end;

function Replace(const S, ReplWhat, ReplWith: string): string;
var
	Index: Integer;
	Dest: string;
begin
	Dest := S;
	Index := Pos(ReplWhat,Dest);
	while Index <> 0 do
	begin
		Delete(Dest,Index,Length(ReplWhat));
		Insert(ReplWith,Dest,Index);
		Index := Pos(ReplWhat,Dest);
	end;
	Result := Dest;
end;

function PadRight(const S: string; Width: Byte): string;
var
	TempS: string;
	Temp: array [0..255] of Char;
begin
	TempS := S;
	if Length(S) < Width then
	begin
		FillChar(Temp,SizeOf(Temp),' ');
		Temp[Width - Length(S)] := #0;
		TempS := TempS + StrPas(Temp);
	end;
	Result := TempS;
end;

function PadLeft(const S: string; Width: Byte): string;
var
	TempS: string;
	Temp: array [0..255] of Char;
begin
	TempS := S;
	if Length(S) < Width then
	begin
		FillChar(Temp,SizeOf(Temp),' ');
		Temp[Width - Length(S)] := #0;
		TempS := StrPas(Temp) + TempS;
	end;
	Result := TempS;
end;

function Clean(const S: string): string;
var
	TempS: array [0..1024] of Char;
begin
	FillChar(TempS,SizeOf(TempS),#0);
	StrPCopy(TempS,S);
	Result := StrPas(TempS);
end;

function TrailingBackslash(S: string): string;
var
	TempS: string;
begin
	TempS := Clean(S);
	if (Length(TempS) = 0) or (TempS[Length(TempS)] = '\') then
		Result := S
	else
		Result := Concat(S,'\');
end;

function StripExtension(S: string): string;
var
	TempS: string;
begin
	TempS := S;
	Delete(TempS,Pos('.',TempS),4);
	Result := TempS;
end;

function ConstructPath(FilePath, FileName, FileExt: TFileName): string;
var
	TempS: string;
begin
	if FilePath <> '' then
		TempS := Concat(TrailingBackslash(Clean(FilePath)),Clean(FileName))
	else
		TempS := FileName;
	if FileExt <> '' then
	begin
		if FileExt[1] = '.' then
			TempS := Concat(TempS,FileExt)
		else
			TempS := Concat(TempS,'.',FileExt);
	end;
	Result := TempS;
end;


function StripTrailingBlanks(S: string): string;
var
	TempS: string;
begin
	TempS := S;
	while TempS[Length(TempS)] = ' ' do
		Delete(TempS,Length(TempS),1);
	Result := TempS;
end;

function StripLeadingBlanks(S: string): string;
var
	TempS: string;
begin
	TempS := S;
	while TempS[1] = ' ' do
		Delete(TempS,1,1);
	Result := TempS;
end;

end.
