/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects;

import java.io.File;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;
import org.nakedobjects.Application;
import org.nakedobjects.object.AbstractNakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.UpdateNotifier;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.distribution.ServerConsole;
import org.nakedobjects.utility.ConfigurationException;
import org.nakedobjects.utility.ConfigurationParameters;
import org.nakedobjects.utility.Log;

public class ObjectServer
extends Application {
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$ObjectServer == null ? (class$org$nakedobjects$ObjectServer = ObjectServer.class$("org.nakedobjects.ObjectServer")) : class$org$nakedobjects$ObjectServer));
    private static final String DEFAULT_CONFIG = "./server.properties";
    private static final String APPLICATION = "nakedobjects.console";
    private static final String SERVER = "nakedobjects.server";
    private static final String OBJECT_STORE = "nakedobjects.object-store";
    private static final String ACCESS_LOG = "nakedobjects.object-store.log";
    private static final String UPDATE_NOTIFIER = "nakedobjects.object-store.notifier";
    static /* synthetic */ Class class$org$nakedobjects$ObjectServer;
    static /* synthetic */ Class class$org$nakedobjects$object$UpdateNotifier;
    static /* synthetic */ Class class$org$nakedobjects$object$NakedObjectStore;
    static /* synthetic */ Class class$org$nakedobjects$object$distribution$ServerConsole;
    static /* synthetic */ Class class$org$nakedobjects$object$distribution$Server;
    static /* synthetic */ Class class$org$nakedobjects$utility$Log;

    protected void configureSystemLogging() throws ConfigurationException {
        PropertyConfigurator.configure((Properties)ConfigurationParameters.getInstance().getProperties());
    }

    protected void init() throws ConfigurationException, ObjectStoreException {
        this.configureSystemLogging();
        this.displayCopyrightNotice();
        UpdateNotifier updateNotifier = (UpdateNotifier)this.loadComponent(UPDATE_NOTIFIER, class$org$nakedobjects$object$UpdateNotifier == null ? (class$org$nakedobjects$object$UpdateNotifier = ObjectServer.class$("org.nakedobjects.object.UpdateNotifier")) : class$org$nakedobjects$object$UpdateNotifier, null);
        NakedObjectStore nakedObjectStore = (NakedObjectStore)this.loadComponent(OBJECT_STORE, class$org$nakedobjects$object$NakedObjectStore == null ? (class$org$nakedobjects$object$NakedObjectStore = ObjectServer.class$("org.nakedobjects.object.NakedObjectStore")) : class$org$nakedobjects$object$NakedObjectStore, null);
        nakedObjectStore.init();
        AbstractNakedObject.init(nakedObjectStore);
        nakedObjectStore.setUpdateNotifier(updateNotifier);
        ServerConsole serverConsole = (ServerConsole)this.loadComponent(APPLICATION, class$org$nakedobjects$object$distribution$ServerConsole == null ? (class$org$nakedobjects$object$distribution$ServerConsole = ObjectServer.class$("org.nakedobjects.object.distribution.ServerConsole")) : class$org$nakedobjects$object$distribution$ServerConsole, null);
        Server server = (Server)this.loadComponent(SERVER, class$org$nakedobjects$object$distribution$Server == null ? (class$org$nakedobjects$object$distribution$Server = ObjectServer.class$("org.nakedobjects.object.distribution.Server")) : class$org$nakedobjects$object$distribution$Server, null);
        server.init(nakedObjectStore, serverConsole);
    }

    public static void loadConfiguration(String[] stringArray) throws ConfigurationException {
        String string;
        String string2 = string = stringArray.length > 0 ? stringArray[0] : DEFAULT_CONFIG;
        if (!new File(string).exists()) {
            System.out.println("No configuration file " + string + " found or loaded.");
            System.exit(1);
        }
        ConfigurationParameters.getInstance().load(string);
    }

    protected ServerConsole loadConsole() throws ConfigurationException {
        String string = ConfigurationParameters.getInstance().getString(APPLICATION);
        if (string == null) {
            throw new ConfigurationException("Configuration parameter nakedobjects.console must be set");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            if ((class$org$nakedobjects$object$distribution$ServerConsole == null ? (class$org$nakedobjects$object$distribution$ServerConsole = ObjectServer.class$("org.nakedobjects.object.distribution.ServerConsole")) : class$org$nakedobjects$object$distribution$ServerConsole).isAssignableFrom(clazz)) {
                return (ServerConsole)clazz.newInstance();
            }
            throw new ConfigurationException("The nakedobjects.console class " + string + " must be of the type ObjectStoreClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("Configuration parameter nakedobjects.console specifies the class " + string + ", which can not be found");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Could not instantiate an object of class " + clazz.getName() + "; " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Could not instantiate an object of class " + clazz.getName() + "; " + illegalAccessException.getMessage());
        }
    }

    protected NakedObjectStore loadObjectStore() throws ConfigurationException {
        String string = Application.setting(OBJECT_STORE);
        LOG.info((Object)("Object store using: " + string));
        try {
            Class<?> clazz = Class.forName(string);
            if ((class$org$nakedobjects$object$NakedObjectStore == null ? (class$org$nakedobjects$object$NakedObjectStore = ObjectServer.class$("org.nakedobjects.object.NakedObjectStore")) : class$org$nakedobjects$object$NakedObjectStore).isAssignableFrom(clazz)) {
                NakedObjectStore nakedObjectStore = (NakedObjectStore)clazz.newInstance();
                Log log = this.log();
                if (log != null) {
                    nakedObjectStore.setLog(log);
                }
                return nakedObjectStore;
            }
            throw new ConfigurationException();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Could not find the object store type " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException();
        }
    }

    protected Server loadServer() throws ConfigurationException {
        String string = ConfigurationParameters.getInstance().getString(SERVER);
        if (string == null) {
            throw new ConfigurationException("Configuration parameter nakedobjects.server must be set");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            if ((class$org$nakedobjects$object$distribution$Server == null ? (class$org$nakedobjects$object$distribution$Server = ObjectServer.class$("org.nakedobjects.object.distribution.Server")) : class$org$nakedobjects$object$distribution$Server).isAssignableFrom(clazz)) {
                return (Server)clazz.newInstance();
            }
            throw new ConfigurationException("The nakedobjects.server class " + string + " must be of the type ObjectStoreClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("Configuration parameter nakedobjects.server specifies the class " + string + ", which can not be found");
        }
        catch (InstantiationException instantiationException) {
            throw new ConfigurationException("Could not instantiate an object of class " + clazz.getName() + "; " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigurationException("Could not instantiate an object of class " + clazz.getName() + "; " + illegalAccessException.getMessage());
        }
        catch (Exception exception) {
            throw new ConfigurationException("Exception thrown when instantiating " + clazz.getName() + "; " + exception.getMessage());
        }
    }

    protected UpdateNotifier loadUpdateNotifier() throws ConfigurationException {
        String string = ConfigurationParameters.getInstance().getString(UPDATE_NOTIFIER);
        if (string == null) {
            throw new ConfigurationException("Configuration parameter nakedobjects.object-store.notifier must be set");
        }
        LOG.info((Object)("Object notification using: " + string));
        try {
            Class<?> clazz = Class.forName(string);
            if ((class$org$nakedobjects$object$UpdateNotifier == null ? (class$org$nakedobjects$object$UpdateNotifier = ObjectServer.class$("org.nakedobjects.object.UpdateNotifier")) : class$org$nakedobjects$object$UpdateNotifier).isAssignableFrom(clazz)) {
                return (UpdateNotifier)clazz.newInstance();
            }
            throw new ConfigurationException();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("Could not find the notifier type " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException();
        }
    }

    private Log log() throws ConfigurationException {
        String string = ConfigurationParameters.getInstance().getString(ACCESS_LOG);
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            if (!(class$org$nakedobjects$utility$Log == null ? (class$org$nakedobjects$utility$Log = ObjectServer.class$("org.nakedobjects.utility.Log")) : class$org$nakedobjects$utility$Log).isAssignableFrom(clazz)) {
                throw new RuntimeException("Log class not descended from Log");
            }
            return (Log)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ConfigurationException("Could not find the object store type " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("Could not find the object store type " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) {
        try {
            ObjectServer.loadConfiguration(stringArray);
            ObjectServer objectServer = new ObjectServer();
            objectServer.init();
        }
        catch (ConfigurationException configurationException) {
            LOG.error((Object)("Falied to start; configuration problem: " + configurationException.getMessage()));
            LOG.debug((Object)"Configuration problem", (Throwable)configurationException);
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)("Falied to start; object store problem: " + objectStoreException.getMessage()));
            LOG.debug((Object)"Object store problem", (Throwable)objectStoreException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

