/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.collection;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Category;
import org.nakedobjects.object.AbstractNakedObject;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectNotFoundException;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.collection.ArbitraryCollection;
import org.nakedobjects.object.control.Permission;
import org.nakedobjects.utility.ConfigurationParameters;
import org.nakedobjects.utility.NotImplementedException;

public abstract class AbstractNakedCollection
extends AbstractNakedObject
implements NakedCollection {
    static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$object$collection$AbstractNakedCollection == null ? (class$org$nakedobjects$object$collection$AbstractNakedCollection = AbstractNakedCollection.class$("org.nakedobjects.object.collection.AbstractNakedCollection")) : class$org$nakedobjects$object$collection$AbstractNakedCollection));
    private final int DEFAULT_PAGE_SIZE = 12;
    private final int DEFAULT_CACHE_SIZE = 79;
    private Vector cache;
    private int displayWithinCache = 0;
    private int displaySize;
    private int maxCacheSize;
    NakedObjectStore logicalCollection = this.getObjectStore();
    static /* synthetic */ Class class$org$nakedobjects$object$collection$AbstractNakedCollection;

    public AbstractNakedCollection() {
        this.reset();
    }

    public void setDisplaySize(int n) {
        if (n <= 1) {
            throw new IllegalArgumentException("Display size must be 1 or greater");
        }
        this.displaySize = n;
        if (this.isPersistent()) {
            this.setMaxCacheSize(Math.max(this.maxCacheSize, n));
        }
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void setMaxCacheSize(int n) {
        if (!this.isPersistent()) {
            throw new RuntimeException("Collection exception; the cache size cannot be set for a non persistent collection");
        }
        if (n <= this.displaySize) {
            throw new IllegalArgumentException("Cache size must be greater than the display size");
        }
        this.cache = null;
        this.displayWithinCache = 0;
        this.maxCacheSize = n;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void add(NakedObject nakedObject) {
        if (this.canAdd(nakedObject).isAllowed()) {
            if (this.isPersistent()) {
                try {
                    this.logicalCollection.addElement(this, nakedObject);
                    if (this.cache != null) {
                        if (this.cache.size() == this.maxCacheSize) {
                            this.cache.remove(0);
                        }
                        this.cache.addElement(nakedObject);
                    }
                }
                catch (ObjectStoreException objectStoreException) {
                    LOG.error((Object)"Failed to add element to collection", (Throwable)objectStoreException);
                }
            } else {
                if (this.cache == null) {
                    this.cache = new Vector();
                }
                this.cache.addElement(nakedObject);
                this.maxCacheSize = Math.max(this.maxCacheSize, this.cache.size());
                this.objectChanged();
            }
        }
    }

    public void added(NakedObject nakedObject) {
        if (this.cache != null) {
            if (this.cache.size() == this.maxCacheSize) {
                this.cache.remove(0);
            }
            this.cache.addElement(nakedObject);
        }
    }

    public abstract Permission canAdd(NakedObject var1);

    public abstract Permission canRemove(NakedObject var1);

    public boolean contains(NakedObject nakedObject) {
        if (this.isPersistent()) {
            if (this.cache != null && this.cache.size() == this.maxCacheSize) {
                return this.cache.contains(nakedObject);
            }
            try {
                return this.logicalCollection.containsElement(this, nakedObject);
            }
            catch (ObjectStoreException objectStoreException) {
                LOG.error((Object)"Failed to check for element", (Throwable)objectStoreException);
                return false;
            }
        }
        return this.cache != null && this.cache.contains(nakedObject);
    }

    public Enumeration displayElements() {
        this.checkCache();
        Vector<NakedObject> vector = new Vector<NakedObject>(this.displaySize);
        int n = Math.min(this.displayWithinCache + this.displaySize, this.cache.size());
        int n2 = this.displayWithinCache;
        while (n2 < n) {
            NakedObject nakedObject = (NakedObject)this.cache.elementAt(n2);
            nakedObject.resolve();
            vector.addElement(nakedObject);
            ++n2;
        }
        return vector.elements();
    }

    public Enumeration elements() {
        if (this.isPersistent()) {
            return new CollectionEnumeration();
        }
        if (this.cache == null) {
            this.cache = new Vector();
        }
        return this.cache.elements();
    }

    public ArbitraryCollection extract() {
        ArbitraryCollection arbitraryCollection = new ArbitraryCollection();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            arbitraryCollection.add((NakedObject)enumeration.nextElement());
        }
        return arbitraryCollection;
    }

    public void first() {
        if (this.isPersistent()) {
            if (this.cache == null || this.cache.size() == this.maxCacheSize) {
                try {
                    this.cache = this.nextElements(null, this.maxCacheSize);
                }
                catch (ObjectStoreException objectStoreException) {
                    LOG.error((Object)("Failed to get first, " + objectStoreException));
                    throw new RuntimeException();
                }
            }
        } else if (this.cache == null) {
            this.cache = new Vector();
        }
        this.displayWithinCache = 0;
    }

    public boolean hasNext() {
        this.checkCache();
        if (this.isPersistent() && this.cache.size() == this.maxCacheSize) {
            if (this.displayWithinCache + this.displaySize < this.cache.size()) {
                return true;
            }
            try {
                return !this.isLastElement((NakedObject)this.cache.lastElement());
            }
            catch (ObjectStoreException objectStoreException) {
                throw new RuntimeException(objectStoreException.getMessage());
            }
        }
        return this.displayWithinCache + this.displaySize < this.cache.size();
    }

    public boolean hasPrevious() {
        this.checkCache();
        if (this.isPersistent() && this.cache.size() == this.maxCacheSize) {
            if (this.displayWithinCache > 0) {
                return true;
            }
            try {
                return !this.isFirstElement((NakedObject)this.cache.elementAt(0));
            }
            catch (ObjectStoreException objectStoreException) {
                return false;
            }
        }
        return this.displayWithinCache > 0;
    }

    public void last() {
        if (this.isPersistent()) {
            if (this.cache == null || this.cache.size() == this.maxCacheSize) {
                try {
                    this.cache = this.previousElements(null, this.maxCacheSize);
                }
                catch (ObjectStoreException objectStoreException) {
                    LOG.error((Object)"Failed to get last");
                }
            }
        } else if (this.cache == null) {
            this.cache = new Vector();
        }
        this.displayWithinCache = this.cache.size() - this.displaySize;
        this.displayWithinCache = Math.max(0, this.displayWithinCache);
    }

    public void next() {
        this.checkCache();
        if (this.displayWithinCache + this.displaySize + this.displaySize > this.cache.size()) {
            if (this.isPersistent() && this.cache.size() == this.maxCacheSize) {
                try {
                    NakedObject nakedObject = (NakedObject)this.cache.lastElement();
                    Vector vector = this.nextElements(nakedObject, this.displayWithinCache);
                    int n = vector.size();
                    int n2 = 0;
                    while (n2 < n) {
                        this.cache.remove(0);
                        this.cache.addElement(vector.elementAt(n2));
                        ++n2;
                    }
                    this.displayWithinCache = this.displayWithinCache - n + this.displaySize;
                    if (this.displayWithinCache + this.displaySize > this.cache.size()) {
                        this.displayWithinCache = this.cache.size() - this.displaySize;
                        this.displayWithinCache = Math.max(0, this.displayWithinCache);
                    }
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    this.displayWithinCache += this.displaySize;
                    if (this.displayWithinCache + this.displaySize > this.cache.size()) {
                        this.displayWithinCache = this.cache.size() - this.displaySize;
                        this.displayWithinCache = Math.max(0, this.displayWithinCache);
                    }
                }
                catch (ObjectStoreException objectStoreException) {
                    LOG.error((Object)"Failed to get next cache block", (Throwable)objectStoreException);
                }
            } else {
                this.displayWithinCache = Math.max(0, this.cache.size() - this.displaySize);
            }
        } else {
            this.displayWithinCache += this.displaySize;
        }
    }

    public void previous() {
        if (this.displayWithinCache - this.displaySize < 0) {
            if (this.isPersistent() && this.cache.size() == this.maxCacheSize) {
                try {
                    NakedObject nakedObject = (NakedObject)this.cache.firstElement();
                    int n = this.cache.size();
                    int n2 = n - this.displayWithinCache;
                    Vector vector = this.previousElements(nakedObject, n2);
                    int n3 = vector.size();
                    int n4 = 0;
                    while (n4 < n - n3) {
                        vector.addElement(this.cache.elementAt(n4));
                        ++n4;
                    }
                    this.cache = vector;
                    this.displayWithinCache = this.displayWithinCache + n3 - this.displaySize;
                    if (this.displayWithinCache < 0) {
                        this.displayWithinCache = 0;
                    }
                }
                catch (ObjectStoreException objectStoreException) {
                    LOG.error((Object)"Failed to get next cache block", (Throwable)objectStoreException);
                }
            } else {
                this.displayWithinCache = 0;
            }
        } else {
            this.displayWithinCache -= this.displaySize;
        }
    }

    public void remove(NakedObject nakedObject) {
        block7: {
            if (this.canRemove(nakedObject).isAllowed()) {
                if (this.isPersistent()) {
                    try {
                        this.logicalCollection.removeElement(this, nakedObject);
                        if (this.cache == null) break block7;
                        if (this.cache.size() == this.maxCacheSize) {
                            this.cache.removeElement(nakedObject);
                            Vector vector = this.nextElements((NakedObject)this.cache.lastElement(), 1);
                            if (vector.size() == 1) {
                                this.cache.addElement(vector.firstElement());
                            }
                            break block7;
                        }
                        this.cache.removeElement(nakedObject);
                    }
                    catch (ObjectStoreException objectStoreException) {
                        LOG.error((Object)"Failed to remove object", (Throwable)objectStoreException);
                    }
                } else {
                    this.cache.remove(nakedObject);
                    this.objectChanged();
                }
            }
        }
    }

    public void removed(NakedObject nakedObject) {
        try {
            if (this.cache != null) {
                if (this.cache.size() == this.maxCacheSize) {
                    this.cache.removeElement(nakedObject);
                    Vector vector = this.nextElements((NakedObject)this.cache.lastElement(), 1);
                    if (vector.size() == 1) {
                        this.cache.addElement(vector.firstElement());
                    }
                } else {
                    this.cache.removeElement(nakedObject);
                }
            }
        }
        catch (ObjectStoreException objectStoreException) {
            throw new RuntimeException(objectStoreException.getMessage());
        }
    }

    public void reset() {
        this.cache = null;
        this.displayWithinCache = 0;
        ConfigurationParameters configurationParameters = ConfigurationParameters.getInstance();
        this.maxCacheSize = configurationParameters.getInteger("nakedobjects.collection.cachesize", 79);
        this.displaySize = configurationParameters.getInteger("nakedobjects.collection.pagesize", 12);
    }

    public AbstractNakedCollection search(NakedObject nakedObject) {
        throw new NotImplementedException();
    }

    public int size() {
        if (this.isPersistent()) {
            if (this.cache == null || this.cache.size() == this.maxCacheSize) {
                try {
                    return this.numberOfElements();
                }
                catch (ObjectStoreException objectStoreException) {
                    LOG.error((Object)"Failed to find size", (Throwable)objectStoreException);
                    return 0;
                }
            }
            return this.cache.size();
        }
        if (this.cache == null) {
            return 0;
        }
        return this.cache.size();
    }

    boolean isFirstElement(NakedObject nakedObject) throws ObjectStoreException {
        return this.logicalCollection.isFirstElement(this, nakedObject);
    }

    boolean isLastElement(NakedObject nakedObject) throws ObjectStoreException {
        return this.logicalCollection.isLastElement(this, nakedObject);
    }

    int getStartWindowAt() {
        return this.displayWithinCache;
    }

    Vector nextElements(NakedObject nakedObject, int n) throws ObjectStoreException {
        return this.logicalCollection.getNextElements(this, nakedObject, n);
    }

    int numberOfElements() throws ObjectStoreException {
        return this.logicalCollection.numberOfElements(this);
    }

    Vector previousElements(NakedObject nakedObject, int n) throws ObjectStoreException {
        return this.logicalCollection.getPreviousElements(this, nakedObject, n);
    }

    private void checkCache() {
        if (this.cache == null) {
            throw new RuntimeException("CollectionException - not initialized");
        }
    }

    public Title title() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CollectionEnumeration
    implements Enumeration {
        int count;

        public CollectionEnumeration() {
            AbstractNakedCollection.this.first();
            this.count = 0;
        }

        public boolean hasMoreElements() {
            if (AbstractNakedCollection.this.cache == null || AbstractNakedCollection.this.cache.size() == 0) {
                return false;
            }
            if (this.count < AbstractNakedCollection.this.cache.size()) {
                return true;
            }
            if (AbstractNakedCollection.this.cache.size() != AbstractNakedCollection.this.maxCacheSize) {
                return false;
            }
            NakedObject nakedObject = (NakedObject)AbstractNakedCollection.this.cache.lastElement();
            try {
                Vector vector = AbstractNakedCollection.this.nextElements(nakedObject, AbstractNakedCollection.this.maxCacheSize);
                int n = vector.size();
                if (n == AbstractNakedCollection.this.maxCacheSize) {
                    AbstractNakedCollection.this.cache = vector;
                    this.count = 0;
                    return true;
                }
                if (n == 0) {
                    return false;
                }
                int n2 = 0;
                while (n2 < n) {
                    AbstractNakedCollection.this.cache.remove(0);
                    AbstractNakedCollection.this.cache.addElement(vector.elementAt(n2));
                    ++n2;
                }
                this.count = AbstractNakedCollection.this.maxCacheSize - n;
                return true;
            }
            catch (ObjectStoreException objectStoreException) {
                return false;
            }
        }

        public Object nextElement() {
            return AbstractNakedCollection.this.cache.elementAt(this.count++);
        }
    }
}

