/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import junit.framework.Assert;
import org.nakedobjects.object.distribution.ProxyRequester;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.Server;

class MockRemoteConnection
implements ProxyRequester {
    Server server;

    public MockRemoteConnection(Server server) {
        this.server = server;
    }

    public void init() {
    }

    public Serializable send(Request request) {
        try {
            Request request2 = (Request)this.transmit(request);
            Serializable serializable = this.serverReceive(request2);
            return (Serializable)this.transmit(serializable);
        }
        catch (IOException iOException) {
            Assert.fail((String)("send failed " + iOException));
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail((String)("send failed " + classNotFoundException));
            return null;
        }
    }

    private Serializable serverReceive(Request request) {
        request.generateResponse(this.server);
        return request.response;
    }

    public void shutdown() {
    }

    private Object transmit(Object object) throws IOException, ClassNotFoundException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new PipedOutputStream(pipedInputStream));
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        ObjectInputStream objectInputStream = new ObjectInputStream(pipedInputStream);
        Object object2 = objectInputStream.readObject();
        objectInputStream.close();
        pipedInputStream.close();
        return object2;
    }
}

