open IN, "inputs.txt";
open OUT, ">outputs.txt";

#In perl, the first command line argument is $ARGV[0].
$long = $ARGV[0];  
#Usually 26
$longPercent = 2/($long+1);

$short = $ARGV[1];  
#Usually 12
$shortPercent = 2/($short+1);

$averaging = $ARGV[2];  
#Usually 9
$averagingPercent = 2/($averaging+1);

$shortMavg = 0;
$longMavg = 0;
$averageMavg = 0;

while (defined($line=<IN>)) {
    chomp $line;
    $closing = $line;
#Calculate long and short exponential moving averages.
    $shortMavg = $shortPercent*$closing + (1-$shortPercent)*$shortMavg;
    $longMavg = $longPercent*$closing + (1-$longPercent)*$longMavg;
#MACD is short average minus long average.
    $macd = $shortMavg - $longMavg;
#Signal line is exponential moving average of MACD.    
    $averageMavg = $averagingPercent*$macd + (1-$averagingPercent)*$averageMavg;
    print OUT "$macd $averageMavg\n";
    }
close OUT;
close IN;
open DONE, ">done.txt";
print "Done\n";
close DONE;