/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.PList;
import Sav.Processor.PromptAssociation;
import Sav.Z.Commutator;
import Sav.Z.DBHash;
import Sav.Z.DataBase;
import Sav.Z.Error;
import Sav.Z.Failure;
import Sav.Z.Lexis;
import Sav.Z.LineStatus;
import Sav.Z.MulHash;
import Sav.Z.Printer;
import Sav.Z.Script;
import Sav.Z.Statement;
import Sav.Z.Status;
import Sav.Z.WPrinter;
import Sav.Z.Warning;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;

public class Session
implements Lexis {
    static final Hashtable hTypes = new Hashtable();
    static final String[] types = new String[10];
    Commutator comm = new Commutator();
    PromptAssociation spec;
    MulHash mh;
    LineStatus stLine;
    LineStatus stDataLine;
    Status stProcess;
    Status stDataBase;
    Printer prtMessage;
    Printer prtReport;
    StringWriter sw;
    Statement curStm;
    PList errList;
    PList failList;
    DataBase db;
    DBHash dbh = new DBHash();
    boolean scr_modify;
    Concept cUser;
    Concept cPassword;
    Concept cService;
    int access;
    String rootPath;
    Object context;
    boolean hideScriptStatus;

    public Session(String string) throws IOException {
        this();
        File file = Session.correctFile(new File(string));
        if (!file.exists()) {
            throw new IOException(String.valueOf(String.valueOf(file.toString())).concat(" - is not found"));
        }
        this.rootPath = file.getAbsolutePath();
    }

    public String rootPath() {
        return this.rootPath;
    }

    public Session() {
        this.db = this.dbh.openNew();
        try {
            this.initSpec();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mh = new MulHash();
        this.errList = new PList();
        this.failList = new PList();
        this.sw = new StringWriter();
        this.prtReport = new WPrinter(new PrintWriter(this.sw));
        this.cUser = new Concept("\"\"");
        this.cPassword = new Concept("\"\"");
        this.cService = new Concept("\"\"");
        File file = new File(".");
        this.rootPath = file.getAbsolutePath();
    }

    public void initSpec() throws IOException {
        if (this.mh != null) {
            this.mh.clear();
        }
        this.spec = new PromptAssociation();
        try {
            Concept concept = new Concept(4);
            this.spec.con(61);
            this.spec.con("print");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("p");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printObject");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("po");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printLine");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pl");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printClass");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pc");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printRelation");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pr");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printEquality");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pe");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printTable");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pt");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printTableRow");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("ptr");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("readTable");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("rt");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("login");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("l");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printXmlKnowledge");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pxk");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pk");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printXmlDocument");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pxd");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pd");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("readXmlKnowledge");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("rxk");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("rk");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("readXmlDocument");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("rxd");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("rd");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.regain();
            this.spec.con(57);
            this.spec.con(concept).con(57);
            this.spec.set("print");
            this.spec.set("p");
            this.spec.set("printObject");
            this.spec.set("po");
            this.spec.set("printLine");
            this.spec.set("pl");
            this.spec.set("printClass");
            this.spec.set("pc");
            this.spec.set("printRelation");
            this.spec.set("pr");
            this.spec.set("printEquality");
            this.spec.set("pe");
            this.spec.set("printTable");
            this.spec.set("pt");
            this.spec.set("printTableRow");
            this.spec.set("ptr");
            this.spec.set("readTable");
            this.spec.set("rt");
            this.spec.set("login");
            this.spec.set("l");
            this.spec.set("printXmlKnowledge");
            this.spec.set("pxk");
            this.spec.set("pk");
            this.spec.set("readXmlKnowledge");
            this.spec.set("rxk");
            this.spec.set("rk");
            this.spec.set("printXmlDocument");
            this.spec.set("pxd");
            this.spec.set("pd");
            this.spec.set("readXmlDocument");
            this.spec.set("rxd");
            this.spec.set("rd");
            this.spec.regain();
            concept = new Concept(5);
            this.spec.con(61);
            this.spec.con("Content");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("Attribute");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("WebPage");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("User");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("Password");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("Service");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("Group");
            this.spec.setConnect(61, concept);
            this.spec.regain();
            this.spec.con(57);
            this.spec.con(concept).con(57);
            this.spec.set("Content");
            this.spec.set("Attribute");
            this.spec.set("WebPage");
            this.spec.set("User");
            this.spec.set("Password");
            this.spec.set("Service");
            this.spec.set("Group");
            this.spec.regain();
            this.spec.store();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public synchronized boolean z(String string) {
        Script script = new Script(string);
        script.execute(this);
        return !script.hasWarnings();
    }

    public synchronized void analyse(Script script) {
        script.analyse(this);
    }

    public synchronized void execute(Script script) {
        script.execute(this);
    }

    public String report() {
        String string = this.sw.toString();
        if (string.length() != 0) {
            StringBuffer stringBuffer = this.sw.getBuffer();
            stringBuffer.setLength(0);
        }
        return string;
    }

    public Warning[] warnings() {
        int n2;
        int n3 = this.countWarnings();
        Warning[] warningArray = new Warning[n3];
        Error[] errorArray = this.errors();
        int n4 = errorArray.length;
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            warningArray[n5++] = errorArray[n2];
        }
        Failure[] failureArray = this.failures();
        n4 = failureArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            warningArray[n5++] = failureArray[n2];
        }
        return warningArray;
    }

    public Error[] errors() {
        int n2 = this.errList.size();
        Error[] errorArray = new Error[n2];
        Error error = (Error)this.errList.getFirst();
        for (int i2 = 0; i2 < n2; ++i2) {
            errorArray[i2] = error;
            error = (Error)this.errList.getNext();
        }
        return errorArray;
    }

    public Failure[] failures() {
        int n2 = this.failList.size();
        Failure[] failureArray = new Failure[n2];
        Failure failure = (Failure)this.failList.getFirst();
        for (int i2 = 0; i2 < n2; ++i2) {
            failureArray[i2] = failure;
            failure = (Failure)this.failList.getNext();
        }
        return failureArray;
    }

    public boolean hasWarnings() {
        return this.hasErrors() || this.hasFailures();
    }

    public boolean hasErrors() {
        return !this.errList.isEmpty();
    }

    public boolean hasFailures() {
        return !this.failList.isEmpty();
    }

    public int countWarnings() {
        return this.countErrors() + this.countFailures();
    }

    public int countErrors() {
        return this.errList.size();
    }

    public int countFailures() {
        return this.failList.size();
    }

    public void clearWarnings() {
        this.errList = new PList();
        this.failList = new PList();
    }

    public void clearErrors() {
        this.errList = new PList();
    }

    public void clearFailures() {
        this.failList = new PList();
    }

    public void set(String string, String string2) throws IOException {
        this.mh.set(string, string2);
    }

    public void set(String string, String[] stringArray) throws IOException {
        this.mh.set(string, stringArray);
    }

    public String[] get(String string) throws IOException {
        return this.mh.get(string);
    }

    public void clear(String string) throws IOException {
        this.mh.clear(string);
    }

    public int size(String string) throws IOException {
        return this.mh.size(string);
    }

    public Association association(String string) throws IOException {
        return (Association)this.mh.h.get(string);
    }

    public Statement curStatement() {
        return this.curStm;
    }

    public void modifyBase(String string) throws IOException {
        this.openModify(string);
        this.db.external = true;
    }

    public void modifyBase() throws IOException {
        this.openModify("");
        this.db.external = true;
    }

    public void useBase(String string) throws IOException {
        this.openUse(string);
        this.db.external = true;
    }

    public void useBase() throws IOException {
        this.openUse("");
        this.db.external = true;
    }

    public void closeBase(String string) throws IOException {
        if (string.length() == 0) {
            string = this.db.getPath();
        }
        this.dbh.close(this.rootPath, string);
    }

    public void closeBase() throws IOException {
        String string = this.db.getPath();
        this.dbh.close(this.rootPath, string);
    }

    public void closeBases() throws IOException {
        this.dbh.close();
    }

    void openUse(String string) throws IOException {
        if (string.length() == 0) {
            string = this.db.getPath();
            this.db.openUse();
        } else {
            this.access = 0;
            this.db = this.dbh.openUse(this.rootPath, string);
        }
        this.db.needRenew = false;
        if (this.stDataBase != null) {
            this.stDataBase.set(string);
        }
    }

    void openModify(String string) throws IOException {
        if (string.length() == 0) {
            string = this.db.getPath();
            this.db.openModify();
        } else {
            this.access = 0;
            this.db = this.dbh.openModify(this.rootPath, string);
        }
        this.db.needRenew = false;
        if (this.stDataBase != null) {
            this.stDataBase.set(string);
        }
    }

    void openNew(String string) throws IOException {
        this.openModify(string);
        if (this.access == 0 && this.db.hasUsers()) {
            this.db.needRenew = true;
        } else {
            this.db.needRenew = false;
            this.db.openNew();
        }
    }

    public void setReportPrinter(Printer printer) {
        this.prtReport = printer;
    }

    public Printer getReportPrinter() {
        return this.prtReport;
    }

    public void clearReportPrinter() {
        this.sw = new StringWriter();
        this.prtReport = new WPrinter(new PrintWriter(this.sw));
    }

    public void setMessagePrinter(Printer printer) {
        this.prtMessage = printer;
    }

    public Printer getMessagePrinter() {
        return this.prtMessage;
    }

    public void clearMessagePrinter() {
        this.prtMessage = null;
    }

    public void setProcessStatus(Status status) {
        this.stProcess = status;
    }

    public Status getProcessStatus() {
        return this.stProcess;
    }

    public void clearProcessStatus() {
        this.stProcess = null;
    }

    public void setScriptLineStatus(LineStatus lineStatus) {
        this.stLine = lineStatus;
    }

    public LineStatus getScriptLineStatus() {
        return this.stLine;
    }

    public void clearScriptLineStatus() {
        this.stLine = null;
    }

    public void setDataLineStatus(LineStatus lineStatus) {
        this.stDataLine = lineStatus;
    }

    public LineStatus getDataLineStatus() {
        return this.stDataLine;
    }

    public void clearDataLineStatus() {
        this.stDataLine = null;
    }

    public void setDataBaseStatus(Status status) {
        this.stDataBase = status;
        status.set(this.db.getPath());
    }

    public Status getDataBaseStatus() {
        return this.stDataBase;
    }

    public void clearDataBaseStatus() {
        this.stDataBase = null;
    }

    void setProcess(String string) {
        if (this.stProcess != null) {
            this.stProcess.set(string);
        }
    }

    String getProcess() {
        if (this.stProcess != null) {
            return this.stProcess.get();
        }
        return null;
    }

    void clearProcess() {
        if (this.stProcess != null) {
            this.stProcess.clear();
        }
    }

    void setScriptLine(String string) {
        if (this.stLine != null) {
            this.stLine.set(string);
        }
    }

    public void setScriptLine(int n2) {
        if (this.stLine != null) {
            this.stLine.set(n2);
        }
    }

    public int getScriptLine() {
        if (this.stLine != null) {
            return this.stLine.getNumber();
        }
        return 0;
    }

    public void clearScriptLine() {
        if (this.stLine != null) {
            this.stLine.clear();
        }
    }

    void setDataLine(String string) {
        if (this.stDataLine != null) {
            this.stDataLine.set(string);
        }
    }

    void setDataLine(int n2) {
        if (this.stDataLine != null) {
            this.stDataLine.set(n2);
        }
    }

    String getDataLine() {
        if (this.stDataLine != null) {
            return this.stDataLine.get();
        }
        return null;
    }

    void clearDataLine() {
        if (this.stDataLine != null) {
            this.stDataLine.clear();
        }
    }

    void printMessage(String string) {
        if (this.prtMessage != null) {
            this.prtMessage.println(string);
        }
    }

    void flushMessage() {
        if (this.prtMessage != null) {
            this.prtMessage.flush();
        }
    }

    void flushReport() {
        if (this.prtReport != null) {
            this.prtReport.flush();
        }
    }

    public void setCommutator(Commutator commutator) {
        this.comm = commutator;
    }

    public Commutator getCommutator() {
        return this.comm;
    }

    public Association base() {
        return this.db.base;
    }

    public String database() {
        return this.db.getPath();
    }

    public String service() {
        String string = this.cService.toString();
        return string.substring(1, string.length() - 1);
    }

    public String password() {
        String string = this.cPassword.toString();
        return string.substring(1, string.length() - 1);
    }

    public String user() {
        String string = this.cUser.toString();
        return string.substring(1, string.length() - 1);
    }

    public void close() throws IOException {
        this.dbh.close();
        if (this.hasErrors()) {
            this.restoreSpec();
        } else {
            this.storeSpec();
        }
        this.clearWarnings();
        this.curStm = null;
        this.clearScriptLine();
        this.clearDataLine();
    }

    void storeSpec() throws IOException {
        this.spec.store();
        this.mh.store();
    }

    void restoreSpec() throws IOException {
        this.spec.restore();
        this.mh.restore(this.spec);
    }

    protected void finalize() throws IOException {
        this.dbh.close();
        this.mh.clear();
        this.clearWarnings();
        this.curStm = null;
        this.clearScriptLine();
        this.clearDataLine();
        this.flushMessage();
        this.flushReport();
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public Object getContext() {
        return this.context;
    }

    public int accessRight() {
        return this.access;
    }

    public void login(String string, String string2, String string3) throws IOException {
        this.cService = new Concept(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(string).append('\"'))));
        this.cPassword = new Concept(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(string2).append('\"'))));
        this.cUser = new Concept(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(string3).append('\"'))));
        this.access = this.db.login(this.cService, this.cPassword, this.cUser);
    }

    public void login(String string, String string2) throws IOException {
        this.cService = new Concept(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(string).append('\"'))));
        this.cPassword = new Concept(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(string2).append('\"'))));
        this.access = this.db.login(this.cService, this.cPassword, this.cUser);
    }

    public void login(String string) throws IOException {
        this.cService = new Concept(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(string).append('\"'))));
        this.access = this.db.login(this.cService, this.cPassword, this.cUser);
    }

    public void login() throws IOException {
        this.access = this.db.login(this.cService, this.cPassword, this.cUser);
    }

    File absoluteFile(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        String string = file.getPath();
        return new File(this.rootPath, string);
    }

    static File correctFile(File file) {
        char c2 = File.separatorChar;
        String string = file.getPath();
        int n2 = c2 == '/' ? string.lastIndexOf(92) : string.lastIndexOf(47);
        if (n2 >= 0) {
            string = c2 == '/' ? string.replace('\\', c2) : string.replace('/', c2);
            file = new File(string);
        }
        return file;
    }

    public void hideScriptStatus(boolean bl2) {
        this.hideScriptStatus = bl2;
    }

    boolean hideScriptStatus() {
        return this.hideScriptStatus;
    }

    public boolean isModifiable() {
        return this.db.isModifiable();
    }

    static {
        Session.types[1] = "base";
        Session.types[2] = "file";
        Session.types[3] = "mul";
        Session.types[4] = "proc";
        Session.types[5] = "cat";
        hTypes.put("base", new Integer(-1));
        hTypes.put("file", new Integer(-2));
        hTypes.put("mul", new Integer(-3));
        hTypes.put("proc", new Integer(-4));
        hTypes.put("cat", new Integer(-5));
    }
}

