/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.servlets;

import com.lowagie.servlets.BufferedResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public abstract class OutputFilterBase
implements Filter {
    private static final String FILTER_APPLIED = "OUTPUTFILTER_APPLIED";
    public static final String PREVENT_FILTER = "OUTPUTFILTER_PREVENT";
    public static final String EXCEPTION_KEY = "OUTPUTFILTER_PREVENT";
    protected FilterConfig fConfig;

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute(FILTER_APPLIED) == null) {
            servletRequest.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
            ServletRequest servletRequest2 = this.prepareRequest(servletRequest);
            BufferedResponse bufferedResponse = this.prepareResponse(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest2, (ServletResponse)bufferedResponse);
            if (!bufferedResponse.isCommitted() && bufferedResponse.isModified()) {
                if (servletRequest2.getAttribute("OUTPUTFILTER_PREVENT") == null) {
                    try {
                        this.perform(servletRequest, servletResponse, bufferedResponse.getData());
                    }
                    catch (Exception exception) {
                        this.sendError(servletRequest, (HttpServletResponse)servletResponse, exception);
                    }
                } else {
                    this.dump(bufferedResponse, servletResponse);
                }
            }
        }
    }

    protected ServletRequest prepareRequest(ServletRequest servletRequest) {
        return servletRequest;
    }

    protected BufferedResponse prepareResponse(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        return new BufferedResponse((HttpServletResponse)servletResponse);
    }

    protected abstract void perform(ServletRequest var1, ServletResponse var2, InputStream var3) throws Exception;

    protected void dump(BufferedResponse bufferedResponse, ServletResponse servletResponse) throws IOException {
        servletResponse.setContentType(bufferedResponse.getDeclaredContentType());
        if (bufferedResponse.getDeclaredLength() > 0) {
            servletResponse.setContentLength(bufferedResponse.getDeclaredLength());
        }
        this.dump(bufferedResponse.getData(), servletResponse);
    }

    protected void dump(InputStream inputStream, ServletResponse servletResponse) throws IOException {
        int n2;
        ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
        while ((n2 = inputStream.read()) != -1) {
            servletOutputStream.write(n2);
        }
    }

    protected void sendError(ServletRequest servletRequest, HttpServletResponse httpServletResponse, Throwable throwable) throws IOException {
        servletRequest.setAttribute("OUTPUTFILTER_PREVENT", (Object)throwable);
        httpServletResponse.sendError(500, throwable.getMessage());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.fConfig = filterConfig;
    }

    public void destroy() {
        this.fConfig = null;
    }

    public FilterConfig getFilterConfig() {
        return this.fConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.fConfig = filterConfig;
    }
}

