/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkupAttributes;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Row
implements Element,
MarkupAttributes {
    public static final int NULL = 0;
    public static final int CELL = 1;
    public static final int TABLE = 2;
    protected int columns;
    protected int currentColumn;
    protected boolean[] reserved;
    protected Object[] cells;
    protected int horizontalAlignment;
    protected int verticalAlignment;
    protected Properties markupAttributes;
    static /* synthetic */ Class class$com$lowagie$text$Cell;
    static /* synthetic */ Class class$com$lowagie$text$Table;

    protected Row(int n2) {
        this.columns = n2;
        this.reserved = new boolean[n2];
        this.cells = new Object[n2];
        this.currentColumn = 0;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 21;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    void deleteColumn(int n2) {
        if (n2 >= this.columns || n2 < 0) {
            throw new IndexOutOfBoundsException("getCell at illegal index : " + n2);
        }
        --this.columns;
        boolean[] blArray = new boolean[this.columns];
        Cell[] cellArray = new Cell[this.columns];
        int n3 = 0;
        while (n3 < n2) {
            blArray[n3] = this.reserved[n3];
            cellArray[n3] = this.cells[n3];
            if (cellArray[n3] != null && n3 + cellArray[n3].colspan() > n2) {
                cellArray[n3].setColspan(((Cell)this.cells[n3]).colspan() - 1);
            }
            ++n3;
        }
        int n4 = n2;
        while (n4 < this.columns) {
            blArray[n4] = this.reserved[n4 + 1];
            cellArray[n4] = this.cells[n4 + 1];
            ++n4;
        }
        if (this.cells[n2] != null && ((Cell)this.cells[n2]).colspan() > 1) {
            cellArray[n2] = this.cells[n2];
            cellArray[n2].setColspan(cellArray[n2].colspan() - 1);
        }
        this.reserved = blArray;
        this.cells = cellArray;
    }

    int addElement(Object object) {
        return this.addElement(object, this.currentColumn);
    }

    int addElement(Object object, int n2) {
        int n3;
        if (object == null) {
            throw new NullPointerException("addCell - null argument");
        }
        if (n2 < 0 || n2 > this.columns) {
            throw new IndexOutOfBoundsException("addCell - illegal column argument");
        }
        if (this.getObjectID(object) != 1 && this.getObjectID(object) != 2) {
            throw new IllegalArgumentException("addCell - only Cells or Tables allowed");
        }
        int n4 = n3 = (class$com$lowagie$text$Cell == null ? (class$com$lowagie$text$Cell = Row.class$("com.lowagie.text.Cell")) : class$com$lowagie$text$Cell).isInstance(object) ? ((Cell)object).colspan() : 1;
        if (!this.reserve(n2, n3)) {
            return -1;
        }
        this.cells[n2] = object;
        this.currentColumn += n3 - 1;
        return n2;
    }

    void setElement(Object object, int n2) {
        if (this.reserved[n2]) {
            throw new IllegalArgumentException("setElement - position already taken");
        }
        this.cells[n2] = object;
        if (object != null) {
            this.reserved[n2] = true;
        }
    }

    boolean reserve(int n2) {
        return this.reserve(n2, 1);
    }

    boolean reserve(int n2, int n3) {
        if (n2 < 0 || n2 + n3 > this.columns) {
            throw new IndexOutOfBoundsException("reserve - incorrect column/size");
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            if (this.reserved[n4]) {
                int n5 = n4;
                while (n5 >= n2) {
                    this.reserved[n4] = false;
                    --n5;
                }
                return false;
            }
            this.reserved[n4] = true;
            ++n4;
        }
        return true;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    public void setVerticalAlignment(int n2) {
        this.verticalAlignment = n2;
    }

    boolean isReserved(int n2) {
        return this.reserved[n2];
    }

    int getElementID(int n2) {
        if (this.cells[n2] == null) {
            return 0;
        }
        if ((class$com$lowagie$text$Cell == null ? (class$com$lowagie$text$Cell = Row.class$("com.lowagie.text.Cell")) : class$com$lowagie$text$Cell).isInstance(this.cells[n2])) {
            return 1;
        }
        if ((class$com$lowagie$text$Table == null ? (class$com$lowagie$text$Table = Row.class$("com.lowagie.text.Table")) : class$com$lowagie$text$Table).isInstance(this.cells[n2])) {
            return 2;
        }
        return -1;
    }

    int getObjectID(Object object) {
        if (object == null) {
            return 0;
        }
        if ((class$com$lowagie$text$Cell == null ? (class$com$lowagie$text$Cell = Row.class$("com.lowagie.text.Cell")) : class$com$lowagie$text$Cell).isInstance(object)) {
            return 1;
        }
        if ((class$com$lowagie$text$Table == null ? (class$com$lowagie$text$Table = Row.class$("com.lowagie.text.Table")) : class$com$lowagie$text$Table).isInstance(object)) {
            return 2;
        }
        return -1;
    }

    public Object getCell(int n2) {
        if (n2 < 0 || n2 > this.columns) {
            throw new IndexOutOfBoundsException("getCell at illegal index :" + n2 + " max is " + this.columns);
        }
        return this.cells[n2];
    }

    public boolean isEmpty() {
        int n2 = 0;
        while (n2 < this.columns) {
            if (this.cells[n2] != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    int validPosition() {
        return this.currentColumn;
    }

    public int columns() {
        return this.columns;
    }

    public int horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int verticalAlignment() {
        return this.verticalAlignment;
    }

    public static boolean isTag(String string) {
        return "row".equals(string);
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

