/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TrueTypeFont;
import java.io.IOException;
import java.util.HashMap;

class EnumerateTTC
extends TrueTypeFont {
    protected String[] names;

    EnumerateTTC(String string) throws DocumentException, IOException {
        this.fileName = string;
        this.rf = new RandomAccessFileOrArray(string);
        this.findNames();
    }

    EnumerateTTC(byte[] byArray) throws DocumentException, IOException {
        this.fileName = "Byte array TTC";
        this.rf = new RandomAccessFileOrArray(byArray);
        this.findNames();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void findNames() throws DocumentException, IOException {
        this.tables = new HashMap();
        try {
            String string = this.readStandardString(4);
            if (!string.equals("ttcf")) {
                throw new DocumentException(this.fileName + " is not a valid TTC file.");
            }
            this.rf.skipBytes(4);
            int n2 = this.rf.readInt();
            this.names = new String[n2];
            int n3 = this.rf.getFilePointer();
            int n4 = 0;
            while (n4 < n2) {
                this.tables.clear();
                this.rf.seek(n3);
                this.rf.skipBytes(n4 * 4);
                this.directoryOffset = this.rf.readInt();
                this.rf.seek(this.directoryOffset);
                if (this.rf.readInt() != 65536) {
                    throw new DocumentException(this.fileName + " is not a valid TTF file.");
                }
                int n5 = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                int n6 = 0;
                while (n6 < n5) {
                    String string2 = this.readStandardString(4);
                    this.rf.skipBytes(4);
                    int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt()};
                    this.tables.put(string2, nArray);
                    ++n6;
                }
                this.names[n4] = this.getBaseFont();
                ++n4;
            }
            Object var10_9 = null;
            if (this.rf == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (this.rf == null) throw throwable;
            this.rf.close();
            throw throwable;
        }
        this.rf.close();
    }

    String[] getNames() {
        return this.names;
    }
}

