/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;

public class PRTokeniser {
    public static final int TK_NUMBER = 1;
    public static final int TK_STRING = 2;
    public static final int TK_NAME = 3;
    public static final int TK_COMMENT = 4;
    public static final int TK_START_ARRAY = 5;
    public static final int TK_END_ARRAY = 6;
    public static final int TK_START_DIC = 7;
    public static final int TK_END_DIC = 8;
    public static final int TK_REF = 9;
    public static final int TK_OTHER = 10;
    static final String EMPTY = "";
    protected RandomAccessFileOrArray file;
    protected int type;
    protected String stringValue;
    protected int reference;
    protected int generation;

    public PRTokeniser(String string) throws IOException {
        this.file = new RandomAccessFileOrArray(string);
    }

    public PRTokeniser(byte[] byArray) {
        this.file = new RandomAccessFileOrArray(byArray);
    }

    public void seek(int n2) throws IOException {
        this.file.seek(n2);
    }

    public int getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public void close() throws IOException {
        this.file.close();
    }

    public int length() throws IOException {
        return this.file.length();
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public RandomAccessFileOrArray getSafeFile() {
        return new RandomAccessFileOrArray(this.file);
    }

    public String readString(int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (n2-- > 0) {
            int n3 = this.file.read();
            if (n3 == -1) break;
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public static final boolean isWhitespace(int n2) {
        return n2 == 0 || n2 == 9 || n2 == 10 || n2 == 12 || n2 == 13 || n2 == 32;
    }

    public static final boolean isDelimiter(int n2) {
        return n2 == 40 || n2 == 41 || n2 == 60 || n2 == 62 || n2 == 91 || n2 == 93 || n2 == 47 || n2 == 37;
    }

    public int getTokenType() {
        return this.type;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public int getReference() {
        return this.reference;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void backOnePosition() throws IOException {
        this.file.seek(this.file.getFilePointer() - 1);
    }

    protected void throwError(String string) throws IOException {
        throw new IOException(string + " at file pointer " + this.file.getFilePointer());
    }

    public void checkPdfHeader() throws IOException {
        String string = this.readString(7);
        if (!string.equals("%PDF-1.")) {
            throw new IOException("PDF header signature not found.");
        }
    }

    public int getStartxref() throws IOException {
        int n2 = Math.min(1024, this.file.length());
        int n3 = this.file.length() - n2;
        this.file.seek(n3);
        String string = this.readString(1024);
        int n4 = string.lastIndexOf("startxref");
        if (n4 < 0) {
            throw new IOException("PDF startxref not found.");
        }
        return n3 + n4;
    }

    public static int getHex(int n2) {
        if (n2 >= 48 && n2 <= 57) {
            return n2 - 48;
        }
        if (n2 >= 65 && n2 <= 70) {
            return n2 - 65 + 10;
        }
        if (n2 >= 97 && n2 <= 102) {
            return n2 - 97 + 10;
        }
        return -1;
    }

    public void nextValidToken() throws IOException {
        int n2 = 0;
        String string = null;
        String string2 = null;
        int n3 = 0;
        while (this.nextToken()) {
            if (this.type == 4) continue;
            switch (n2) {
                case 0: {
                    if (this.type != 1) {
                        return;
                    }
                    n3 = this.file.getFilePointer();
                    string = this.stringValue;
                    ++n2;
                    break;
                }
                case 1: {
                    if (this.type != 1) {
                        this.file.seek(n3);
                        this.type = 1;
                        this.stringValue = string;
                        return;
                    }
                    string2 = this.stringValue;
                    ++n2;
                    break;
                }
                default: {
                    if (this.type != 10 || !this.stringValue.equals("R")) {
                        this.file.seek(n3);
                        this.type = 1;
                        this.stringValue = string;
                        return;
                    }
                    this.type = 9;
                    this.reference = Integer.valueOf(string);
                    this.generation = Integer.valueOf(string2);
                    return;
                }
            }
        }
        this.throwError("Unexpected end of file");
    }

    public boolean nextToken() throws IOException {
        StringBuffer stringBuffer = null;
        this.stringValue = EMPTY;
        int n2 = 0;
        while ((n2 = this.file.read()) != -1 && PRTokeniser.isWhitespace(n2)) {
        }
        if (n2 == -1) {
            return false;
        }
        switch (n2) {
            case 91: {
                this.type = 5;
                break;
            }
            case 93: {
                this.type = 6;
                break;
            }
            case 47: {
                stringBuffer = new StringBuffer();
                this.type = 3;
                while ((n2 = this.file.read()) != -1 && !PRTokeniser.isDelimiter(n2) && !PRTokeniser.isWhitespace(n2)) {
                    if (n2 == 35) {
                        n2 = (PRTokeniser.getHex(this.file.read()) << 4) + PRTokeniser.getHex(this.file.read());
                    }
                    stringBuffer.append((char)n2);
                }
                this.backOnePosition();
                break;
            }
            case 62: {
                n2 = this.file.read();
                if (n2 != 62) {
                    this.throwError("'>' not expected");
                }
                this.type = 8;
                break;
            }
            case 60: {
                int n3 = this.file.read();
                if (n3 == 60) {
                    this.type = 7;
                    break;
                }
                stringBuffer = new StringBuffer();
                this.type = 2;
                int n4 = 0;
                while (true) {
                    if (PRTokeniser.isWhitespace(n3)) {
                        n3 = this.file.read();
                        continue;
                    }
                    if (n3 == 62 || (n3 = PRTokeniser.getHex(n3)) < 0) break;
                    n4 = this.file.read();
                    while (PRTokeniser.isWhitespace(n4)) {
                        n4 = this.file.read();
                    }
                    if (n4 == 62) {
                        n2 = n3 << 4;
                        stringBuffer.append((char)n2);
                        break;
                    }
                    if ((n4 = PRTokeniser.getHex(n4)) < 0) break;
                    n2 = (n3 << 4) + n4;
                    stringBuffer.append((char)n2);
                    n3 = this.file.read();
                }
                if (n3 >= 0 && n4 >= 0) break;
                this.throwError("Error reading string");
                break;
            }
            case 37: {
                this.type = 4;
                while ((n2 = this.file.read()) != -1 && n2 != 114 && n2 != 110) {
                }
                break;
            }
            case 40: {
                stringBuffer = new StringBuffer();
                this.type = 2;
                int n5 = 0;
                while ((n2 = this.file.read()) != -1) {
                    if (n2 == 40) {
                        ++n5;
                    } else if (n2 == 41) {
                        --n5;
                    } else if (n2 == 92) {
                        boolean bl = false;
                        n2 = this.file.read();
                        switch (n2) {
                            case 110: {
                                n2 = 10;
                                break;
                            }
                            case 114: {
                                n2 = 13;
                                break;
                            }
                            case 116: {
                                n2 = 9;
                                break;
                            }
                            case 98: {
                                n2 = 8;
                                break;
                            }
                            case 102: {
                                n2 = 12;
                                break;
                            }
                            case 40: 
                            case 41: 
                            case 92: {
                                break;
                            }
                            case 13: {
                                bl = true;
                                n2 = this.file.read();
                                if (n2 == 10) break;
                                this.backOnePosition();
                                break;
                            }
                            case 10: {
                                bl = true;
                                break;
                            }
                            default: {
                                if (n2 < 48 || n2 > 55) break;
                                int n6 = n2 - 48;
                                n2 = this.file.read();
                                if (n2 < 48 || n2 > 55) {
                                    n2 = n6;
                                    this.backOnePosition();
                                    break;
                                }
                                n6 = (n6 << 3) + n2 - 48;
                                n2 = this.file.read();
                                if (n2 < 48 || n2 > 55) {
                                    n2 = n6;
                                    this.backOnePosition();
                                    break;
                                }
                                n6 = (n6 << 3) + n2 - 48;
                                n2 = n6 & 0xFF;
                            }
                        }
                        if (bl) continue;
                        if (n2 < 0) {
                            break;
                        }
                    } else if (n2 == 13) {
                        n2 = this.file.read();
                        if (n2 < 0) break;
                        if (n2 != 10) {
                            n2 = 10;
                            this.backOnePosition();
                        }
                    }
                    if (n5 == -1) break;
                    stringBuffer.append((char)n2);
                }
                if (n2 != -1) break;
                this.throwError("Error reading string");
                break;
            }
            default: {
                stringBuffer = new StringBuffer();
                if (n2 == 45 || n2 == 43 || n2 == 46 || n2 >= 48 && n2 <= 57) {
                    this.type = 1;
                    do {
                        stringBuffer.append((char)n2);
                    } while ((n2 = this.file.read()) != -1 && (n2 >= 48 && n2 <= 57 || n2 == 46));
                } else {
                    this.type = 10;
                    do {
                        stringBuffer.append((char)n2);
                    } while ((n2 = this.file.read()) != -1 && !PRTokeniser.isDelimiter(n2) && !PRTokeniser.isWhitespace(n2));
                }
                this.backOnePosition();
            }
        }
        if (stringBuffer != null) {
            this.stringValue = stringBuffer.toString();
        }
        return true;
    }

    public int intValue() {
        return Integer.valueOf(this.stringValue);
    }
}

