/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;

public class PdfBarcode
extends Chunk {
    public static final int CODE39 = 1;
    public static final int UPCA = 2;
    public static final int EAN13 = 3;
    public static final int INTERLEAVED_2_OF_5 = 4;
    public static final int[][] variableParity = new int[][]{{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 0, 1, 1, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 0, 1, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 0, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 0, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 1, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 1, 1, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 0, 1, 0, 2, 2, 2, 2, 2, 2}};

    public PdfBarcode(String string, int n2, int n3, String string2) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(n2, string2), new Font(BaseFont.createFont(string, "winansi", true), (float)n3));
    }

    public PdfBarcode(String string, int n2, int n3, long l2) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(n2, String.valueOf(l2)), new Font(BaseFont.createFont(string, "winansi", true), (float)n3));
    }

    private static String convertToCode(int n2, String string) throws BadElementException {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        int n4 = 0;
        try {
            switch (n2) {
                case 1: {
                    stringBuffer.append('*');
                    while (n4 < n3) {
                        stringBuffer.append(string.substring(n4++, n4));
                    }
                    stringBuffer.append('*');
                    break;
                }
                case 2: {
                    if (n3 > 12) {
                        throw new BadElementException("An UPC-A barcode can only encode a 12 digit number (your number was " + string + ").");
                    }
                    string = PdfBarcode.addZero(string, 12);
                    int n5 = Integer.parseInt(string.substring(n4++, n4));
                    stringBuffer.append((char)(n5 + 80));
                    while (n4 < 6) {
                        n5 = Integer.parseInt(string.substring(n4++, n4));
                        stringBuffer.append((char)(n5 + 48));
                    }
                    stringBuffer.append('p');
                    while (n4 < 11) {
                        n5 = Integer.parseInt(string.substring(n4++, n4));
                        stringBuffer.append((char)(n5 + 64));
                    }
                    n5 = Integer.parseInt(string.substring(11));
                    stringBuffer.append((char)(n5 + 96));
                    break;
                }
                case 3: {
                    if (n3 > 13) {
                        throw new BadElementException("An EAN-13 barcode can only encode a 13 digit number (your number was " + string + ").");
                    }
                    string = PdfBarcode.addZero(string, 13);
                    int n6 = Integer.parseInt(string.substring(n4++, n4));
                    stringBuffer.append((char)(n6 + 33));
                    int n7 = Integer.parseInt(string.substring(n4++, n4));
                    stringBuffer.append((char)(n7 + 96));
                    while (n4 < 7) {
                        n7 = Integer.parseInt(string.substring(n4++, n4));
                        stringBuffer.append((char)(n7 + 48 + 16 * variableParity[n6][n4 - 2]));
                    }
                    stringBuffer.append('|');
                    while (n4 < 12) {
                        n7 = Integer.parseInt(string.substring(n4++, n4));
                        stringBuffer.append((char)(n7 + 48 + 16 * variableParity[n6][n4 - 2]));
                    }
                    n7 = Integer.parseInt(string.substring(12));
                    stringBuffer.append((char)(n7 + 112));
                    break;
                }
                case 4: {
                    int n8;
                    if (n3 % 2 == 1) {
                        string = PdfBarcode.addZero(string, n3 + 1);
                    }
                    stringBuffer.append('(');
                    while (string.length() > 2) {
                        n8 = Integer.parseInt(string.substring(0, 2));
                        stringBuffer.append(PdfBarcode.convertInterleaved(n8));
                        n4 += 2;
                        string = string.substring(2);
                    }
                    n8 = Integer.parseInt(string);
                    stringBuffer.append(PdfBarcode.convertInterleaved(n8));
                    stringBuffer.append(')');
                    break;
                }
                default: {
                    throw new BadElementException("This type of barcode is not supported yet: " + n2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadElementException("NumberFormatException at position " + n4 + " in " + string + ": " + numberFormatException.getMessage());
        }
        return stringBuffer.toString();
    }

    private static char convertInterleaved(int n2) throws NumberFormatException {
        int n3;
        if (n2 < 50) {
            n3 = 48;
        } else if (n2 < 100) {
            n3 = 142;
        } else {
            throw new NumberFormatException(String.valueOf(n2));
        }
        return (char)(n2 + n3);
    }

    private static String addZero(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 - string.length();
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append('0');
            ++n4;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

