/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfLine;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfCell
extends Rectangle {
    private ArrayList lines;
    private PdfLine line;
    private ArrayList images;
    private float leading;
    private int rownumber;
    private int rowspan;
    private float cellspacing;
    private float cellpadding;
    private boolean header = false;

    public PdfCell(Cell cell, int n2, float f2, float f3, float f4, float f5, float f6) {
        super(f2, f4, f3, f4);
        this.setBorder(cell.border());
        this.setBorderWidth(cell.borderWidth());
        this.setBorderColor(cell.borderColor());
        this.setBackgroundColor(cell.backgroundColor());
        this.setGrayFill(cell.grayFill());
        this.lines = new ArrayList();
        this.images = new ArrayList();
        this.leading = cell.leading();
        int n3 = cell.horizontalAlignment();
        f2 += f5 + f6;
        f3 -= f5 + f6;
        float f7 = this.leading + f6;
        float f8 = cell.rowspan();
        switch (cell.verticalAlignment()) {
            case 6: {
                f7 *= f8;
                break;
            }
            case 5: {
                f7 = (float)((double)f7 * ((double)f8 / 1.5));
                break;
            }
            default: {
                f7 -= f6 * 0.4f;
            }
        }
        this.line = new PdfLine(f2, f3, n3, f7);
        Iterator iterator = cell.getElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            switch (element.type()) {
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    f7 = this.addImage((Image)element, f2, f3, f7, n3);
                    break;
                }
                case 14: {
                    PdfChunk pdfChunk;
                    PdfChunk pdfChunk2;
                    Iterator iterator2;
                    if (this.line.size() > 0) {
                        this.line.resetAlignment();
                        this.lines.add(this.line);
                    }
                    ArrayList arrayList = new ArrayList();
                    this.processActions(element, null, arrayList);
                    int n4 = 0;
                    Iterator iterator3 = ((AbstractList)((List)element).getItems()).iterator();
                    while (iterator3.hasNext()) {
                        ListItem listItem = (ListItem)iterator3.next();
                        this.line = new PdfLine(f2 + listItem.indentationLeft(), f3, n3, this.leading);
                        this.line.setListItem(listItem);
                        iterator2 = ((AbstractList)listItem.getChunks()).iterator();
                        while (iterator2.hasNext()) {
                            pdfChunk2 = new PdfChunk((Chunk)iterator2.next(), (PdfAction)arrayList.get(n4++));
                            while ((pdfChunk = this.line.add(pdfChunk2)) != null) {
                                this.lines.add(this.line);
                                this.line = new PdfLine(f2 + listItem.indentationLeft(), f3, n3, this.leading);
                                pdfChunk2 = pdfChunk;
                            }
                            this.line.resetAlignment();
                            this.lines.add(this.line);
                            this.line = new PdfLine(f2 + listItem.indentationLeft(), f3, n3, this.leading);
                        }
                    }
                    this.line = new PdfLine(f2, f3, n3, this.leading);
                    break;
                }
                default: {
                    PdfChunk pdfChunk;
                    PdfChunk pdfChunk2;
                    ArrayList arrayList = new ArrayList();
                    this.processActions(element, null, arrayList);
                    int n4 = 0;
                    Iterator iterator2 = ((AbstractList)element.getChunks()).iterator();
                    while (iterator2.hasNext()) {
                        Chunk chunk = (Chunk)iterator2.next();
                        pdfChunk2 = new PdfChunk(chunk, (PdfAction)arrayList.get(n4++));
                        while ((pdfChunk = this.line.add(pdfChunk2)) != null) {
                            this.lines.add(this.line);
                            this.line = new PdfLine(f2, f3, n3, this.leading);
                            pdfChunk2 = pdfChunk;
                        }
                    }
                    switch (element.type()) {
                        case 12: 
                        case 13: 
                        case 16: {
                            this.line.resetAlignment();
                            this.lines.add(this.line);
                            this.line = new PdfLine(f2, f3, n3, this.leading);
                        }
                    }
                }
            }
        }
        if (this.line.size() > 0) {
            this.lines.add(this.line);
        }
        this.setBottom(f4 - this.leading * (float)(this.lines.size() - 1) - f6 - f7 - 2.0f * f5);
        this.cellpadding = f6;
        this.cellspacing = f5;
        this.rowspan = cell.rowspan();
        this.rownumber = n2;
    }

    public float left() {
        return super.left(this.cellspacing);
    }

    public float right() {
        return super.right(this.cellspacing);
    }

    public float top() {
        return super.top(this.cellspacing);
    }

    public float bottom() {
        return super.bottom(this.cellspacing);
    }

    private float addImage(Image image, float f2, float f3, float f4, int n2) {
        Image image2 = Image.getInstance(image);
        if (image2.scaledWidth() > f3 - f2) {
            image2.scaleToFit(f3 - f2, Float.MAX_VALUE);
        }
        if (this.line.size() != 0) {
            this.lines.add(this.line);
        }
        this.line = new PdfLine(f2, f3, n2, image2.scaledHeight() + 0.4f * this.leading);
        this.lines.add(this.line);
        this.line = new PdfLine(f2, f3, n2, this.leading);
        switch (image2.alignment() & 3) {
            case 1: {
                f2 = f3 - image2.scaledWidth();
                break;
            }
            case 3: {
                f2 += (f3 - f2 - image2.scaledWidth()) / 2.0f;
                break;
            }
        }
        image2.setAbsolutePosition(f2, f4 + (float)(this.lines.size() - 2) * this.leading + image2.scaledHeight() + 0.4f * this.leading);
        this.images.add(image2);
        return f4 + image2.scaledHeight() + 0.4f * this.leading;
    }

    public ArrayList getLines(float f2, float f3) {
        if (this.top() < f3) {
            return null;
        }
        float f4 = Math.min(this.top(), f2);
        this.setTop(f4 + this.cellspacing);
        ArrayList<PdfLine> arrayList = new ArrayList<PdfLine>();
        int n2 = this.lines.size();
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2 && bl) {
            this.line = (PdfLine)this.lines.get(n3);
            float f5 = this.line.height();
            if ((f4 -= f5) > f3 + this.cellpadding) {
                arrayList.add(this.line);
            } else {
                bl = false;
            }
            ++n3;
        }
        float f6 = 0.0f;
        if (!this.header) {
            if (bl) {
                this.lines = new ArrayList();
            } else {
                n2 = arrayList.size();
                int n4 = 0;
                while (n4 < n2) {
                    this.line = (PdfLine)this.lines.remove(0);
                    f6 += this.line.height();
                    ++n4;
                }
            }
        }
        if (f6 > 0.0f) {
            Iterator iterator = ((AbstractList)this.images).iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.setAbsolutePosition(image.absoluteX(), image.absoluteY() - f6 - this.leading);
            }
        }
        return arrayList;
    }

    public ArrayList getImages(float f2, float f3) {
        if (this.top() < f3) {
            return new ArrayList();
        }
        f2 = Math.min(this.top(), f2);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        Iterator iterator = ((AbstractList)this.images).iterator();
        while (iterator.hasNext() && !this.header) {
            Image image = (Image)iterator.next();
            float f4 = image.absoluteY();
            if (!(f2 - f4 > f3 + this.cellpadding)) continue;
            image.setAbsolutePosition(image.absoluteX(), f2 - f4);
            arrayList.add(image);
            iterator.remove();
        }
        return arrayList;
    }

    boolean isHeader() {
        return this.header;
    }

    void setHeader() {
        this.header = true;
    }

    boolean mayBeRemoved() {
        return this.header || this.lines.size() == 0 && this.images.size() == 0;
    }

    public int size() {
        return this.lines.size();
    }

    public int remainingLines() {
        if (this.lines.size() == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.lines.size();
        int n4 = 0;
        while (n4 < n3) {
            PdfLine pdfLine = (PdfLine)this.lines.get(n4);
            if (pdfLine.size() > 0) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    public float remainingHeight() {
        float f2 = 0.0f;
        Iterator iterator = ((AbstractList)this.images).iterator();
        while (iterator.hasNext()) {
            Image image = (Image)iterator.next();
            f2 += image.scaledHeight();
        }
        return (float)this.remainingLines() * this.leading + 2.0f * this.cellpadding + this.cellspacing + f2 + this.leading / 2.5f;
    }

    public float leading() {
        return this.leading;
    }

    public int rownumber() {
        return this.rownumber;
    }

    public int rowspan() {
        return this.rowspan;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    protected void processActions(Element element, PdfAction pdfAction, ArrayList arrayList) {
        Iterator iterator;
        if (element.type() == 17 && (iterator = ((Anchor)element).reference()) != null) {
            pdfAction = new PdfAction((String)((Object)iterator));
        }
        switch (element.type()) {
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                iterator = ((AbstractList)((ArrayList)((Object)element))).iterator();
                while (iterator.hasNext()) {
                    this.processActions((Element)iterator.next(), pdfAction, arrayList);
                }
                break;
            }
            case 10: {
                arrayList.add(pdfAction);
                break;
            }
            case 14: {
                iterator = ((AbstractList)((List)element).getItems()).iterator();
                while (iterator.hasNext()) {
                    this.processActions((Element)iterator.next(), pdfAction, arrayList);
                }
                break;
            }
            default: {
                ArrayList arrayList2 = element.getChunks();
                int n2 = element.getChunks().size();
                while (n2-- > 0) {
                    arrayList.add(pdfAction);
                }
                break block0;
            }
        }
    }
}

