/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfOutline
extends PdfDictionary {
    private PdfIndirectReference reference;
    private int count = 0;
    private PdfOutline parent;
    private PdfDestination destination;
    private PdfAction action;
    protected ArrayList kids = new ArrayList();
    protected PdfWriter writer;
    private String tag;
    private boolean open;

    PdfOutline(PdfWriter pdfWriter) {
        super(PdfDictionary.OUTLINES);
        this.open = true;
        this.parent = null;
        this.writer = pdfWriter;
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, String string) {
        this(pdfOutline, pdfAction, string, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, String string, boolean bl) {
        this.action = pdfAction;
        this.initOutline(pdfOutline, string, bl);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, String string) {
        this(pdfOutline, pdfDestination, string, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, String string, boolean bl) {
        this.destination = pdfDestination;
        this.initOutline(pdfOutline, string, bl);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, PdfString pdfString) {
        this(pdfOutline, pdfAction, pdfString, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, PdfString pdfString, boolean bl) {
        this(pdfOutline, pdfAction, pdfString.toString(), true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, PdfString pdfString) {
        this(pdfOutline, pdfDestination, pdfString, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, PdfString pdfString, boolean bl) {
        this(pdfOutline, pdfDestination, pdfString.toString(), true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, Paragraph paragraph) {
        this(pdfOutline, pdfAction, paragraph, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, Paragraph paragraph, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)paragraph.getChunks()).iterator();
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            stringBuffer.append(chunk.content());
        }
        this.action = pdfAction;
        this.initOutline(pdfOutline, stringBuffer.toString(), bl);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, Paragraph paragraph) {
        this(pdfOutline, pdfDestination, paragraph, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, Paragraph paragraph, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)paragraph.getChunks()).iterator();
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            stringBuffer.append(chunk.content());
        }
        this.destination = pdfDestination;
        this.initOutline(pdfOutline, stringBuffer.toString(), bl);
    }

    void initOutline(PdfOutline pdfOutline, String string, boolean bl) {
        this.open = bl;
        this.parent = pdfOutline;
        this.writer = pdfOutline.writer;
        this.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
        pdfOutline.addKid(this);
        this.setDestinationPage(this.writer.getCurrentPage());
    }

    public void setIndirectReference(PdfIndirectReference pdfIndirectReference) {
        this.reference = pdfIndirectReference;
    }

    public PdfIndirectReference indirectReference() {
        return this.reference;
    }

    public PdfOutline parent() {
        return this.parent;
    }

    public boolean setDestinationPage(PdfIndirectReference pdfIndirectReference) {
        if (this.destination == null) {
            return false;
        }
        return this.destination.addPage(pdfIndirectReference);
    }

    public PdfDestination getPdfDestination() {
        return this.destination;
    }

    int getCount() {
        return this.count;
    }

    void setCount(int n2) {
        this.count = n2;
    }

    public int level() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.level() + 1;
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        if (this.parent != null) {
            this.put(PdfName.PARENT, this.parent.indirectReference());
        }
        if (this.destination != null && this.destination.hasPage()) {
            this.put(PdfName.DEST, this.destination);
        }
        if (this.action != null) {
            this.put(PdfName.A, this.action);
        }
        if (this.count != 0) {
            this.put(PdfName.COUNT, new PdfNumber(this.count));
        }
        return super.toPdf(pdfWriter);
    }

    public void addKid(PdfOutline pdfOutline) {
        this.kids.add(pdfOutline);
    }

    public ArrayList getKids() {
        return this.kids;
    }

    public void setKids(ArrayList arrayList) {
        this.kids = arrayList;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public String getTitle() {
        PdfString pdfString = (PdfString)this.get(PdfName.TITLE);
        return pdfString.toString();
    }

    public void setTitle(String string) {
        this.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }
}

