/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.TrueTypeFontSubSet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

class TrueTypeFontUnicode
extends TrueTypeFont
implements Comparator {
    boolean vertical = false;

    TrueTypeFontUnicode(String string, String string2, boolean bl, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        String string4 = TrueTypeFont.getTTCName(string3);
        if (string3.length() < string.length()) {
            this.style = string.substring(string3.length());
        }
        this.encoding = string2;
        this.embedded = bl;
        this.fileName = string4;
        this.ttcIndex = "";
        if (string4.length() < string3.length()) {
            this.ttcIndex = string3.substring(string4.length() + 1);
        }
        this.fontType = 3;
        if ((this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".ttc")) && (string2.equals("Identity-H") || string2.equals("Identity-V")) && bl) {
            this.process(byArray);
            if (this.cmap31 == null && !this.fontSpecific || this.cmap10 == null && this.fontSpecific) {
                throw new DocumentException(this.fileName + " " + this.style + " does not contain an usable cmap.");
            }
            if (this.fontSpecific) {
                this.fontSpecific = false;
                String string5 = this.encoding;
                this.encoding = "PDF";
                try {
                    this.createEncoding();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new DocumentException(unsupportedEncodingException.getMessage());
                }
                this.encoding = string5;
                this.fontSpecific = true;
            }
        } else {
            throw new DocumentException(this.fileName + " " + this.style + " is not a TTF font file.");
        }
        this.vertical = string2.endsWith("V");
    }

    public int getWidth(String string) {
        if (this.vertical) {
            return string.length() * 1000;
        }
        int n2 = 0;
        if (this.fontSpecific) {
            byte[] byArray = PdfEncodings.convertToBytes(string, "Cp1252");
            int n3 = byArray.length;
            int n4 = 0;
            while (n4 < n3) {
                n2 += this.getRawWidth(byArray[n4] & 0xFF, null);
                ++n4;
            }
        } else {
            int n5 = string.length();
            int n6 = 0;
            while (n6 < n5) {
                n2 += this.getRawWidth(string.charAt(n6), this.encoding);
                ++n6;
            }
        }
        return n2;
    }

    private PdfStream getToUnicode(Object[] objectArray) throws DocumentException {
        Object object;
        Object object2;
        if (objectArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n" + TrueTypeFontUnicode.toHex(((int[])objectArray[0])[0]) + TrueTypeFontUnicode.toHex(((int[])objectArray[objectArray.length - 1])[0]) + "\n" + "endcodespacerange\n");
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (n2 == 0) {
                if (n3 != 0) {
                    stringBuffer.append("endbfrange\n");
                }
                n2 = Math.min(100, objectArray.length - n3);
                stringBuffer.append(n2).append(" beginbfrange\n");
            }
            --n2;
            object2 = (int[])objectArray[n3];
            object = TrueTypeFontUnicode.toHex((int)object2[0]);
            stringBuffer.append((String)object).append((String)object).append(TrueTypeFontUnicode.toHex((int)object2[2])).append("\n");
            ++n3;
        }
        stringBuffer.append("endbfrange\nendcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        object2 = stringBuffer.toString();
        object = new PdfStream(PdfEncodings.convertToBytes((String)object2, null));
        ((PdfStream)object).flateCompress();
        return object;
    }

    static String toHex(int n2) {
        String string = Integer.toHexString(n2);
        return "<0000".substring(0, 5 - string.length()) + string + ">";
    }

    private PdfDictionary getCIDFontType2(PdfIndirectReference pdfIndirectReference, String string, Object[] objectArray) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, new PdfName("CIDFontType2"));
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName));
        pdfDictionary.put(PdfName.FONTDESCRIPTOR, pdfIndirectReference);
        pdfDictionary.put(new PdfName("CIDToGIDMap"), new PdfName("Identity"));
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.REGISTRY, new PdfString("Adobe"));
        pdfDictionary2.put(PdfName.ORDERING, new PdfString("Identity"));
        pdfDictionary2.put(PdfName.SUPPLEMENT, new PdfNumber(0));
        pdfDictionary.put(new PdfName("CIDSystemInfo"), pdfDictionary2);
        if (!this.vertical) {
            pdfDictionary.put(new PdfName("DW"), new PdfNumber(1000));
            StringBuffer stringBuffer = new StringBuffer("[");
            int n2 = -10;
            boolean bl = true;
            int n3 = 0;
            while (n3 < objectArray.length) {
                int[] nArray = (int[])objectArray[n3];
                if (nArray[1] != 1000) {
                    int n4 = nArray[0];
                    if (n4 == n2 + 1) {
                        stringBuffer.append(" ").append(nArray[1]);
                    } else {
                        if (!bl) {
                            stringBuffer.append("]");
                        }
                        bl = false;
                        stringBuffer.append(n4).append("[").append(nArray[1]);
                    }
                    n2 = n4;
                }
                ++n3;
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append("]]");
                pdfDictionary.put(PdfName.W, new PdfLiteral(stringBuffer.toString()));
            }
        }
        return pdfDictionary;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, String string, PdfIndirectReference pdfIndirectReference2) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, new PdfName("Type0"));
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName));
        pdfDictionary.put(PdfName.ENCODING, new PdfName(this.encoding));
        pdfDictionary.put(new PdfName("DescendantFonts"), new PdfArray(pdfIndirectReference));
        if (pdfIndirectReference2 != null) {
            pdfDictionary.put(new PdfName("ToUnicode"), pdfIndirectReference2);
        }
        return pdfDictionary;
    }

    public int compare(Object object, Object object2) {
        int n2 = ((int[])object)[0];
        int n3 = ((int[])object2)[0];
        if (n2 < n3) {
            return -1;
        }
        if (n2 == n3) {
            return 0;
        }
        return 1;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        HashMap hashMap = (HashMap)objectArray[0];
        Object[] objectArray2 = hashMap.values().toArray();
        Arrays.sort(objectArray2, this);
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = null;
        PdfIndirectObject pdfIndirectObject = null;
        TrueTypeFontSubSet trueTypeFontSubSet = new TrueTypeFontSubSet(this.fileName, this.rf, hashMap, this.directoryOffset, false);
        byte[] byArray = trueTypeFontSubSet.process();
        int[] nArray = new int[]{byArray.length};
        pdfDictionary = (BaseFont)this.new BaseFont.StreamFont(byArray, nArray);
        pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
        pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        String string = this.createSubsetPrefix();
        PdfDictionary pdfDictionary2 = this.getFontDescriptor(pdfIndirectReference2, string);
        pdfIndirectObject = pdfWriter.addToBody(pdfDictionary2);
        pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        pdfDictionary = this.getCIDFontType2(pdfIndirectReference2, string, objectArray2);
        pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
        pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        pdfDictionary = this.getToUnicode(objectArray2);
        PdfIndirectReference pdfIndirectReference3 = null;
        if (pdfDictionary != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference3 = pdfIndirectObject.getIndirectReference();
        }
        pdfDictionary = this.getFontBaseType(pdfIndirectReference2, string, pdfIndirectReference3);
        pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
    }

    byte[] convertToBytes(String string) {
        return null;
    }
}

