/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.CharVector;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;

public class TernaryTree
implements Cloneable,
Serializable {
    protected char[] lo;
    protected char[] hi;
    protected char[] eq;
    protected char[] sc;
    protected CharVector kv;
    protected char root;
    protected char freenode;
    protected int length;
    protected static final int BLOCK_SIZE = 2048;

    TernaryTree() {
        this.init();
    }

    protected void init() {
        this.root = '\u0000';
        this.freenode = '\u0001';
        this.length = 0;
        this.lo = new char[2048];
        this.hi = new char[2048];
        this.eq = new char[2048];
        this.sc = new char[2048];
        this.kv = new CharVector();
    }

    public void insert(String string, char c2) {
        int n2 = string.length() + 1;
        if (this.freenode + n2 > this.eq.length) {
            this.redimNodeArrays(this.eq.length + 2048);
        }
        char[] cArray = new char[n2--];
        string.getChars(0, n2, cArray, 0);
        cArray[n2] = '\u0000';
        this.root = this.insert(this.root, cArray, 0, c2);
    }

    public void insert(char[] cArray, int n2, char c2) {
        int n3 = TernaryTree.strlen(cArray) + 1;
        if (this.freenode + n3 > this.eq.length) {
            this.redimNodeArrays(this.eq.length + 2048);
        }
        this.root = this.insert(this.root, cArray, n2, c2);
    }

    private char insert(char c2, char[] cArray, int n2, char c3) {
        char c4;
        int n3 = TernaryTree.strlen(cArray, n2);
        if (c2 == '\u0000') {
            char c5 = this.freenode;
            this.freenode = (char)(c5 + '\u0001');
            c2 = c5;
            this.eq[c2] = c3;
            ++this.length;
            this.hi[c2] = '\u0000';
            if (n3 > 0) {
                this.sc[c2] = 65535;
                this.lo[c2] = (char)this.kv.alloc(n3 + 1);
                TernaryTree.strcpy(this.kv.getArray(), this.lo[c2], cArray, n2);
            } else {
                this.sc[c2] = '\u0000';
                this.lo[c2] = '\u0000';
            }
            return c2;
        }
        if (this.sc[c2] == '\uffff') {
            char c6 = this.freenode;
            this.freenode = (char)(c6 + '\u0001');
            c4 = c6;
            this.lo[c4] = this.lo[c2];
            this.eq[c4] = this.eq[c2];
            this.lo[c2] = '\u0000';
            if (n3 > 0) {
                this.sc[c2] = this.kv.get(this.lo[c4]);
                this.eq[c2] = c4;
                char c7 = c4;
                this.lo[c7] = (char)(this.lo[c7] + '\u0001');
                if (this.kv.get(this.lo[c4]) == '\u0000') {
                    this.lo[c4] = '\u0000';
                    this.sc[c4] = '\u0000';
                    this.hi[c4] = '\u0000';
                } else {
                    this.sc[c4] = 65535;
                }
            } else {
                this.sc[c4] = 65535;
                this.hi[c2] = c4;
                this.sc[c2] = '\u0000';
                this.eq[c2] = c3;
                ++this.length;
                return c2;
            }
        }
        if ((c4 = cArray[n2]) < this.sc[c2]) {
            this.lo[c2] = this.insert(this.lo[c2], cArray, n2, c3);
        } else if (c4 == this.sc[c2]) {
            this.eq[c2] = c4 != '\u0000' ? this.insert(this.eq[c2], cArray, n2 + 1, c3) : c3;
        } else {
            this.hi[c2] = this.insert(this.hi[c2], cArray, n2, c3);
        }
        return c2;
    }

    public static int strcmp(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray[n2] == cArray2[n3]) {
            if (cArray[n2] == '\u0000') {
                return 0;
            }
            ++n2;
            ++n3;
        }
        return cArray[n2] - cArray2[n3];
    }

    public static int strcmp(String string, char[] cArray, int n2) {
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = string.charAt(n4) - cArray[n2 + n4];
            if (n5 != 0) {
                return n5;
            }
            if (cArray[n2 + n4] == '\u0000') {
                return n5;
            }
            ++n4;
        }
        if (cArray[n2 + n4] != '\u0000') {
            return -cArray[n2 + n4];
        }
        return 0;
    }

    public static void strcpy(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray2[n3] != '\u0000') {
            cArray[n2++] = cArray2[n3++];
        }
        cArray[n2] = '\u0000';
    }

    public static int strlen(char[] cArray, int n2) {
        int n3 = 0;
        int n4 = n2;
        while (n4 < cArray.length && cArray[n4] != '\u0000') {
            ++n3;
            ++n4;
        }
        return n3;
    }

    public static int strlen(char[] cArray) {
        return TernaryTree.strlen(cArray, 0);
    }

    public int find(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2 + 1];
        string.getChars(0, n2, cArray, 0);
        cArray[n2] = '\u0000';
        return this.find(cArray, 0);
    }

    public int find(char[] cArray, int n2) {
        char c2 = this.root;
        int n3 = n2;
        while (c2 != '\u0000') {
            if (this.sc[c2] == '\uffff') {
                if (TernaryTree.strcmp(cArray, n3, this.kv.getArray(), this.lo[c2]) == 0) {
                    return this.eq[c2];
                }
                return -1;
            }
            char c3 = cArray[n3];
            int n4 = c3 - this.sc[c2];
            if (n4 == 0) {
                if (c3 == '\u0000') {
                    return this.eq[c2];
                }
                ++n3;
                c2 = this.eq[c2];
                continue;
            }
            c2 = n4 < 0 ? this.lo[c2] : this.hi[c2];
        }
        return -1;
    }

    public boolean knows(String string) {
        return this.find(string) >= 0;
    }

    private void redimNodeArrays(int n2) {
        int n3 = n2 < this.lo.length ? n2 : this.lo.length;
        char[] cArray = new char[n2];
        System.arraycopy(this.lo, 0, cArray, 0, n3);
        this.lo = cArray;
        cArray = new char[n2];
        System.arraycopy(this.hi, 0, cArray, 0, n3);
        this.hi = cArray;
        cArray = new char[n2];
        System.arraycopy(this.eq, 0, cArray, 0, n3);
        this.eq = cArray;
        cArray = new char[n2];
        System.arraycopy(this.sc, 0, cArray, 0, n3);
        this.sc = cArray;
    }

    public int size() {
        return this.length;
    }

    public Object clone() {
        TernaryTree ternaryTree = new TernaryTree();
        ternaryTree.lo = (char[])this.lo.clone();
        ternaryTree.hi = (char[])this.hi.clone();
        ternaryTree.eq = (char[])this.eq.clone();
        ternaryTree.sc = (char[])this.sc.clone();
        ternaryTree.kv = (CharVector)this.kv.clone();
        ternaryTree.root = this.root;
        ternaryTree.freenode = this.freenode;
        ternaryTree.length = this.length;
        return ternaryTree;
    }

    protected void insertBalanced(String[] stringArray, char[] cArray, int n2, int n3) {
        if (n3 < 1) {
            return;
        }
        int n4 = n3 >> 1;
        this.insert(stringArray[n4 + n2], cArray[n4 + n2]);
        this.insertBalanced(stringArray, cArray, n2, n4);
        this.insertBalanced(stringArray, cArray, n2 + n4 + 1, n3 - n4 - 1);
    }

    public void balance() {
        int n2 = 0;
        int n3 = this.length;
        String[] stringArray = new String[n3];
        char[] cArray = new char[n3];
        Iterator iterator = new Iterator();
        while (iterator.hasMoreElements()) {
            cArray[n2] = iterator.getValue();
            stringArray[n2++] = (String)iterator.nextElement();
        }
        this.init();
        this.insertBalanced(stringArray, cArray, 0, n3);
    }

    public void trimToSize() {
        this.balance();
        this.redimNodeArrays(this.freenode);
        CharVector charVector = new CharVector();
        charVector.alloc(1);
        TernaryTree ternaryTree = new TernaryTree();
        this.compact(charVector, ternaryTree, this.root);
        this.kv = charVector;
        this.kv.trimToSize();
    }

    private void compact(CharVector charVector, TernaryTree ternaryTree, char c2) {
        if (c2 == '\u0000') {
            return;
        }
        if (this.sc[c2] == '\uffff') {
            int n2 = ternaryTree.find(this.kv.getArray(), this.lo[c2]);
            if (n2 < 0) {
                n2 = charVector.alloc(TernaryTree.strlen(this.kv.getArray(), this.lo[c2]) + 1);
                TernaryTree.strcpy(charVector.getArray(), n2, this.kv.getArray(), this.lo[c2]);
                ternaryTree.insert(charVector.getArray(), n2, (char)n2);
            }
            this.lo[c2] = (char)n2;
        } else {
            this.compact(charVector, ternaryTree, this.lo[c2]);
            if (this.sc[c2] != '\u0000') {
                this.compact(charVector, ternaryTree, this.eq[c2]);
            }
            this.compact(charVector, ternaryTree, this.hi[c2]);
        }
    }

    public Enumeration keys() {
        return new Iterator();
    }

    public void printStats() {
        System.out.println("Number of keys = " + Integer.toString(this.length));
        System.out.println("Node count = " + Integer.toString(this.freenode));
        System.out.println("Key Array length = " + Integer.toString(this.kv.length()));
    }

    public class Iterator
    implements Enumeration {
        int cur = -1;
        String curkey;
        Stack ns = new Stack();
        StringBuffer ks = new StringBuffer();

        public Iterator() {
            this.rewind();
        }

        public void rewind() {
            this.ns.removeAllElements();
            this.ks.setLength(0);
            this.cur = TernaryTree.this.root;
            this.run();
        }

        public Object nextElement() {
            String string = new String(this.curkey);
            this.cur = this.up();
            this.run();
            return string;
        }

        public char getValue() {
            if (this.cur >= 0) {
                return TernaryTree.this.eq[this.cur];
            }
            return '\u0000';
        }

        public boolean hasMoreElements() {
            return this.cur != -1;
        }

        private int up() {
            Item item = new Item();
            int n2 = 0;
            if (this.ns.empty()) {
                return -1;
            }
            if (this.cur != 0 && TernaryTree.this.sc[this.cur] == '\u0000') {
                return TernaryTree.this.lo[this.cur];
            }
            boolean bl = true;
            while (bl) {
                item = (Item)this.ns.pop();
                item.child = (char)(item.child + '\u0001');
                switch (item.child) {
                    case '\u0001': {
                        if (TernaryTree.this.sc[item.parent] != '\u0000') {
                            n2 = TernaryTree.this.eq[item.parent];
                            this.ns.push(item.clone());
                            this.ks.append(TernaryTree.this.sc[item.parent]);
                        } else {
                            item.child = (char)(item.child + '\u0001');
                            this.ns.push(item.clone());
                            n2 = TernaryTree.this.hi[item.parent];
                        }
                        bl = false;
                        break;
                    }
                    case '\u0002': {
                        n2 = TernaryTree.this.hi[item.parent];
                        this.ns.push(item.clone());
                        if (this.ks.length() > 0) {
                            this.ks.setLength(this.ks.length() - 1);
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        if (this.ns.empty()) {
                            return -1;
                        }
                        bl = true;
                    }
                }
            }
            return n2;
        }

        private int run() {
            block9: {
                if (this.cur == -1) {
                    return -1;
                }
                boolean bl = false;
                while (true) {
                    if (this.cur != 0) {
                        if (TernaryTree.this.sc[this.cur] == '\uffff') {
                            bl = true;
                        } else {
                            this.ns.push(new Item((char)this.cur, '\u0000'));
                            if (TernaryTree.this.sc[this.cur] == '\u0000') {
                                bl = true;
                            } else {
                                this.cur = TernaryTree.this.lo[this.cur];
                                continue;
                            }
                        }
                    }
                    if (bl) break block9;
                    this.cur = this.up();
                    if (this.cur == -1) break;
                }
                return -1;
            }
            StringBuffer stringBuffer = new StringBuffer(this.ks.toString());
            if (TernaryTree.this.sc[this.cur] == '\uffff') {
                int n2 = TernaryTree.this.lo[this.cur];
                while (TernaryTree.this.kv.get(n2) != '\u0000') {
                    stringBuffer.append(TernaryTree.this.kv.get(n2++));
                }
            }
            this.curkey = stringBuffer.toString();
            return 0;
        }

        private class Item
        implements Cloneable {
            char parent;
            char child;

            public Item() {
                this.parent = '\u0000';
                this.child = '\u0000';
            }

            public Item(char c2, char c3) {
                this.parent = c2;
                this.child = c3;
            }

            public Object clone() {
                return new Item(this.parent, this.child);
            }
        }
    }
}

