/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.wmf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.wmf.InputMeta;
import com.lowagie.text.pdf.wmf.MetaBrush;
import com.lowagie.text.pdf.wmf.MetaFont;
import com.lowagie.text.pdf.wmf.MetaObject;
import com.lowagie.text.pdf.wmf.MetaPen;
import com.lowagie.text.pdf.wmf.MetaState;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MetaDo {
    public static final int META_SETBKCOLOR = 513;
    public static final int META_SETBKMODE = 258;
    public static final int META_SETMAPMODE = 259;
    public static final int META_SETROP2 = 260;
    public static final int META_SETRELABS = 261;
    public static final int META_SETPOLYFILLMODE = 262;
    public static final int META_SETSTRETCHBLTMODE = 263;
    public static final int META_SETTEXTCHAREXTRA = 264;
    public static final int META_SETTEXTCOLOR = 521;
    public static final int META_SETTEXTJUSTIFICATION = 522;
    public static final int META_SETWINDOWORG = 523;
    public static final int META_SETWINDOWEXT = 524;
    public static final int META_SETVIEWPORTORG = 525;
    public static final int META_SETVIEWPORTEXT = 526;
    public static final int META_OFFSETWINDOWORG = 527;
    public static final int META_SCALEWINDOWEXT = 1040;
    public static final int META_OFFSETVIEWPORTORG = 529;
    public static final int META_SCALEVIEWPORTEXT = 1042;
    public static final int META_LINETO = 531;
    public static final int META_MOVETO = 532;
    public static final int META_EXCLUDECLIPRECT = 1045;
    public static final int META_INTERSECTCLIPRECT = 1046;
    public static final int META_ARC = 2071;
    public static final int META_ELLIPSE = 1048;
    public static final int META_FLOODFILL = 1049;
    public static final int META_PIE = 2074;
    public static final int META_RECTANGLE = 1051;
    public static final int META_ROUNDRECT = 1564;
    public static final int META_PATBLT = 1565;
    public static final int META_SAVEDC = 30;
    public static final int META_SETPIXEL = 1055;
    public static final int META_OFFSETCLIPRGN = 544;
    public static final int META_TEXTOUT = 1313;
    public static final int META_BITBLT = 2338;
    public static final int META_STRETCHBLT = 2851;
    public static final int META_POLYGON = 804;
    public static final int META_POLYLINE = 805;
    public static final int META_ESCAPE = 1574;
    public static final int META_RESTOREDC = 295;
    public static final int META_FILLREGION = 552;
    public static final int META_FRAMEREGION = 1065;
    public static final int META_INVERTREGION = 298;
    public static final int META_PAINTREGION = 299;
    public static final int META_SELECTCLIPREGION = 300;
    public static final int META_SELECTOBJECT = 301;
    public static final int META_SETTEXTALIGN = 302;
    public static final int META_CHORD = 2096;
    public static final int META_SETMAPPERFLAGS = 561;
    public static final int META_EXTTEXTOUT = 2610;
    public static final int META_SETDIBTODEV = 3379;
    public static final int META_SELECTPALETTE = 564;
    public static final int META_REALIZEPALETTE = 53;
    public static final int META_ANIMATEPALETTE = 1078;
    public static final int META_SETPALENTRIES = 55;
    public static final int META_POLYPOLYGON = 1336;
    public static final int META_RESIZEPALETTE = 313;
    public static final int META_DIBBITBLT = 2368;
    public static final int META_DIBSTRETCHBLT = 2881;
    public static final int META_DIBCREATEPATTERNBRUSH = 322;
    public static final int META_STRETCHDIB = 3907;
    public static final int META_EXTFLOODFILL = 1352;
    public static final int META_DELETEOBJECT = 496;
    public static final int META_CREATEPALETTE = 247;
    public static final int META_CREATEPATTERNBRUSH = 505;
    public static final int META_CREATEPENINDIRECT = 762;
    public static final int META_CREATEFONTINDIRECT = 763;
    public static final int META_CREATEBRUSHINDIRECT = 764;
    public static final int META_CREATEREGION = 1791;
    public PdfContentByte cb;
    public InputMeta in;
    int left;
    int top;
    int right;
    int bottom;
    int inch;
    MetaState state = new MetaState();

    public MetaDo(InputStream inputStream, PdfContentByte pdfContentByte) {
        this.cb = pdfContentByte;
        this.in = new InputMeta(inputStream);
    }

    public void readAll() throws IOException, DocumentException {
        if (this.in.readInt() != -1698247209) {
            throw new DocumentException("Not a placeable windows metafile");
        }
        this.in.readWord();
        this.left = this.in.readShort();
        this.top = this.in.readShort();
        this.right = this.in.readShort();
        this.bottom = this.in.readShort();
        this.inch = this.in.readWord();
        this.state.setScalingX((float)(this.right - this.left) / (float)this.inch * 72.0f);
        this.state.setScalingY((float)(this.bottom - this.top) / (float)this.inch * 72.0f);
        this.in.readInt();
        this.in.readWord();
        this.in.skip(18);
        this.cb.setLineCap(1);
        this.cb.setLineJoin(1);
        while (true) {
            int n2 = this.in.getLength();
            int n3 = this.in.readInt();
            if (n3 < 3) break;
            int n4 = this.in.readWord();
            switch (n4) {
                case 0: {
                    break;
                }
                case 247: 
                case 322: 
                case 1791: {
                    this.state.addMetaObject(new MetaObject());
                    break;
                }
                case 762: {
                    MetaPen metaPen = new MetaPen();
                    metaPen.init(this.in);
                    this.state.addMetaObject(metaPen);
                    break;
                }
                case 764: {
                    MetaBrush metaBrush = new MetaBrush();
                    metaBrush.init(this.in);
                    this.state.addMetaObject(metaBrush);
                    break;
                }
                case 763: {
                    MetaFont metaFont = new MetaFont();
                    metaFont.init(this.in);
                    this.state.addMetaObject(metaFont);
                    break;
                }
                case 301: {
                    int n5 = this.in.readWord();
                    this.state.selectMetaObject(n5, this.cb);
                    break;
                }
                case 496: {
                    int n6 = this.in.readWord();
                    this.state.deleteMetaObject(n6);
                    break;
                }
                case 30: {
                    this.state.saveState(this.cb);
                    break;
                }
                case 295: {
                    int n7 = this.in.readShort();
                    this.state.restoreState(n7, this.cb);
                    break;
                }
                case 523: {
                    this.state.setOffsetWy(this.in.readShort());
                    this.state.setOffsetWx(this.in.readShort());
                    break;
                }
                case 524: {
                    this.state.setExtentWy(this.in.readShort());
                    this.state.setExtentWx(this.in.readShort());
                    break;
                }
                case 532: {
                    int n8 = this.in.readShort();
                    Point point = new Point(this.in.readShort(), n8);
                    this.state.setCurrentPoint(point);
                    break;
                }
                case 531: {
                    int n9 = this.in.readShort();
                    int n10 = this.in.readShort();
                    Point point = this.state.getCurrentPoint();
                    this.cb.moveTo(this.state.transformX(point.x), this.state.transformY(point.y));
                    this.cb.lineTo(this.state.transformX(n10), this.state.transformY(n9));
                    this.cb.stroke();
                    this.state.setCurrentPoint(new Point(n10, n9));
                    break;
                }
                case 805: {
                    this.state.setLineJoinPolygon(this.cb);
                    int n11 = this.in.readWord();
                    int n12 = this.in.readShort();
                    int n13 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n12), this.state.transformY(n13));
                    int n14 = 1;
                    while (n14 < n11) {
                        n12 = this.in.readShort();
                        n13 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n12), this.state.transformY(n13));
                        ++n14;
                    }
                    this.cb.stroke();
                    break;
                }
                case 804: {
                    if (this.isNullStrokeFill(false)) break;
                    int n15 = this.in.readWord();
                    int n16 = this.in.readShort();
                    int n17 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n16), this.state.transformY(n17));
                    int n18 = 1;
                    while (n18 < n15) {
                        int n19 = this.in.readShort();
                        int n20 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n19), this.state.transformY(n20));
                        ++n18;
                    }
                    this.cb.lineTo(this.state.transformX(n16), this.state.transformY(n17));
                    this.strokeAndFill();
                    break;
                }
                case 1336: {
                    int n21;
                    int n22;
                    if (this.isNullStrokeFill(false)) break;
                    int n23 = this.in.readWord();
                    int[] nArray = new int[n23];
                    int n24 = 0;
                    while (n24 < nArray.length) {
                        nArray[n24] = this.in.readWord();
                        ++n24;
                    }
                    int n25 = 0;
                    while (n25 < nArray.length) {
                        int n26 = nArray[n25];
                        int n27 = this.in.readShort();
                        n22 = this.in.readShort();
                        this.cb.moveTo(this.state.transformX(n27), this.state.transformY(n22));
                        int n28 = 1;
                        while (n28 < n26) {
                            int n29 = this.in.readShort();
                            n21 = this.in.readShort();
                            this.cb.lineTo(this.state.transformX(n29), this.state.transformY(n21));
                            ++n28;
                        }
                        this.cb.lineTo(this.state.transformX(n27), this.state.transformY(n22));
                        ++n25;
                    }
                    this.strokeAndFill();
                    break;
                }
                case 1048: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    int n30 = this.in.readShort();
                    int n31 = this.in.readShort();
                    int n32 = this.in.readShort();
                    int n33 = this.in.readShort();
                    this.cb.arc(this.state.transformX(n33), this.state.transformY(n30), this.state.transformX(n31), this.state.transformY(n32), 0.0f, 360.0f);
                    this.strokeAndFill();
                    break;
                }
                case 2071: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f2 = this.state.transformY(this.in.readShort());
                    float f3 = this.state.transformX(this.in.readShort());
                    float f4 = this.state.transformY(this.in.readShort());
                    float f5 = this.state.transformX(this.in.readShort());
                    float f6 = this.state.transformY(this.in.readShort());
                    float f7 = this.state.transformX(this.in.readShort());
                    float f8 = this.state.transformY(this.in.readShort());
                    float f9 = this.state.transformX(this.in.readShort());
                    float f10 = (f7 + f9) / 2.0f;
                    float f11 = (f8 + f6) / 2.0f;
                    float f12 = MetaDo.getArc(f10, f11, f5, f4);
                    float f13 = MetaDo.getArc(f10, f11, f3, f2);
                    if ((f13 -= f12) <= 0.0f) {
                        f13 += 360.0f;
                    }
                    this.cb.arc(f9, f6, f7, f8, f12, f13);
                    this.cb.stroke();
                    break;
                }
                case 2074: {
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f14 = this.state.transformY(this.in.readShort());
                    float f15 = this.state.transformX(this.in.readShort());
                    float f16 = this.state.transformY(this.in.readShort());
                    float f17 = this.state.transformX(this.in.readShort());
                    float f18 = this.state.transformY(this.in.readShort());
                    float f19 = this.state.transformX(this.in.readShort());
                    float f20 = this.state.transformY(this.in.readShort());
                    float f21 = this.state.transformX(this.in.readShort());
                    float f22 = (f19 + f21) / 2.0f;
                    float f23 = (f20 + f18) / 2.0f;
                    float f24 = MetaDo.getArc(f22, f23, f17, f16);
                    float f25 = MetaDo.getArc(f22, f23, f15, f14);
                    if ((f25 -= f24) <= 0.0f) {
                        f25 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f21, f18, f19, f20, f24, f25)).size() == 0) break;
                    float[] fArray = (float[])arrayList.get(0);
                    this.cb.moveTo(f22, f23);
                    this.cb.lineTo(fArray[0], fArray[1]);
                    int n34 = 0;
                    while (n34 < arrayList.size()) {
                        fArray = (float[])arrayList.get(n34);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                        ++n34;
                    }
                    this.cb.lineTo(f22, f23);
                    this.strokeAndFill();
                    break;
                }
                case 2096: {
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f26 = this.state.transformY(this.in.readShort());
                    float f27 = this.state.transformX(this.in.readShort());
                    float f28 = this.state.transformY(this.in.readShort());
                    float f29 = this.state.transformX(this.in.readShort());
                    float f30 = this.state.transformY(this.in.readShort());
                    float f31 = this.state.transformX(this.in.readShort());
                    float f32 = this.state.transformY(this.in.readShort());
                    float f33 = this.state.transformX(this.in.readShort());
                    float f34 = (f31 + f33) / 2.0f;
                    float f35 = (f32 + f30) / 2.0f;
                    float f36 = MetaDo.getArc(f34, f35, f29, f28);
                    float f37 = MetaDo.getArc(f34, f35, f27, f26);
                    if ((f37 -= f36) <= 0.0f) {
                        f37 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f33, f30, f31, f32, f36, f37)).size() == 0) break;
                    float[] fArray = (float[])arrayList.get(0);
                    f34 = fArray[0];
                    f35 = fArray[1];
                    this.cb.moveTo(f34, f35);
                    int n34 = 0;
                    while (n34 < arrayList.size()) {
                        fArray = (float[])arrayList.get(n34);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                        ++n34;
                    }
                    this.cb.lineTo(f34, f35);
                    this.strokeAndFill();
                    break;
                }
                case 1051: {
                    if (this.isNullStrokeFill(true)) break;
                    float f38 = this.state.transformY(this.in.readShort());
                    float f39 = this.state.transformX(this.in.readShort());
                    float f40 = this.state.transformY(this.in.readShort());
                    float f41 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f41, f38, f39 - f41, f40 - f38);
                    this.strokeAndFill();
                    break;
                }
                case 1046: {
                    float f42 = this.state.transformY(this.in.readShort());
                    float f43 = this.state.transformX(this.in.readShort());
                    float f44 = this.state.transformY(this.in.readShort());
                    float f45 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f45, f42, f43 - f45, f44 - f42);
                    this.cb.eoClip();
                    this.cb.newPath();
                    break;
                }
                case 2610: {
                    String string;
                    int n35 = this.in.readShort();
                    int n36 = this.in.readShort();
                    int n37 = this.in.readWord();
                    int n38 = this.in.readWord();
                    int n39 = 0;
                    int n40 = 0;
                    int n22 = 0;
                    int n41 = 0;
                    if ((n38 & 6) != 0) {
                        n39 = this.in.readShort();
                        n40 = this.in.readShort();
                        n22 = this.in.readShort();
                        n41 = this.in.readShort();
                    }
                    byte[] byArray = new byte[n37];
                    int n21 = 0;
                    while (n21 < n37) {
                        byte by = (byte)this.in.readByte();
                        if (by == 0) break;
                        byArray[n21] = by;
                        ++n21;
                    }
                    try {
                        string = new String(byArray, 0, n21, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n21);
                    }
                    this.outputText(n36, n35, n38, n39, n40, n22, n41, string);
                    break;
                }
                case 1313: {
                    String string;
                    int n42 = this.in.readWord();
                    byte[] byArray = new byte[n42];
                    int n43 = 0;
                    while (n43 < n42) {
                        byte by = (byte)this.in.readByte();
                        if (by == 0) break;
                        byArray[n43] = by;
                        ++n43;
                    }
                    try {
                        string = new String(byArray, 0, n43, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n43);
                    }
                    n42 = n42 + 1 & 0xFFFE;
                    this.in.skip(n42 - n43);
                    int n44 = this.in.readShort();
                    int n45 = this.in.readShort();
                    this.outputText(n45, n44, 0, 0, 0, 0, 0, string);
                    break;
                }
                case 513: {
                    this.state.setCurrentBackgroundColor(this.in.readColor());
                    break;
                }
                case 521: {
                    this.state.setCurrentTextColor(this.in.readColor());
                    break;
                }
                case 302: {
                    this.state.setTextAlign(this.in.readWord());
                    break;
                }
                case 258: {
                    this.state.setBackgroundMode(this.in.readWord());
                    break;
                }
                case 262: {
                    this.state.setPolyFillMode(this.in.readWord());
                    break;
                }
                case 1055: {
                    Color color = this.in.readColor();
                    int n46 = this.in.readShort();
                    int n47 = this.in.readShort();
                    this.cb.saveState();
                    this.cb.setColorFill(color);
                    this.cb.rectangle(this.state.transformX(n47), this.state.transformY(n46), 0.2f, 0.2f);
                    this.cb.fill();
                    this.cb.restoreState();
                }
            }
            this.in.skip(n3 * 2 - (this.in.getLength() - n2));
        }
    }

    public void outputText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) throws IOException {
        Color color;
        MetaFont metaFont = this.state.getCurrentFont();
        float f2 = this.state.transformX(n2);
        float f3 = this.state.transformY(n3);
        float f4 = (float)Math.sin(metaFont.getAngle());
        float f5 = (float)Math.cos(metaFont.getAngle());
        float f6 = metaFont.getFontSize(this.state);
        BaseFont baseFont = metaFont.getFont();
        int n9 = this.state.getTextAlign();
        float f7 = baseFont.getWidthPoint(string, f6);
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = baseFont.getFontDescriptor(3, f6);
        float f11 = baseFont.getFontDescriptor(8, f6);
        this.cb.saveState();
        this.cb.concatCTM(f5, f4, -f4, f5, f2, f3);
        if ((n9 & 6) == 6) {
            f8 = -f7 / 2.0f;
        } else if ((n9 & 2) == 2) {
            f8 = -f7;
        }
        f9 = (n9 & 0x18) == 24 ? 0.0f : ((n9 & 8) == 8 ? -f10 : -f11);
        if (this.state.getBackgroundMode() == 2) {
            color = this.state.getCurrentBackgroundColor();
            this.cb.setColorFill(color);
            this.cb.rectangle(f8, f9 + f10, f7, f11 - f10);
            this.cb.fill();
        }
        color = this.state.getCurrentTextColor();
        this.cb.setColorFill(color);
        this.cb.beginText();
        this.cb.setFontAndSize(baseFont, f6);
        this.cb.setTextMatrix(f8, f9);
        this.cb.showText(string);
        this.cb.endText();
        if (metaFont.isUnderline()) {
            this.cb.rectangle(f8, f9 - f6 / 4.0f, f7, f6 / 15.0f);
            this.cb.fill();
        }
        if (metaFont.isStrikeout()) {
            this.cb.rectangle(f8, f9 + f6 / 3.0f, f7, f6 / 15.0f);
            this.cb.fill();
        }
        this.cb.restoreState();
    }

    public boolean isNullStrokeFill(boolean bl) {
        boolean bl2;
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        boolean bl3 = metaPen.getStyle() == 5;
        int n2 = metaBrush.getStyle();
        boolean bl4 = n2 == 0 || n2 == 2 && this.state.getBackgroundMode() == 2;
        boolean bl5 = bl2 = bl3 && !bl4;
        if (!bl3) {
            if (bl) {
                this.state.setLineJoinRectangle(this.cb);
            } else {
                this.state.setLineJoinPolygon(this.cb);
            }
        }
        return bl2;
    }

    public void strokeAndFill() {
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        int n2 = metaPen.getStyle();
        int n3 = metaBrush.getStyle();
        if (n2 == 5) {
            this.cb.closePath();
            if (this.state.getPolyFillMode() == 1) {
                this.cb.eoFill();
            } else {
                this.cb.fill();
            }
        } else {
            boolean bl;
            boolean bl2 = bl = n3 == 0 || n3 == 2 && this.state.getBackgroundMode() == 2;
            if (bl) {
                if (this.state.getPolyFillMode() == 1) {
                    this.cb.closePathEoFillStroke();
                } else {
                    this.cb.closePathFillStroke();
                }
            } else {
                this.cb.closePathStroke();
            }
        }
    }

    static float getArc(float f2, float f3, float f4, float f5) {
        double d2 = Math.atan2(f5 - f3, f4 - f2);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return (float)(d2 / Math.PI * 180.0);
    }
}

