/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.Color;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.freehep.application.Application;

public abstract class PropertyUtilities {
    public static Rectangle getRectangle(Properties prop, String key, Rectangle def) {
        try {
            Rectangle result = new Rectangle();
            result.x = PropertyUtilities.getInteger(prop, key.concat("-x"));
            result.y = PropertyUtilities.getInteger(prop, key.concat("-y"));
            result.width = PropertyUtilities.getInteger(prop, key.concat("-w"));
            result.height = PropertyUtilities.getInteger(prop, key.concat("-h"));
            return result;
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static void setRectangle(Properties prop, String key, Rectangle rect) {
        prop.put(key.concat("-x"), String.valueOf(rect.x));
        prop.put(key.concat("-y"), String.valueOf(rect.y));
        prop.put(key.concat("-w"), String.valueOf(rect.width));
        prop.put(key.concat("-h"), String.valueOf(rect.height));
    }

    public static Color getColor(Properties prop, String key, Color def) {
        try {
            return new Color(PropertyUtilities.getInteger(prop, key.concat("-r")), PropertyUtilities.getInteger(prop, key.concat("-g")), PropertyUtilities.getInteger(prop, key.concat("-b")));
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static void setColor(Properties prop, String key, Color c2) {
        prop.put(key.concat("-r"), String.valueOf(c2.getRed()));
        prop.put(key.concat("-g"), String.valueOf(c2.getGreen()));
        prop.put(key.concat("-b"), String.valueOf(c2.getBlue()));
    }

    public static String[] getStringArray(Properties prop, String key, String[] def) {
        try {
            String[] result = new String[PropertyUtilities.getInteger(prop, key + "-length")];
            int i2 = 0;
            while (i2 < result.length) {
                result[i2] = prop.getProperty(key + "-" + i2);
                ++i2;
            }
            return result;
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static void setStringArray(Properties prop, String key, String[] sa) {
        if (sa == null) {
            sa = new String[]{};
        }
        prop.put(key + "-length", String.valueOf(sa.length));
        int i2 = 0;
        while (i2 < sa.length) {
            prop.put(key + "-" + i2, sa[i2]);
            ++i2;
        }
    }

    public static String getString(Properties prop, String key, String def) {
        try {
            String s2 = prop.getProperty(key);
            return s2 == null ? def : s2;
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static void setString(Properties prop, String key, String s2) {
        if (s2 == null) {
            s2 = "";
        }
        prop.put(key, s2);
    }

    public static boolean getBoolean(Properties prop, String key, boolean def) {
        String value = prop.getProperty(key);
        return value == null ? def : Boolean.valueOf(value);
    }

    public static void setBoolean(Properties prop, String key, boolean value) {
        prop.put(key, String.valueOf(value));
    }

    public static int getInteger(Properties prop, String key) throws NumberFormatException {
        return Integer.valueOf(prop.getProperty(key));
    }

    public static int getInteger(Properties prop, String key, int def) {
        try {
            return Integer.valueOf(prop.getProperty(key));
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static void setInteger(Properties prop, String key, int i2) {
        prop.put(key, String.valueOf(i2));
    }

    public static void setFloat(Properties prop, String key, float f2) {
        prop.put(key, String.valueOf(f2));
    }

    public static float getFloat(Properties prop, String key, float def) {
        try {
            return Float.valueOf(prop.getProperty(key)).floatValue();
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static void setURL(Properties prop, String key, URL url) {
        prop.put(key, url.toString());
    }

    public static URL getURL(Properties prop, String key, URL def) {
        String p2 = prop.getProperty(key);
        if (p2 == null) {
            return def;
        }
        try {
            return new URL(p2);
        }
        catch (MalformedURLException x2) {
            URL url = Application.getApplication().getClass().getResource(p2);
            return url == null ? def : url;
        }
    }

    public static String translate(Properties prop, String in) {
        if (in == null) {
            return null;
        }
        StringBuffer out = null;
        int l2 = in.length();
        int pos = 0;
        while (pos < l2) {
            int end;
            int start = in.indexOf(123, pos);
            if (start < 0 || (end = in.indexOf(125, start)) < 0 || end - start < 2) break;
            if (out == null) {
                out = new StringBuffer(in.substring(0, start));
            } else {
                out.append(in.substring(pos, start));
            }
            String value = prop.getProperty(in.substring(start + 1, end));
            if (value != null) {
                out.append(value);
            }
            pos = end + 1;
        }
        if (out == null) {
            return in;
        }
        if (pos < l2) {
            out.append(in.substring(pos));
        }
        return out.toString();
    }

    public static class TranslatedProperties
    extends Properties {
        public TranslatedProperties() {
        }

        public TranslatedProperties(Properties def) {
            super(def);
        }

        public String getProperty(String key) {
            return PropertyUtilities.translate(this, super.getProperty(key));
        }

        public String getProperty(String key, String def) {
            return PropertyUtilities.translate(this, super.getProperty(key, def));
        }
    }

    public static class PropertyTable
    extends AbstractTableModel
    implements Comparator {
        private List list;

        PropertyTable(Properties prop) {
            this.list = new ArrayList<Map.Entry<Object, Object>>(prop.entrySet());
            Collections.sort(this.list, this);
        }

        public int compare(Object o1, Object o2) {
            Map.Entry entry1 = (Map.Entry)o1;
            Map.Entry entry2 = (Map.Entry)o2;
            String name1 = entry1.getKey().toString();
            String name2 = entry2.getKey().toString();
            return name1.compareTo(name2);
        }

        public int getRowCount() {
            return this.list.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int row, int column) {
            Map.Entry entry = (Map.Entry)this.list.get(row);
            return column == 0 ? entry.getKey() : entry.getValue();
        }

        public String getColumnName(int col) {
            return col == 0 ? "Property" : "Value";
        }
    }
}

