/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.freehep.application.Stoppable;

public class StoppableInputStream
extends FilterInputStream
implements Stoppable,
BoundedRangeModel {
    private boolean stop = false;
    private int pos = 0;
    private int max;
    private int markPos;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent event = new ChangeEvent(this);
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public StoppableInputStream(URL url) throws IOException {
        this(url.openConnection());
    }

    private StoppableInputStream(URLConnection connection) throws IOException {
        super(connection.getInputStream());
        this.max = connection.getContentLength();
    }

    public StoppableInputStream(InputStream in, int length) {
        super(in);
        this.max = length;
    }

    public BoundedRangeModel getModel() {
        return this;
    }

    public void stop() {
        this.stop = true;
    }

    public int read(byte[] b2) throws IOException {
        if (this.stop) {
            throw new InterruptedIOException("IO aborted by user");
        }
        int l2 = super.read(b2);
        this.pos += l2;
        this.firePositionChanged();
        return l2;
    }

    public int read() throws IOException {
        if (this.stop) {
            throw new InterruptedIOException("IO aborted by user");
        }
        int value = super.read();
        ++this.pos;
        this.firePositionChanged();
        return value;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.stop) {
            throw new InterruptedIOException("IO aborted by user");
        }
        int l2 = super.read(b2, off, len);
        this.pos += l2;
        this.firePositionChanged();
        return l2;
    }

    public long skip(long n2) throws IOException {
        if (this.stop) {
            throw new InterruptedIOException("IO aborted by user");
        }
        long l2 = super.skip(n2);
        this.pos += (int)l2;
        this.firePositionChanged();
        return l2;
    }

    public void reset() throws IOException {
        if (this.stop) {
            throw new InterruptedIOException("IO aborted by user");
        }
        super.reset();
        this.pos = this.markPos;
        this.firePositionChanged();
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this.markPos = this.pos;
    }

    public void addChangeListener(ChangeListener x2) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = StoppableInputStream.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, x2);
    }

    public void removeChangeListener(ChangeListener x2) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = StoppableInputStream.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, x2);
    }

    private void firePositionChanged() {
        ChangeListener[] list = (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = StoppableInputStream.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
        int i2 = 0;
        while (i2 < list.length) {
            list[i2].stateChanged(this.event);
            ++i2;
        }
    }

    public int getExtent() {
        return 0;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return 0;
    }

    public int getValue() {
        return this.pos;
    }

    public boolean getValueIsAdjusting() {
        return false;
    }

    public void setExtent(int newExtent) {
    }

    public void setMaximum(int newMaximum) {
    }

    public void setMinimum(int newMinimum) {
    }

    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
    }

    public void setValue(int newValue) {
    }

    public void setValueIsAdjusting(boolean b2) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

