/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.application.mdi.CloseButtonTabbedPane;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;

public class TabbedPageManager
extends PageManager {
    protected JTabbedPane tabs = new CloseButtonTabbedPane(){

        protected void fireCloseTabAt(int index) {
            TabbedPageManager.this.close((PageContext)TabbedPageManager.this.pages().get(index));
        }
    };
    private ChangeListener cl = new ChangeListener(){

        public void stateChanged(ChangeEvent e2) {
            int index = TabbedPageManager.this.tabs.getSelectedIndex();
            if (index < 0) {
                TabbedPageManager.this.fireSelectionChanged(null);
            } else {
                TabbedPageManager.this.fireSelectionChanged((PageContext)TabbedPageManager.this.pages().get(index));
            }
        }
    };

    public TabbedPageManager() {
        this.tabs.addChangeListener(this.cl);
    }

    public void setTabPlacement(int placement) {
        this.tabs.setTabPlacement(placement);
    }

    public int getTabPlacement() {
        return this.tabs.getTabPlacement();
    }

    protected void show(PageContext page) {
        this.tabs.setSelectedComponent(page.getPage());
    }

    protected Component getEmbodiment() {
        return this.tabs;
    }

    protected boolean close(PageContext page) {
        boolean ok = super.close(page);
        if (ok) {
            this.tabs.removeTabAt(this.indexOfPage(page));
        }
        return ok;
    }

    private String hackedTitle(String title) {
        return title == null ? CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE : title + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE;
    }

    protected void titleChanged(PageContext page) {
        this.tabs.setTitleAt(this.indexOfPage(page), this.hackedTitle(page.getTitle()));
    }

    protected void iconChanged(PageContext page) {
        this.tabs.setIconAt(this.indexOfPage(page), page.getIcon());
    }

    protected int indexOfPage(PageContext page) {
        return this.tabs.indexOfComponent(page.getPage());
    }

    public PageContext openPage(Component c2, String title, Icon icon) {
        PageContext context = super.openPage(c2, title, icon);
        this.tabs.addTab(this.hackedTitle(title), icon, c2);
        super.firePageOpened(context);
        this.tabs.setSelectedComponent(c2);
        return context;
    }

    protected void init(List pages, PageContext selected) {
        this.tabs.removeChangeListener(this.cl);
        Iterator i2 = pages.iterator();
        while (i2.hasNext()) {
            PageContext context = (PageContext)i2.next();
            this.tabs.addTab(this.hackedTitle(context.getTitle()), context.getIcon(), context.getPage());
            if (context != selected) continue;
            this.tabs.setSelectedComponent(context.getPage());
        }
        super.init(pages, selected);
        this.tabs.addChangeListener(this.cl);
        if (selected == null && pages.size() > 0) {
            this.fireSelectionChanged((PageContext)this.pages().get(this.tabs.getSelectedIndex()));
        }
    }
}

