/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import org.freehep.graphics2d.TagString;

public class TagHandler {
    public String parse(TagString string) {
        String src = string.toString();
        StringBuffer parsedString = new StringBuffer();
        StringBuffer textString = new StringBuffer();
        int i2 = 0;
        int p2 = 0;
        try {
            while (i2 < src.length()) {
                switch (src.charAt(i2)) {
                    case '&': {
                        p2 = ++i2;
                        while (src.charAt(i2) != ';') {
                            ++i2;
                        }
                        String ent = src.substring(p2, i2);
                        if (ent.equals("amp") || ent.equals("gt") || ent.equals("lt") || ent.equals("quot") || ent.equals("apos")) {
                            textString.append(this.defaultEntity(ent));
                            break;
                        }
                        textString.append(this.entity(ent));
                        break;
                    }
                    case '<': {
                        if (textString.length() > 0) {
                            parsedString.append(this.text(textString.toString()));
                            textString = new StringBuffer();
                        }
                        p2 = ++i2;
                        while (src.charAt(i2) != '>') {
                            ++i2;
                        }
                        if (src.charAt(p2) == '/') {
                            parsedString.append(this.closeTag(src.substring(p2 + 1, i2)));
                            break;
                        }
                        parsedString.append(this.openTag(src.substring(p2, i2)));
                        break;
                    }
                    default: {
                        textString.append(src.charAt(i2));
                    }
                }
                ++i2;
            }
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            parsedString.append("!PARSEERROR!");
        }
        if (textString.length() > 0) {
            parsedString.append(this.text(textString.toString()));
        }
        return parsedString.toString();
    }

    protected String defaultEntity(String entity) {
        StringBuffer dst = new StringBuffer();
        if (entity.equals("amp")) {
            dst.append('&');
        } else if (entity.equals("gt")) {
            dst.append('>');
        } else if (entity.equals("lt")) {
            dst.append('<');
        } else if (entity.equals("quot")) {
            dst.append('\"');
        } else if (entity.equals("apos")) {
            dst.append('\'');
        }
        return dst.toString();
    }

    protected String entity(String entity) {
        StringBuffer dst = new StringBuffer();
        dst.append('&');
        dst.append(entity);
        dst.append(';');
        return dst.toString();
    }

    protected String openTag(String tag) {
        StringBuffer dst = new StringBuffer();
        dst.append('<');
        dst.append(tag);
        dst.append('>');
        return dst.toString();
    }

    protected String closeTag(String tag) {
        StringBuffer dst = new StringBuffer();
        dst.append("</");
        dst.append(tag);
        dst.append('>');
        return dst.toString();
    }

    protected String text(String text) {
        return text;
    }

    public static void main(String[] args) {
        String text = "&lt;Vector<sup><b>Graphics</b></sup> &amp; Card<i><sub>Adapter</sub></i>&gt;";
        TagString s2 = new TagString(text);
        TagHandler handler = new TagHandler();
        System.out.println("\"" + s2 + "\"");
        System.out.println(handler.parse(s2));
    }
}

