/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Writer;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.util.io.IndentPrintWriter;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TaggedOutput;

public class CGMWriter
extends IndentPrintWriter
implements TaggedOutput {
    private int version;
    private boolean direct = true;
    private int colorIndexPrecision = 8;
    private int directColorPrecision = 8;
    private int integerPrecision = 16;
    private boolean fixedPrecision = true;
    private boolean doublePrecision = false;
    private boolean vdcReal = false;
    private boolean vdcFixedPrecision = true;
    private boolean vdcDoublePrecision = false;
    private int vdcIntegerPrecision = 16;
    private int namePrecision = 16;
    private int lineWidthSpecificationMode = 0;
    private int markerSizeSpecificationMode = 0;
    private int edgeWidthSpecificationMode = 0;
    private int interiorStyleSpecificationMode = 0;

    public CGMWriter(Writer writer, int version) throws IOException {
        super(writer);
        this.version = version;
    }

    public CGMWriter(Writer writer) throws IOException {
        this(writer, 1);
    }

    void setColorMode(boolean direct) {
        this.direct = direct;
    }

    void setColorIndexPrecision(int precision) {
        this.colorIndexPrecision = precision;
    }

    void setDirectColorPrecision(int precision) {
        this.directColorPrecision = precision;
    }

    void setIntegerPrecision(int precision) {
        this.integerPrecision = precision;
    }

    void setRealPrecision(boolean fixedPrecision, boolean doublePrecision) {
        this.fixedPrecision = fixedPrecision;
        this.doublePrecision = doublePrecision;
    }

    void setVDCReal(boolean real) {
        this.vdcReal = real;
    }

    void setVDCIntegerPrecision(int precision) {
        this.vdcIntegerPrecision = precision;
    }

    void setVDCRealPrecision(boolean fixedPrecision, boolean doublePrecision) {
        this.vdcFixedPrecision = fixedPrecision;
        this.vdcDoublePrecision = doublePrecision;
    }

    void setNamePrecision(int precision) {
        this.namePrecision = precision;
    }

    void setLineWidthSpecificationMode(int mode) {
        this.lineWidthSpecificationMode = mode;
    }

    int getLineWidthSpecificationMode() {
        return this.lineWidthSpecificationMode;
    }

    void setMarkerSizeSpecificationMode(int mode) {
        this.markerSizeSpecificationMode = mode;
    }

    int getMarkerSizeSpecificationMode() {
        return this.markerSizeSpecificationMode;
    }

    void setEdgeWidthSpecificationMode(int mode) {
        this.edgeWidthSpecificationMode = mode;
    }

    int getEdgeWidthSpecificationMode() {
        return this.edgeWidthSpecificationMode;
    }

    void setInteriorStyleSpecificationMode(int mode) {
        this.interiorStyleSpecificationMode = mode;
    }

    int getInteriorStyleSpecificationMode() {
        return this.interiorStyleSpecificationMode;
    }

    public void writeFixedPoint(double d2) throws IOException {
        boolean negative = d2 < 0.0;
        d2 = Math.abs(d2);
        int whole = (int)Math.floor(d2);
        int frac = (int)Math.floor((d2 - (double)whole) * 10000.0);
        if (negative) {
            this.print("-");
        }
        this.print(whole);
        this.print(".");
        this.print(frac);
    }

    public void writeFloatingPoint(double d2) throws IOException {
        if (this.doublePrecision) {
            this.print(d2);
        } else {
            this.print((float)d2);
        }
    }

    public void writeColorIndex(int i2) throws IOException {
        switch (this.colorIndexPrecision) {
            case 8: {
                this.print(Math.max(0, Math.min(255, i2)));
                break;
            }
            case 16: {
                this.print(Math.max(0, Math.min(65535, i2)));
                break;
            }
            default: {
                this.print(i2);
            }
        }
    }

    public void writeColorComponent(int c2) throws IOException {
        switch (this.directColorPrecision) {
            default: {
                this.print(Math.max(0, Math.min(255, c2)));
                break;
            }
            case 16: {
                this.print(Math.max(0, Math.min(65535, c2)));
                break;
            }
            case 24: 
            case 32: {
                this.print(c2);
            }
        }
    }

    public void writeColorDirect(Color c2) throws IOException {
        this.writeColorComponent(c2.getRed());
        this.print(", ");
        this.writeColorComponent(c2.getGreen());
        this.print(", ");
        this.writeColorComponent(c2.getBlue());
    }

    public void writeInteger(int i2) throws IOException {
        switch (this.integerPrecision) {
            case 8: {
                this.print((byte)i2);
                break;
            }
            default: {
                this.print((short)i2);
                break;
            }
            case 24: 
            case 32: {
                this.print(i2);
            }
        }
    }

    public void writeReal(double r2) throws IOException {
        if (this.fixedPrecision) {
            this.writeFixedPoint(r2);
        } else {
            this.writeFloatingPoint(r2);
        }
    }

    public void writeString(String s2) throws IOException {
        StringBuffer b2 = new StringBuffer();
        b2.append('\"');
        int i2 = 0;
        while (i2 < s2.length()) {
            b2.append(s2.charAt(i2));
            if (s2.charAt(i2) == '\"') {
                b2.append('\"');
            }
            ++i2;
        }
        b2.append('\"');
        this.print(b2.toString());
    }

    public void writeData(byte[] data) throws IOException {
        this.writeString(new String(data));
    }

    public void writeVDC(double d2) throws IOException {
        if (this.vdcReal) {
            if (this.vdcFixedPrecision) {
                this.writeFixedPoint(d2);
            } else if (this.vdcDoublePrecision) {
                this.print(d2);
            } else {
                this.print((float)d2);
            }
        } else {
            switch (this.vdcIntegerPrecision) {
                default: {
                    this.print((short)d2);
                    break;
                }
                case 24: 
                case 32: {
                    this.print(d2);
                }
            }
        }
    }

    public void writePoint(Point2D p2) throws IOException {
        this.print("(");
        this.writeVDC(p2.getX());
        this.print(", ");
        this.writeVDC(p2.getY());
        this.print(")");
    }

    public void writeColor(Color c2) throws IOException {
        if (this.direct) {
            this.writeColorDirect(c2);
        } else {
            this.writeColorIndex((c2.getRed() << 16) + (c2.getGreen() << 8) + c2.getBlue());
        }
    }

    public void writeName(int name) throws IOException {
        switch (this.namePrecision) {
            case 8: {
                this.print(Math.max(0, Math.min(255, name)));
                break;
            }
            default: {
                this.print(Math.max(0, Math.min(65535, name)));
                break;
            }
            case 24: 
            case 32: {
                this.print(name);
            }
        }
    }

    public void writeTag(Tag tag) throws IOException {
        CGMTag cgm = (CGMTag)tag;
        cgm.write(cgm.getTag(), this);
        this.println(";");
    }

    public int getVersion() {
        return this.version;
    }
}

