/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class CellArray
extends CGMTag {
    public static final int RUN_LENGTH = 0;
    public static final int PACKED = 1;
    private Point2D p;
    private Point2D q;
    private Point2D r;
    private Color[][] colorArray;
    private int precision;
    private int mode;

    public CellArray() {
        super(4, 9, 1);
    }

    public CellArray(Point2D p2, Point2D q2, Point2D r2, Color[][] colorArray, int precision, int mode) {
        this();
        this.p = p2;
        this.q = q2;
        this.r = r2;
        this.colorArray = colorArray;
        this.precision = 0;
        this.mode = 1;
    }

    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.writePoint(this.p);
        cgm.writePoint(this.q);
        cgm.writePoint(this.r);
        cgm.writeInteger(this.colorArray.length);
        cgm.writeInteger(this.colorArray[0].length);
        cgm.writeInteger(this.precision);
        cgm.writeEnumerate(this.mode);
        int i2 = 0;
        while (i2 < this.colorArray.length) {
            int j2 = 0;
            while (i2 < this.colorArray[0].length) {
                cgm.writeColor(this.colorArray[i2][j2]);
                ++j2;
            }
            ++i2;
        }
    }

    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.println("CELLARRAY");
        cgm.indent();
        cgm.writePoint(this.p);
        cgm.println();
        cgm.writePoint(this.q);
        cgm.println();
        cgm.writePoint(this.r);
        cgm.println();
        cgm.writeInteger(this.colorArray.length);
        cgm.println();
        cgm.writeInteger(this.colorArray[0].length);
        cgm.println();
        cgm.writeInteger(0);
        cgm.println();
        int i2 = 0;
        while (i2 < this.colorArray.length) {
            cgm.print("(");
            int j2 = 0;
            while (i2 < this.colorArray[0].length) {
                cgm.writeColor(this.colorArray[i2][j2]);
                cgm.print(", ");
                ++j2;
            }
            cgm.println(")");
            ++i2;
        }
        cgm.outdent();
    }
}

