/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class CharacterSetList
extends CGMTag {
    public static final int GSET_94 = 0;
    public static final int GSET_96 = 1;
    public static final int GSET_94_MULTIBYTE = 2;
    public static final int GSET_96_MULTIBYTE = 3;
    public static final int COMPLETE = 4;
    private int[] type;
    private String[] designation;

    public CharacterSetList() {
        super(1, 14, 1);
    }

    public CharacterSetList(int[] type, String[] designation) {
        this();
        this.type = type;
        this.designation = designation;
    }

    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        int i2 = 0;
        while (i2 < this.type.length) {
            cgm.writeEnumerate(this.type[i2]);
            cgm.writeString(this.designation[i2]);
            ++i2;
        }
    }

    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.println("CHARSETLIST");
        cgm.indent();
        int i2 = 0;
        while (i2 < this.type.length) {
            switch (this.type[i2]) {
                default: {
                    cgm.print("STD94");
                    break;
                }
                case 1: {
                    cgm.print("STD96");
                    break;
                }
                case 2: {
                    cgm.print("STD94MULTIBYTE");
                    break;
                }
                case 3: {
                    cgm.print("STD96MULTIBYTE");
                    break;
                }
                case 4: {
                    cgm.print("COMPLETECODE");
                }
            }
            cgm.print(", ");
            cgm.writeString(this.designation[i2]);
            cgm.println();
            ++i2;
        }
        cgm.outdent();
    }
}

