/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.emf.AlphaBlend;
import org.freehep.graphicsio.emf.BeginPath;
import org.freehep.graphicsio.emf.CreateBrushIndirect;
import org.freehep.graphicsio.emf.DeleteObject;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFHandleManager;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFPathConstructor;
import org.freehep.graphicsio.emf.EOF;
import org.freehep.graphicsio.emf.EndPath;
import org.freehep.graphicsio.emf.ExtCreateFontIndirectW;
import org.freehep.graphicsio.emf.ExtCreatePen;
import org.freehep.graphicsio.emf.ExtLogFontW;
import org.freehep.graphicsio.emf.ExtLogPen;
import org.freehep.graphicsio.emf.ExtSelectClipRgn;
import org.freehep.graphicsio.emf.ExtTextOutW;
import org.freehep.graphicsio.emf.FillPath;
import org.freehep.graphicsio.emf.LogBrush32;
import org.freehep.graphicsio.emf.ModifyWorldTransform;
import org.freehep.graphicsio.emf.Region;
import org.freehep.graphicsio.emf.RestoreDC;
import org.freehep.graphicsio.emf.SaveDC;
import org.freehep.graphicsio.emf.SelectClipPath;
import org.freehep.graphicsio.emf.SelectObject;
import org.freehep.graphicsio.emf.SetBkMode;
import org.freehep.graphicsio.emf.SetMapMode;
import org.freehep.graphicsio.emf.SetMiterLimit;
import org.freehep.graphicsio.emf.SetPolyFillMode;
import org.freehep.graphicsio.emf.SetTextAlign;
import org.freehep.graphicsio.emf.SetTextColor;
import org.freehep.graphicsio.emf.SetViewportExtEx;
import org.freehep.graphicsio.emf.SetViewportOrgEx;
import org.freehep.graphicsio.emf.SetWindowExtEx;
import org.freehep.graphicsio.emf.SetWindowOrgEx;
import org.freehep.graphicsio.emf.StrokeAndFillPath;
import org.freehep.graphicsio.emf.StrokePath;
import org.freehep.graphicsio.emf.TextW;
import org.freehep.graphicsio.font.FontUtilities;
import org.freehep.util.UserProperties;

public class EMFGraphics2D
extends AbstractVectorGraphicsIO
implements EMFConstants {
    public static final String version = "$Revision: 1.22 $";
    private EMFHandleManager handleManager;
    private int penHandle;
    private int brushHandle;
    private Rectangle imageBounds;
    private OutputStream ros;
    private EMFOutputStream os;
    private boolean fontSet = false;
    private boolean textColorSet = false;
    private Map fontTable;
    private Map unitFontTable;
    private EMFGraphics2D parentGraphics;
    private EMFPathConstructor pathConstructor;
    private boolean evenOdd;
    private static final Rectangle dummy = new Rectangle(0, 0, 0, 0);
    private static final String rootKey = (class$org$freehep$graphicsio$emf$EMFGraphics2D == null ? (class$org$freehep$graphicsio$emf$EMFGraphics2D = EMFGraphics2D.class$("org.freehep.graphicsio.emf.EMFGraphics2D")) : class$org$freehep$graphicsio$emf$EMFGraphics2D).getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    private static final UserProperties defaultProperties = new UserProperties();
    private static final Properties replaceFonts;
    static /* synthetic */ Class class$org$freehep$graphicsio$emf$EMFGraphics2D;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public EMFGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public EMFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public EMFGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.imageBounds = new Rectangle(0, 0, size.width, size.height);
        this.init(os);
    }

    public EMFGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.imageBounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.fontTable = new HashMap();
        this.unitFontTable = new HashMap();
        this.evenOdd = false;
        this.handleManager = new EMFHandleManager();
        this.ros = os;
        this.initProperties(defaultProperties);
    }

    protected EMFGraphics2D(EMFGraphics2D graphics, boolean doRestoreOnDispose) {
        super(graphics, doRestoreOnDispose);
        this.os = graphics.os;
        this.imageBounds = graphics.imageBounds;
        this.handleManager = graphics.handleManager;
        this.fontTable = graphics.fontTable;
        this.unitFontTable = graphics.unitFontTable;
        this.pathConstructor = graphics.pathConstructor;
        this.evenOdd = graphics.evenOdd;
        this.parentGraphics = graphics;
    }

    public void writeHeader() throws IOException {
        Dimension device = this.isDeviceIndependent() ? new Dimension(1024, 768) : Toolkit.getDefaultToolkit().getScreenSize();
        String producer = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os = new EMFOutputStream(new BufferedOutputStream(this.ros), this.imageBounds, this.handleManager, this.getCreator(), producer, device);
        this.pathConstructor = new EMFPathConstructor(this.os, this.imageBounds);
        Point orig = new Point(this.imageBounds.x, this.imageBounds.y);
        Dimension size = new Dimension(this.imageBounds.width, this.imageBounds.height);
        this.os.writeTag(new SetMapMode(8));
        this.os.writeTag(new SetWindowOrgEx(orig));
        this.os.writeTag(new SetWindowExtEx(size));
        this.os.writeTag(new SetViewportOrgEx(orig));
        this.os.writeTag(new SetViewportExtEx(size));
        this.os.writeTag(new SetTextAlign(24));
        this.os.writeTag(new SetTextColor(this.getColor()));
        this.os.writeTag(new SetPolyFillMode(2));
    }

    public void writeGraphicsState() throws IOException {
        super.writeGraphicsState();
        AffineTransform n2 = AffineTransform.getScaleInstance(0.05, 0.05);
        this.os.writeTag(new ModifyWorldTransform(n2, 2));
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
            this.os.writeTag(new SetBkMode(1));
        } else if (this.isProperty(BACKGROUND)) {
            this.os.writeTag(new SetBkMode(2));
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.os.writeTag(new SetBkMode(2));
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        int handle;
        while ((handle = this.handleManager.highestHandleInUse()) >= 0) {
            this.os.writeTag(new DeleteObject(handle));
            this.handleManager.freeHandle(handle);
        }
        this.os.writeTag(new EOF());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        return new EMFGraphics2D(this, true);
    }

    public Graphics create(double x2, double y2, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        EMFGraphics2D graphics = new EMFGraphics2D(this, true);
        ((VectorGraphics)graphics).translate(x2, y2);
        ((VectorGraphics)graphics).clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.writeTag(new SaveDC());
    }

    protected void writeGraphicsRestore() throws IOException {
        if (this.penHandle != 0) {
            this.os.writeTag(new DeleteObject(this.handleManager.freeHandle(this.penHandle)));
        }
        if (this.brushHandle != 0) {
            this.os.writeTag(new DeleteObject(this.handleManager.freeHandle(this.brushHandle)));
        }
        this.os.writeTag(new RestoreDC());
        if (this.fontSet) {
            this.parentGraphics.fontSet = false;
        }
    }

    public void draw(Shape shape) {
        try {
            this.writePath(shape);
            this.os.writeTag(new StrokePath(this.imageBounds));
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void fill(Shape shape) {
        try {
            this.writePath(shape);
            this.os.writeTag(new FillPath(this.imageBounds));
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        try {
            this.writePath(shape);
            this.writeBrush(fillColor);
            this.os.writeTag(new StrokeAndFillPath(this.imageBounds));
            this.writeBrush(this.getColor());
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void copyArea(int x2, int y2, int width, int height, int dx, int dy) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        this.writeGraphicsSave();
        AffineTransform imageTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)image.getHeight());
        imageTransform.preConcatenate(xform);
        this.transform(imageTransform);
        this.os.writeTag(new AlphaBlend(this.imageBounds, this.toUnit(0.0), this.toUnit(0.0), this.toUnit(image.getWidth()), this.toUnit(image.getHeight()), new AffineTransform(), image, bkg));
        this.writeGraphicsRestore();
    }

    public void writeString(String string, double x2, double y2) throws IOException {
        if (!this.textColorSet) {
            Color textColor;
            this.textColorSet = true;
            Paint paint = this.getPaint();
            if (paint instanceof Color) {
                textColor = (Color)paint;
            } else if (paint instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)paint;
                textColor = PrintColor.mixColor(gp.getColor1(), gp.getColor2());
            } else {
                Color bkg = this.getBackground();
                textColor = bkg == null ? Color.BLACK : PrintColor.invert(bkg);
            }
            this.os.writeTag(new SetTextColor(textColor));
        }
        Font font = this.getFont();
        Font unitFont = (Font)this.unitFontTable.get(font);
        if (!this.fontSet) {
            Integer fontIndex = (Integer)this.fontTable.get(font);
            if (fontIndex == null) {
                String fontName = font.getName();
                string = FontUtilities.getEncodedString(string, fontName);
                fontName = replaceFonts.getProperty(fontName, fontName);
                String windowsFontName = FontUtilities.getWindowsFontName(fontName);
                unitFont = new Font(windowsFontName, font.getStyle(), font.getSize());
                unitFont = unitFont.deriveFont(font.getSize2D() * 1.0f * 20.0f);
                this.unitFontTable.put(font, unitFont);
                ExtLogFontW logFontW = new ExtLogFontW(unitFont);
                int handle = this.handleManager.getHandle();
                this.os.writeTag(new ExtCreateFontIndirectW(handle, logFontW));
                fontIndex = new Integer(handle);
                this.fontTable.put(font, fontIndex);
            }
            this.os.writeTag(new SelectObject(fontIndex));
            this.fontSet = true;
        }
        int[] widths = new int[string.length()];
        int i2 = 0;
        while (i2 < widths.length) {
            double w2 = unitFont.getStringBounds(string, i2, i2 + 1, this.getFontRenderContext()).getWidth();
            widths[i2] = (int)w2;
            ++i2;
        }
        TextW text = new TextW(new Point(this.toUnit(x2), this.toUnit(y2)), string, 0, dummy, widths);
        this.os.writeTag(new ExtTextOutW(this.imageBounds, 2, 1.0f, 1.0f, text));
    }

    public void drawString(AttributedCharacterIterator iterator, float x2, float y2) {
        this.writeWarning(this.getClass() + ": drawString(AttributedCharacterIterator, float, float) not implemented.");
    }

    public void drawGlyphVector(GlyphVector glyphs, float x2, float y2) {
        this.writeWarning(this.getClass() + ": drawGlyphVector(GlyphVector, float, float) not implemented.");
        int i2 = 0;
        while (i2 < glyphs.getNumGlyphs()) {
            this.fill(glyphs.getGlyphOutline(i2, x2, y2));
            ++i2;
        }
    }

    protected void writeTransform(AffineTransform t2) throws IOException {
        AffineTransform n2 = new AffineTransform(t2.getScaleX(), t2.getShearY(), t2.getShearX(), t2.getScaleY(), t2.getTranslateX() * 1.0 * 20.0, t2.getTranslateY() * 1.0 * 20.0);
        this.os.writeTag(new ModifyWorldTransform(n2, 2));
    }

    protected void writeSetClip(Shape s2) throws IOException {
        if (s2 instanceof RectangularShape) {
            RectangularShape r2 = (RectangularShape)s2;
            AffineTransform currentTransform = this.getTransform();
            Point2D xy = currentTransform.transform(new Point2D.Double(r2.getMinX(), r2.getMinY()), null);
            Point2D wh = currentTransform.deltaTransform(new Point2D.Double(r2.getWidth(), r2.getHeight()), null);
            Rectangle rgn = new Rectangle((int)xy.getX(), (int)xy.getY(), (int)wh.getX(), (int)wh.getY());
            this.os.writeTag(new ExtSelectClipRgn(5, new Region(this.imageBounds, rgn)));
        } else {
            this.clip(s2);
        }
    }

    protected void writeClip(Rectangle2D r2d) throws IOException {
        if (r2d == null) {
            return;
        }
        AffineTransform currentTransform = this.getTransform();
        Point2D xy = currentTransform.transform(new Point2D.Double(r2d.getX(), r2d.getY()), null);
        Point2D wh = currentTransform.deltaTransform(new Point2D.Double(r2d.getWidth(), r2d.getHeight()), null);
        Rectangle rgn = new Rectangle((int)xy.getX(), (int)xy.getY(), (int)wh.getX(), (int)wh.getY());
        this.os.writeTag(new ExtSelectClipRgn(1, new Region(this.imageBounds, rgn)));
    }

    protected void writeClip(Shape s2) throws IOException {
        if (s2 == null) {
            return;
        }
        this.writePath(s2);
        this.os.writeTag(new SelectClipPath(1));
    }

    public void writeStroke(Stroke stroke) throws IOException {
        if (stroke instanceof BasicStroke) {
            this.writePen((BasicStroke)stroke, this.getColor());
        }
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color p2) throws IOException {
        this.writePen((BasicStroke)this.getStroke(), p2);
        this.writeBrush(p2);
        this.textColorSet = false;
    }

    protected void writePaint(GradientPaint p2) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(GradientPaint) not implemented.");
    }

    protected void writePaint(TexturePaint p2) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(TexturePaint) not implemented.");
    }

    protected void writePaint(Paint p2) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + p2.getClass());
    }

    public void setFont(Font font) {
        if (!font.equals(this.getFont())) {
            this.fontSet = false;
        }
        super.setFont(font);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s2, boolean onStroke) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String comment) throws IOException {
        this.writeWarning(this.getClass() + ": writeComment(String) not implemented.");
    }

    public String toString() {
        return "EMFGraphics2D";
    }

    protected GeneralPath createShape(double[] xPoints, double[] yPoints, int nPoints, boolean close) {
        GeneralPath path = new GeneralPath(0);
        if (nPoints > 0) {
            path.moveTo((float)xPoints[0], (float)yPoints[0]);
            double lastX = xPoints[0];
            double lastY = yPoints[0];
            if (close && Math.abs(xPoints[nPoints - 1] - lastX) < 1.0 && Math.abs(yPoints[nPoints - 1] - lastY) < 1.0) {
                --nPoints;
            }
            int i2 = 1;
            while (i2 < nPoints) {
                if (Math.abs(xPoints[i2] - lastX) > 1.0 || Math.abs(yPoints[i2] - lastY) > 1.0) {
                    path.lineTo((float)xPoints[i2], (float)yPoints[i2]);
                    lastX = xPoints[i2];
                    lastY = yPoints[i2];
                }
                ++i2;
            }
            if (close) {
                path.closePath();
            }
        }
        return path;
    }

    private boolean writePath(Shape shape) throws IOException {
        boolean eo = EMFPathConstructor.isEvenOdd(shape);
        if (eo != this.evenOdd) {
            this.evenOdd = eo;
            this.os.writeTag(new SetPolyFillMode(this.evenOdd ? 1 : 2));
        }
        this.os.writeTag(new BeginPath());
        this.pathConstructor.addPath(shape);
        this.os.writeTag(new EndPath());
        return this.evenOdd;
    }

    private void writePen(BasicStroke stroke, Color color) throws IOException {
        int style = 65536;
        switch (stroke.getEndCap()) {
            case 0: {
                style |= 0x200;
                break;
            }
            case 1: {
                style |= 0;
                break;
            }
            case 2: {
                style |= 0x100;
            }
        }
        switch (stroke.getLineJoin()) {
            case 0: {
                style |= 0x2000;
                break;
            }
            case 1: {
                style |= 0;
                break;
            }
            case 2: {
                style |= 0x1000;
            }
        }
        float[] dashArray = stroke.getDashArray();
        int[] dash = new int[dashArray != null ? dashArray.length : 0];
        style |= dash.length == 0 ? 0 : 7;
        int i2 = 0;
        while (i2 < dash.length) {
            dash[i2] = this.toUnit(dashArray[i2]);
            ++i2;
        }
        ExtLogPen pen = new ExtLogPen(style, this.toUnit(stroke.getLineWidth()), 0, this.getPrintColor(color), 0, dash);
        if (this.penHandle != 0) {
            this.os.writeTag(new DeleteObject(this.penHandle));
        } else {
            this.penHandle = this.handleManager.getHandle();
        }
        this.os.writeTag(new ExtCreatePen(this.penHandle, pen));
        this.os.writeTag(new SelectObject(this.penHandle));
        this.os.writeTag(new SetMiterLimit(this.toUnit(stroke.getMiterLimit())));
    }

    private void writeBrush(Color color) throws IOException {
        LogBrush32 brush = new LogBrush32(0, this.getPrintColor(color), 0);
        if (this.brushHandle != 0) {
            this.os.writeTag(new DeleteObject(this.brushHandle));
        } else {
            this.brushHandle = this.handleManager.getHandle();
        }
        this.os.writeTag(new CreateBrushIndirect(this.brushHandle, brush));
        this.os.writeTag(new SelectObject(this.brushHandle));
    }

    private int toUnit(double d2) {
        return (int)Math.floor(d2 * 1.0 * 20.0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        replaceFonts = new Properties();
        replaceFonts.setProperty("Symbol", "Arial Unicode MS");
        replaceFonts.setProperty("ZapfDingbats", "Arial Unicode MS");
    }
}

