/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class EMFPolygon
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPoints;
    private Point[] points;

    EMFPolygon() {
        super(3, 1);
    }

    public EMFPolygon(Rectangle bounds, int numberOfPoints, Point[] points) {
        this();
        this.bounds = bounds;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle r2 = emf.readRECTL();
        int n2 = emf.readDWORD();
        EMFPolygon tag = new EMFPolygon(r2, n2, emf.readPOINTL(n2));
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.numberOfPoints);
        emf.writePOINTL(this.numberOfPoints, this.points);
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #points: " + this.numberOfPoints;
    }
}

