/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class GDIComment
extends EMFTag {
    private String comment;

    GDIComment() {
        super(70, 1);
    }

    public GDIComment(String comment) {
        this();
        this.comment = comment;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int l2 = emf.readDWORD();
        GDIComment tag = new GDIComment(new String(emf.readBYTE(l2)));
        if (l2 % 4 != 0) {
            emf.readBYTE(4 - l2 % 4);
        }
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        byte[] b2 = this.comment.getBytes();
        emf.writeDWORD(b2.length);
        emf.writeBYTE(b2);
        if (b2.length % 4 != 0) {
            int i2 = 0;
            while (i2 < 4 - b2.length % 4) {
                emf.writeBYTE(0);
                ++i2;
            }
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  length: " + this.comment.length();
    }
}

