/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.freehep.graphicsio.font.truetype.TTFInput;

public class TTFFileInput
extends TTFInput {
    private RandomAccessFile ttf;
    private long offset;
    private long length;
    private long checksum;

    public TTFFileInput(RandomAccessFile file, long offset, long length, long checksum) throws IOException {
        this.ttf = file;
        this.offset = offset;
        this.length = length;
        this.checksum = checksum;
    }

    public void seek(long offset) throws IOException {
        this.ttf.seek(this.offset + offset);
    }

    long getPointer() throws IOException {
        return this.ttf.getFilePointer() - this.offset;
    }

    public int readByte() throws IOException {
        return this.ttf.readUnsignedByte();
    }

    public int readRawByte() throws IOException {
        return this.ttf.readByte() & 0xFF;
    }

    public short readShort() throws IOException {
        return this.ttf.readShort();
    }

    public int readUShort() throws IOException {
        return this.ttf.readUnsignedShort();
    }

    public int readLong() throws IOException {
        return this.ttf.readInt();
    }

    public long readULong() throws IOException {
        byte[] temp = new byte[4];
        this.ttf.readFully(temp);
        long l2 = 0L;
        long weight = 1L;
        int i2 = 0;
        while (i2 < temp.length) {
            l2 += (long)(temp[3 - i2] & 0xFF) * weight;
            weight *= 256L;
            ++i2;
        }
        return l2;
    }

    public byte readChar() throws IOException {
        return this.ttf.readByte();
    }

    public void readFully(byte[] b2) throws IOException {
        this.ttf.readFully(b2);
    }

    public String toString() {
        return this.offset + "-" + (this.offset + this.length - 1L);
    }
}

