/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.freehep.graphicsio.font.FontIncluder;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.font.encoding.CharTable;
import org.freehep.graphicsio.font.encoding.Lookup;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType1;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType3;
import org.freehep.graphicsio.pdf.PDFFontIncluder;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontTable
extends FontTable {
    private int currentFontIndex = 1;
    private PDFWriter pdf;
    private PDFRedundanceTracker tracker;
    private static final Properties replaceFonts = new Properties();

    public PDFFontTable(PDFWriter pdf) {
        this.pdf = pdf;
        this.tracker = new PDFRedundanceTracker(pdf);
    }

    public int addFontDictionary() throws IOException {
        Collection fonts = this.getEntries();
        if (fonts.size() > 0) {
            PDFDictionary fontList = this.pdf.openDictionary("FontList");
            Iterator i2 = fonts.iterator();
            while (i2.hasNext()) {
                FontTable.Entry e2 = (FontTable.Entry)i2.next();
                fontList.entry(e2.getReference(), this.pdf.ref(e2.getReference()));
            }
            this.pdf.close(fontList);
        }
        return fonts.size();
    }

    public void embedAll(FontRenderContext context, boolean embed, String embedAs) throws IOException {
        Collection col = this.getEntries();
        Iterator i2 = col.iterator();
        while (i2.hasNext()) {
            FontTable.Entry e2 = (FontTable.Entry)i2.next();
            if (e2.isWritten()) continue;
            e2.setWritten(true);
            FontIncluder fontIncluder = null;
            if (PDFFontIncluder.isStandardFont(e2.getFont())) {
                embed = false;
            }
            if (embed) {
                if (embedAs.equals("Type3")) {
                    fontIncluder = new PDFFontEmbedderType3(context, this.pdf, e2.getReference(), this.tracker);
                } else if (embedAs.equals("Type1")) {
                    fontIncluder = PDFFontEmbedderType1.create(context, this.pdf, e2.getReference(), this.tracker);
                } else {
                    System.out.println("PDFFontTable: invalid value for embedAs: " + embedAs);
                }
            } else {
                fontIncluder = new PDFFontIncluder(context, this.pdf, e2.getReference(), this.tracker);
            }
            fontIncluder.includeFont(e2.getFont(), e2.getEncoding(), e2.getReference());
        }
        this.tracker.writeAll();
    }

    public CharTable getEncodingTable() {
        return Lookup.getInstance().getTable("PDFLatin");
    }

    public void firstRequest(FontTable.Entry e2, boolean embed, String embedAs) {
    }

    protected Font substituteFont(Font font) {
        String fontName = replaceFonts.getProperty(font.getName(), null);
        if (fontName != null) {
            Font newFont = new Font(fontName, font.getSize(), font.getStyle());
            font = newFont.deriveFont(font.getSize2D());
        }
        return font;
    }

    protected String createFontReference(Font f2) {
        return "F" + this.currentFontIndex++;
    }

    static {
        replaceFonts.setProperty("Dialog", "Helvetica");
        replaceFonts.setProperty("DialogInput", "Helvetica");
        replaceFonts.setProperty("Serif", "TimesRoman");
        replaceFonts.setProperty("SansSerif", "Helvetica");
        replaceFonts.setProperty("Monospaced", "Courier");
    }
}

