/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.ImageEncoder;

public class EPSIEncoder
extends ImageEncoder {
    static final int maxBitsPerByte = 8;
    static final int maxBytesPerScan = 128;
    private int grayscaleBits;
    private boolean portrait;
    int width;
    int height;
    byte[][] grayPixels;
    Scanline scanline;
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] lowBitMask = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};

    public EPSIEncoder(Image img, OutputStream out, int grayscaleBits, boolean portrait) throws IOException {
        super(img, (DataOutput)new DataOutputStream(out));
        this.grayscaleBits = grayscaleBits;
        this.portrait = portrait;
    }

    public EPSIEncoder(ImageProducer prod, OutputStream out, int grayscaleBits, boolean portrait) throws IOException {
        super(prod, (DataOutput)new DataOutputStream(out));
        this.grayscaleBits = grayscaleBits;
        this.portrait = portrait;
    }

    protected void encodeStart(int width, int height) throws IOException {
        int h2;
        int w2;
        this.width = width;
        this.height = height;
        this.grayPixels = new byte[height][width];
        if (this.portrait) {
            w2 = width;
            h2 = height;
        } else {
            w2 = height;
            h2 = width;
        }
        int bitsPerScan = w2 * this.grayscaleBits;
        int bytesPerScan = bitsPerScan / 8 + (bitsPerScan % 8 == 0 ? 0 : 1);
        int linesPerScan = bytesPerScan / 128 + (bytesPerScan % 128 == 0 ? 0 : 1);
        int lines = linesPerScan * h2;
        this.scanline = new Scanline(bytesPerScan, this.grayscaleBits);
        this.putString("%%BeginPreview " + width + " " + height + " " + this.grayscaleBits + " " + lines + "\n");
    }

    protected void encodePixels(int x2, int y2, int w2, int h2, int[] rgbPixels, int off, int scansize) throws IOException {
        int row = 0;
        while (row < h2) {
            int column = 0;
            while (column < w2) {
                this.grayPixels[y2 + row][column] = this.toGrayscale(rgbPixels[row * scansize + off + column]);
                ++column;
            }
            ++row;
        }
    }

    private byte toGrayscale(int argb) {
        int mask = 255;
        double blue = (double)(argb >> 0 & mask) / 255.0;
        double green = (double)(argb >> 8 & mask) / 255.0;
        double red = (double)(argb >> 16 & mask) / 255.0;
        return (byte)(255.0 * Math.max(0.0, 1.0 - (0.3 * red + 0.59 * green + 0.11 * blue)));
    }

    protected void encodeDone() throws IOException {
        if (this.portrait) {
            int row = this.height - 1;
            while (row >= 0) {
                this.scanline.reset();
                int col = 0;
                while (col < this.width) {
                    byte gray = this.grayPixels[row][col];
                    this.scanline.add(gray);
                    ++col;
                }
                this.scanline.put();
                --row;
            }
        } else {
            int col = this.width - 1;
            while (col >= 0) {
                this.scanline.reset();
                int row = this.height - 1;
                while (row >= 0) {
                    byte gray = this.grayPixels[row][col];
                    this.scanline.add(gray);
                    --row;
                }
                this.scanline.put();
                --col;
            }
        }
        this.putString("%%EndPreview\n");
    }

    void putString(String s2) throws IOException {
        this.out.write(s2.getBytes());
    }

    void putChar(char c2) throws IOException {
        this.out.write(c2);
    }

    void putByte(byte b2) throws IOException {
        int highNibble = b2 >> 4 & 0xF;
        int lowNibble = b2 & 0xF;
        this.out.write(hexDigit[highNibble]);
        this.out.write(hexDigit[lowNibble]);
    }

    private class Scanline {
        private byte[] line;
        private int nbits;
        private int currentByte;
        private int currentOffset;

        public Scanline(int size, int nbits) {
            this.line = new byte[size];
            this.nbits = nbits;
            this.reset();
        }

        public void reset() {
            this.currentByte = 0;
            this.currentOffset = 0;
            int i2 = 0;
            while (i2 < this.line.length) {
                this.line[i2] = 0;
                ++i2;
            }
        }

        public void add(byte b2) {
            b2 = (byte)(b2 >> 8 - this.nbits);
            b2 = (byte)(b2 & lowBitMask[this.nbits]);
            int n2 = this.currentByte++;
            this.line[n2] = (byte)(this.line[n2] | b2);
            if (8 - this.nbits - this.currentOffset == 0) {
                this.currentOffset = 0;
            } else {
                this.currentOffset += this.nbits;
                int n3 = this.currentByte;
                this.line[n3] = (byte)(this.line[n3] << this.nbits);
            }
        }

        public void put() throws IOException {
            while (8 - this.nbits - this.currentOffset > 0) {
                int n2 = this.line.length - 1;
                this.line[n2] = (byte)(this.line[n2] << this.nbits);
                this.currentOffset += this.nbits;
            }
            int i2 = 0;
            while (i2 < this.line.length) {
                if (i2 % 128 == 0) {
                    if (i2 != 0) {
                        EPSIEncoder.this.putChar('\n');
                    }
                    EPSIEncoder.this.putChar('%');
                }
                EPSIEncoder.this.putByte(this.line[i2]);
                ++i2;
            }
            EPSIEncoder.this.putChar('\n');
        }
    }
}

